/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.projectsynchronization;

import csbase.client.applications.projectsynchronization.ContainerSelectionProjects;
import csbase.client.applications.projectsynchronization.StepProjectSynchronization;
import csbase.client.applications.projectsynchronization.StepSelectionFilesA;
import csbase.client.desktop.RemoteTask;
import csbase.client.util.StandardErrorDialogs;
import csbase.exception.ServiceFailureException;
import csbase.logic.ProjectSynchronizationData;
import csbase.logic.ProjectSynchronizationListProjects;
import csbase.logic.UserProjectInfo;
import csbase.logic.applicationservice.ApplicationRegistry;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.ProjectSynchronizationServiceInterface;
import java.awt.Container;
import java.awt.event.ItemListener;
import java.util.Iterator;
import java.util.List;
import tecgraf.javautils.gui.wizard.History;
import tecgraf.javautils.gui.wizard.Step;
import tecgraf.javautils.gui.wizard.WasChangedItemListener;
import tecgraf.javautils.gui.wizard.WizardException;

public class StepSelectionProjects
extends StepProjectSynchronization {
    private ContainerSelectionProjects containerSelectionProjects;
    protected ProjectSynchronizationData data;
    private boolean sameProjectFlag;
    private List listProjectsServerA;
    private List listProjectsServerB;
    private ApplicationRegistry registry;
    private String error;

    public StepSelectionProjects(ApplicationRegistry registry) {
        this.registry = registry;
        this.containerSelectionProjects = new ContainerSelectionProjects(registry);
    }

    private int getSelectIndexProjectA() {
        return this.containerSelectionProjects.getProjectsSelectionA().getCbProjetos().getSelectedIndex();
    }

    private int getSelectIndexProjectB() {
        return this.containerSelectionProjects.getProjectsSelectionB().getCbProjetos().getSelectedIndex();
    }

    private Object getSelectItemProjectA() {
        UserProjectInfo project = (UserProjectInfo)this.containerSelectionProjects.getProjectsSelectionA().getCbProjetos().getSelectedItem();
        return project != null ? project.getProjectId() : null;
    }

    private Object getSelectItemProjectB() {
        UserProjectInfo project = (UserProjectInfo)this.containerSelectionProjects.getProjectsSelectionB().getCbProjetos().getSelectedItem();
        return project != null ? project.getProjectId() : null;
    }

    private String getSelectItemProjectNameA() {
        UserProjectInfo project = (UserProjectInfo)this.containerSelectionProjects.getProjectsSelectionA().getCbProjetos().getSelectedItem();
        return project != null ? project.getProjectName() : null;
    }

    private String getSelectItemProjectNameB() {
        UserProjectInfo project = (UserProjectInfo)this.containerSelectionProjects.getProjectsSelectionB().getCbProjetos().getSelectedItem();
        return project != null ? project.getProjectName() : null;
    }

    protected void enter(History history) throws WizardException {
        this.error = null;
        this.data = (ProjectSynchronizationData)history.get(null, "data");
        this.sameProjectFlag = (Boolean)history.get(null, "sameProjectFlag");
        this.containerSelectionProjects.getProjectsSelectionA().getCbProjetos().removeAllItems();
        this.containerSelectionProjects.getProjectsSelectionB().getCbProjetos().removeAllItems();
        RemoteTask<ProjectSynchronizationListProjects> task = new RemoteTask<ProjectSynchronizationListProjects>(){

            protected void performTask() throws Exception {
                ProjectSynchronizationServiceInterface psi = ClientRemoteLocator.projectSynchronizationService;
                ProjectSynchronizationListProjects pslp = psi.buildListProjects(StepSelectionProjects.this.data);
                this.setResult(pslp);
            }

            @Override
            protected void handleError(Exception e) {
                if (e instanceof ServiceFailureException) {
                    StandardErrorDialogs.showErrorDialog(null, "SYNC", e.getMessage());
                } else {
                    super.handleError(e);
                }
            }
        };
        if (!task.execute(null, this.getTitle(), this.registry.getString("step2.getProjectsContents"), 0, 0)) {
            if (!task.wasCancelled()) {
                Exception re = task.getError();
                this.error = re.getMessage();
                history.addGlobal("error", (Object)this.error);
            }
            return;
        }
        ProjectSynchronizationListProjects pslp = (ProjectSynchronizationListProjects)task.getResult();
        this.listProjectsServerA = pslp.getProjectsServerA();
        this.listProjectsServerB = pslp.getProjectsServerB();
        Integer indexA = (Integer)history.get(null, "indexA");
        Integer indexB = (Integer)history.get(null, "indexB");
        this.populateComboBox(indexA, indexB);
        this.containerSelectionProjects.getProjectsSelectionA().getCbProjetos().addItemListener((ItemListener)new WasChangedItemListener((Step)this));
        this.containerSelectionProjects.getProjectsSelectionB().getCbProjetos().addItemListener((ItemListener)new WasChangedItemListener((Step)this));
    }

    private void populateComboBox(Integer indexA, Integer indexB) {
        Iterator i = this.listProjectsServerA.iterator();
        while (i.hasNext()) {
            this.containerSelectionProjects.getProjectsSelectionA().getCbProjetos().addItem(i.next());
        }
        i = this.listProjectsServerB.iterator();
        while (i.hasNext()) {
            this.containerSelectionProjects.getProjectsSelectionB().getCbProjetos().addItem(i.next());
        }
        int sizeA = this.containerSelectionProjects.getProjectsSelectionA().getCbProjetos().getItemCount();
        int sizeB = this.containerSelectionProjects.getProjectsSelectionB().getCbProjetos().getItemCount();
        if (indexA == -1 && sizeA > 0) {
            indexA = 0;
        }
        if (indexB == -1 && sizeB > 0) {
            indexB = 0;
        }
        this.containerSelectionProjects.getProjectsSelectionA().getCbProjetos().setSelectedIndex(indexA);
        this.containerSelectionProjects.getProjectsSelectionB().getCbProjetos().setSelectedIndex(indexB);
    }

    protected Container getContainer() {
        return this.containerSelectionProjects.getRootPanel();
    }

    protected String getInstruction() {
        if (this.error == null) {
            return this.registry.getString("instruction.step2");
        }
        return this.error;
    }

    protected Class getNext(History arg0) {
        return StepSelectionFilesA.class;
    }

    protected String getTitle() {
        return this.registry.getString("title.step2");
    }

    @Override
    protected boolean isReady() {
        if (this.getSelectIndexProjectA() > -1 && this.getSelectIndexProjectB() > -1) {
            if (this.sameProjectFlag) {
                if (!this.getSelectItemProjectNameA().equalsIgnoreCase(this.getSelectItemProjectNameB())) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    protected void exit(History history) {
        if (this.getSelectItemProjectA() != null && this.getSelectItemProjectB() != null) {
            this.data.getUnitA().setProjectId(this.getSelectItemProjectA());
            this.data.getUnitB().setProjectId(this.getSelectItemProjectB());
            RemoteTask<ProjectSynchronizationData> task = new RemoteTask<ProjectSynchronizationData>(){

                protected void performTask() throws Exception {
                    ProjectSynchronizationServiceInterface psi = ClientRemoteLocator.projectSynchronizationService;
                    ProjectSynchronizationData psd = psi.buildTransferMaps(StepSelectionProjects.this.data);
                    this.setResult(psd);
                }
            };
            if (!task.execute(null, this.getTitle(), this.registry.getString("step2.buildTransferList"), 0, 0)) {
                if (!task.wasCancelled()) {
                    Exception re = task.getError();
                    history.addGlobal("error", (Object)re.getMessage());
                }
                return;
            }
            this.data = (ProjectSynchronizationData)task.getResult();
            history.addGlobal("data", (Object)this.data);
            history.addGlobal("indexA", (Object)new Integer(this.getSelectIndexProjectA()));
            history.addGlobal("indexB", (Object)new Integer(this.getSelectIndexProjectB()));
            history.addGlobal("projectNameA", (Object)this.getSelectItemProjectNameA());
            history.addGlobal("projectNameB", (Object)this.getSelectItemProjectNameB());
        }
    }
}

