/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.serverdiagnostic.monitor;

import csbase.client.applications.serverdiagnostic.monitor.TextRenderer;
import csbase.logic.diagnosticservice.ResourceProperty;
import csbase.logic.diagnosticservice.Status;
import csbase.logic.diagnosticservice.ValidationStatus;
import java.util.List;

public class DefaultTextRenderer
implements TextRenderer {
    @Override
    public String getHeadline(Status status) {
        StringBuffer headline = new StringBuffer(status.getResourceName());
        headline.append(": ");
        headline.append(status.getCode());
        headline.append("\n");
        headline.append("[");
        headline.append(status.getTimestamp());
        headline.append("]");
        return headline.toString();
    }

    @Override
    public String getDetails(Status status) {
        StringBuffer detail = new StringBuffer();
        detail.append(this.getValidationStatuses(status));
        detail.append(this.getProperties(status));
        return detail.toString();
    }

    private String getValidationStatuses(Status status) {
        StringBuffer validationsStatus = new StringBuffer();
        ValidationStatus[] validationStatusArray = status.getValidationStatusList();
        int n = validationStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            ValidationStatus se = validationStatusArray[n2];
            validationsStatus.append(se.code);
            validationsStatus.append(" ");
            validationsStatus.append(se.message);
            validationsStatus.append("\n");
            ++n2;
        }
        return validationsStatus.toString();
    }

    private String getProperties(Status status) {
        List props = status.getProperties();
        StringBuffer parameters = new StringBuffer();
        for (ResourceProperty p : props) {
            parameters.append(p.name);
            parameters.append(" = ");
            parameters.append(p.value);
            parameters.append("\n");
        }
        return parameters.toString();
    }
}

