/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.statsviewer;

import csbase.client.applications.statsviewer.LogsView;
import csbase.client.applications.statsviewer.StatsViewer;
import csbase.logic.eventlogservice.LogsInfo;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import tecgraf.javautils.gui.GBC;

public class FilterPanel
extends JPanel {
    private final StatsViewer appViewer;
    private JPanel cardsPanel;
    private JList applicationsList;
    private JList algorithmsList;

    public FilterPanel(StatsViewer appViewer) {
        super(new GridBagLayout());
        this.appViewer = appViewer;
        this.buildCardPanel();
    }

    private void buildCardPanel() {
        this.cardsPanel = new JPanel(new CardLayout());
        this.cardsPanel.add((Component)this.buildApplicationsPanel(), LogsView.LogsDataType.ApplicationsData.name());
        this.cardsPanel.add((Component)this.buildAlgorihtmsPanel(), LogsView.LogsDataType.ExecutionsData.name());
        this.cardsPanel.add((Component)new JPanel(), LogsView.LogsDataType.LoginData.name());
        this.add((Component)this.cardsPanel, new GBC(0, 0).center().insets(10, 10, 5, 10).both());
    }

    private JPanel buildApplicationsPanel() {
        this.applicationsList = new JList(new DefaultListModel());
        this.applicationsList.setSelectionMode(2);
        this.applicationsList.setLayoutOrientation(0);
        this.applicationsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                List selecteds = FilterPanel.this.getSelected(FilterPanel.this.applicationsList);
                FilterPanel.this.appViewer.filterApplications(selecteds);
            }
        });
        JScrollPane scrollApplications = new JScrollPane(this.applicationsList, 22, 30);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new JLabel(this.appViewer.getString("filterPanel.applications")), "North");
        panel.add((Component)scrollApplications, "Center");
        return panel;
    }

    private JPanel buildAlgorihtmsPanel() {
        this.algorithmsList = new JList(new DefaultListModel());
        this.algorithmsList.setSelectionMode(2);
        this.algorithmsList.setLayoutOrientation(0);
        this.algorithmsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                List selecteds = FilterPanel.this.getSelected(FilterPanel.this.algorithmsList);
                FilterPanel.this.appViewer.filterAlgorithms(selecteds);
            }
        });
        JScrollPane scrollAlgorithms = new JScrollPane(this.algorithmsList, 22, 30);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new JLabel(this.appViewer.getString("filterPanel.algorithms")), "North");
        panel.add((Component)scrollAlgorithms, "Center");
        return panel;
    }

    private List<String> getSelected(JList list) {
        int[] selectedIndices = list.getSelectedIndices();
        if (selectedIndices == null) {
            return null;
        }
        DefaultListModel model = (DefaultListModel)list.getModel();
        ArrayList<String> strList = new ArrayList<String>();
        int[] nArray = selectedIndices;
        int n = selectedIndices.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            String value = (String)model.get(index);
            strList.add(value);
            ++n2;
        }
        return strList;
    }

    public void setLogType(LogsView.LogsDataType selectedType) {
        CardLayout cl = (CardLayout)this.cardsPanel.getLayout();
        cl.show(this.cardsPanel, selectedType.name());
    }

    public void updateInfo(LogsInfo info) {
        DefaultListModel appModel = (DefaultListModel)this.applicationsList.getModel();
        appModel.clear();
        for (String app : info.getApplications()) {
            appModel.addElement(app);
        }
        this.applicationsList.setSelectionInterval(0, appModel.getSize() - 1);
        DefaultListModel algoModel = (DefaultListModel)this.algorithmsList.getModel();
        algoModel.clear();
        for (String algo : info.getAlgorithms()) {
            algoModel.addElement(algo);
        }
        this.algorithmsList.setSelectionInterval(0, algoModel.getSize() - 1);
    }
}

