/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.csdk.v1_0.command;

import csbase.client.csdk.v1_0.command.CSDKCommandInfo;
import csbase.client.csdk.v1_0.core.CSDKAbstractContext;
import csbase.client.csdk.v1_0.filesystem.CSDKFile;
import csbase.client.desktop.RemoteTask;
import csbase.client.facilities.algorithms.executor.AlgorithmCommandExecutor;
import csbase.client.facilities.algorithms.executor.CommandObserver;
import csbase.client.facilities.algorithms.executor.FlowCommandExecutor;
import csbase.client.facilities.algorithms.parameters.FlowParametersValues;
import csbase.client.facilities.algorithms.parameters.NodeParametersValues;
import csbase.logic.ClientFile;
import csbase.logic.CommandNotification;
import csbase.logic.algorithms.AlgorithmVersionId;
import csdk.v1_0.api.command.CommandException;
import csdk.v1_0.api.command.IAlgorithmTemplate;
import csdk.v1_0.api.command.ICommandContext;
import csdk.v1_0.api.command.ICommandInfo;
import csdk.v1_0.api.command.ICommandObserver;
import csdk.v1_0.api.command.IFlowTemplate;
import java.awt.Window;
import java.util.HashMap;
import java.util.Map;
import tecgraf.javautils.core.lng.LNG;

public class CSDKCommandContext
extends CSDKAbstractContext
implements ICommandContext {
    public String executeAlgorithm(IAlgorithmTemplate template, final String description, final String sgaServerName, final Window owner, ICommandObserver observer) throws CommandException {
        String msg;
        CommandObserver commandObserver;
        final AlgorithmCommandExecutor executor = new AlgorithmCommandExecutor();
        final NodeParametersValues paramValues = this.createAlgorithmParameterConfiguration(template);
        RemoteTask<String> submissionTask = new RemoteTask<String>(commandObserver = this.createObserver(observer)){
            private final /* synthetic */ CommandObserver val$commandObserver;
            {
                this.val$commandObserver = commandObserver;
            }

            protected void performTask() throws Exception {
                this.setResult(executor.executeCommand(paramValues, description, sgaServerName, owner, this.val$commandObserver));
            }
        };
        if (!submissionTask.execute(owner, null, msg = LNG.get((String)(String.valueOf(CSDKCommandContext.class.getSimpleName()) + ".algorithm.submission.task")))) {
            String errorMsg = LNG.get((String)(String.valueOf(CSDKCommandContext.class.getSimpleName()) + ".algorithm.configuration.error"));
            throw new CommandException(errorMsg);
        }
        return (String)submissionTask.getResult();
    }

    public String executeFlow(IFlowTemplate template, String description, String sgaServerName, Window owner, ICommandObserver observer) throws CommandException {
        if (template.getFlowDefinitionFile() != null) {
            return this.executeFlowFromFile(template, description, sgaServerName, owner, observer);
        }
        return this.executeInstalledFlow(template, description, sgaServerName, owner, observer);
    }

    private String executeInstalledFlow(IFlowTemplate template, final String description, final String sgaServerName, final Window owner, ICommandObserver observer) throws CommandException {
        String msg;
        final FlowCommandExecutor executor = new FlowCommandExecutor();
        final CommandObserver commandObserver = this.createObserver(observer);
        final FlowParametersValues paramValues = this.createFlowParameterConfig(template);
        RemoteTask<String> submissionTask = new RemoteTask<String>(){

            protected void performTask() throws Exception {
                this.setResult(executor.executeCommand(paramValues, description, false, sgaServerName, owner, commandObserver));
            }
        };
        if (!submissionTask.execute(owner, null, msg = LNG.get((String)(String.valueOf(CSDKCommandContext.class.getSimpleName()) + ".flow.submission.task")))) {
            String errorMsg = LNG.get((String)(String.valueOf(CSDKCommandContext.class.getSimpleName()) + ".flow.configuration.error"));
            throw new CommandException(errorMsg);
        }
        return (String)submissionTask.getResult();
    }

    private String executeFlowFromFile(IFlowTemplate template, final String description, final String sgaServerName, final Window owner, ICommandObserver observer) throws CommandException {
        String msg;
        CSDKFile flowFile = (CSDKFile)template.getFlowDefinitionFile();
        final ClientFile file = flowFile.getFile();
        final FlowCommandExecutor executor = new FlowCommandExecutor();
        final CommandObserver commandObserver = this.createObserver(observer);
        final Map<Integer, NodeParametersValues> paramValues = this.createFlowParameterValues(template);
        RemoteTask<String> submissionTask = new RemoteTask<String>(){

            protected void performTask() throws Exception {
                this.setResult(executor.executeCommand(file, (Map<Integer, NodeParametersValues>)paramValues, description, false, sgaServerName, owner, commandObserver));
            }
        };
        if (!submissionTask.execute(owner, null, msg = LNG.get((String)(String.valueOf(CSDKCommandContext.class.getSimpleName()) + ".flow.submission.task")))) {
            String errorMsg = LNG.get((String)(String.valueOf(CSDKCommandContext.class.getSimpleName()) + ".flow.configuration.error"));
            throw new CommandException(errorMsg);
        }
        return (String)submissionTask.getResult();
    }

    private NodeParametersValues createAlgorithmParameterConfiguration(IAlgorithmTemplate template) {
        AlgorithmVersionId algorithmVersionId = this.createVersionId(template.getAlgorithmVersionId());
        NodeParametersValues paramValues = new NodeParametersValues(template.getAlgorithmName(), algorithmVersionId, template.getParametersValues());
        return paramValues;
    }

    private FlowParametersValues createFlowParameterConfig(IFlowTemplate template) {
        Map<Integer, NodeParametersValues> values = this.createFlowParameterValues(template);
        AlgorithmVersionId flowVersionId = this.createVersionId(template.getFlowVersionId());
        return new FlowParametersValues(template.getFlowName(), flowVersionId, values);
    }

    private Map<Integer, NodeParametersValues> createFlowParameterValues(IFlowTemplate template) {
        Map parametersValuesList = template.getParametersValuesByNodeId();
        HashMap<Integer, NodeParametersValues> values = new HashMap<Integer, NodeParametersValues>();
        for (Map.Entry nodeTemplate : parametersValuesList.entrySet()) {
            values.put((Integer)nodeTemplate.getKey(), this.createAlgorithmParameterConfiguration((IAlgorithmTemplate)nodeTemplate.getValue()));
        }
        return values;
    }

    private AlgorithmVersionId createVersionId(String id) {
        AlgorithmVersionId algorithmVersionId = AlgorithmVersionId.create((String)id);
        return algorithmVersionId;
    }

    private CommandObserver createObserver(final ICommandObserver observer) {
        if (observer == null) {
            return null;
        }
        CommandObserver commandObserver = new CommandObserver(){

            @Override
            public void notify(CommandNotification data) {
                CSDKCommandInfo cmdInfo = new CSDKCommandInfo(data);
                observer.onCommandEnd((ICommandInfo)cmdInfo);
            }
        };
        return commandObserver;
    }
}

