/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.csdk.v1_0.filesystem;

import csbase.client.ClientLocalFile;
import csbase.client.csdk.v1_0.filesystem.CSDKLocalFileLock;
import csbase.client.csdk.v1_0.filesystem.CSDKProjectFileLock;
import csbase.client.project.ClientFileLock;
import csbase.logic.ClientFile;
import csbase.logic.ClientFileType;
import csbase.logic.ClientProjectFile;
import csdk.v1_0.api.filesystem.FileLocationType;
import csdk.v1_0.api.filesystem.FileLockedException;
import csdk.v1_0.api.filesystem.IFile;
import csdk.v1_0.api.filesystem.IFileLock;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import tecgraf.javautils.core.io.FileUtils;

public class CSDKFile
implements IFile {
    private final ClientFile file;

    public CSDKFile(ClientFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Par\u00e2metro file n\u00e3o pode ser nulo");
        }
        this.file = file;
    }

    public void close(boolean force) throws IOException {
        this.file.close(force);
    }

    public void close() throws IOException {
        this.file.close(true);
    }

    public IFile[] getChildren() throws Exception {
        ClientFile[] children = this.file.getChildren();
        ArrayList<CSDKFile> files = new ArrayList<CSDKFile>();
        ClientFile[] clientFileArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            ClientFile clientProjectFile = clientFileArray[n2];
            files.add(new CSDKFile(clientProjectFile));
            ++n2;
        }
        return files.toArray(new IFile[files.size()]);
    }

    public InputStream getInputStream() throws IOException {
        return this.file.getInputStream();
    }

    public long getModificationDate() {
        return this.file.getModificationDate();
    }

    public String getName() {
        return this.file.getName();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.file.getOutputStream();
    }

    public String[] getPath() {
        return this.file.getPath();
    }

    public String getStringPath() {
        return this.file.getStringPath();
    }

    public String getType() {
        return this.file.getType();
    }

    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    public void open(boolean readOnly) throws Exception {
        this.file.open(readOnly);
    }

    public long position() throws IOException {
        return this.file.position();
    }

    public void position(long newPosition) throws IOException {
        this.file.position(newPosition);
    }

    public int read(byte[] dst, int off, int len, long position) throws Exception {
        return this.file.read(dst, off, len, position);
    }

    public int read(byte[] dst, long position) throws Exception {
        return this.file.read(dst, position);
    }

    public long size() {
        return this.file.size();
    }

    public void write(byte[] src, int off, int len, long position) throws IOException, FileLockedException {
        this.file.write(src, off, len, position);
    }

    public void write(byte[] src, long position) throws IOException, FileLockedException {
        this.file.write(src, position);
    }

    public FileLocationType getFileLocationType() {
        switch (this.file.getClientFileType()) {
            case LOCAL: {
                return FileLocationType.LOCAL;
            }
            case REMOTE: {
                return FileLocationType.REMOTE;
            }
        }
        return null;
    }

    public ClientFile getFile() {
        return this.file;
    }

    public IFile getParent() {
        return new CSDKFile(this.file.getParent());
    }

    public boolean exists() throws IOException {
        return this.file.exists();
    }

    public boolean canExecute() {
        return this.file.canExecute();
    }

    public boolean canRead() {
        return this.file.canRead();
    }

    public boolean canWrite() {
        return this.file.canWrite();
    }

    public IFileLock acquireExclusiveLock(Window window) throws Exception {
        if (this.file.getClientFileType() == ClientFileType.REMOTE) {
            ClientProjectFile projectFile = (ClientProjectFile)this.file;
            return new CSDKProjectFileLock(ClientFileLock.acquireExclusiveLock(window, projectFile));
        }
        ClientLocalFile clientlocalFile = (ClientLocalFile)this.file;
        String[] path = clientlocalFile.getPath();
        File localFile = new File(FileUtils.joinPath((String[])path));
        return new CSDKLocalFileLock(localFile, false, window);
    }

    public IFileLock acquireSharedLock(Window window) throws Exception {
        if (this.file.getClientFileType() == ClientFileType.REMOTE) {
            ClientProjectFile projectFile = (ClientProjectFile)this.file;
            return new CSDKProjectFileLock(ClientFileLock.acquireSharedLock(window, projectFile));
        }
        ClientLocalFile clientlocalFile = (ClientLocalFile)this.file;
        String[] path = clientlocalFile.getPath();
        File localFile = new File(FileUtils.joinPath((String[])path));
        return new CSDKLocalFileLock(localFile, true, window);
    }
}

