/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.desktop;

import csbase.client.ClientServerManager;
import csbase.client.algorithms.validation.ValidationTranslator;
import csbase.client.desktop.Task;
import csbase.client.util.StandardErrorDialogs;
import csbase.exception.BugException;
import csbase.exception.CSBaseRuntimeException;
import csbase.exception.InfoException;
import csbase.exception.PermissionException;
import csbase.exception.ServiceFailureException;
import csbase.exception.UnavailableServiceException;
import csbase.exception.algorithms.AlgorithmValidationException;
import csbase.logic.ServerURI;
import csbase.logic.algorithms.validation.Validation;
import java.awt.Dialog;
import java.rmi.RemoteException;
import tecgraf.javautils.core.lng.LNG;

public abstract class RemoteTask<R>
extends Task<R> {
    protected ServerURI serverURI;

    protected RemoteTask() {
        this(Dialog.ModalityType.APPLICATION_MODAL);
    }

    public RemoteTask(Dialog.ModalityType modality) {
        this(null, modality);
    }

    protected RemoteTask(ServerURI serverURI) {
        this(serverURI, Dialog.ModalityType.APPLICATION_MODAL);
    }

    protected RemoteTask(ServerURI serverURI, Dialog.ModalityType modality) {
        super(modality);
        this.serverURI = serverURI;
    }

    @Override
    protected void handleError(Exception error) {
        if (error instanceof InfoException) {
            this.handleInfoError((InfoException)error);
        } else if (error instanceof CSBaseRuntimeException) {
            this.handleServerError((CSBaseRuntimeException)error);
        } else if (error instanceof RemoteException) {
            StandardErrorDialogs.showErrorDialog(this.parentWindow, this.taskTitle, LNG.get((String)"desktop.msg.commfailure"), error, this.getAdditionalInfo());
            if (this.serverURI != null) {
                ClientServerManager.getInstance().invalidate(this.serverURI);
            } else {
                ClientServerManager.getInstance().invalidate();
            }
        } else {
            StandardErrorDialogs.showErrorDialog(this.parentWindow, this.taskTitle, LNG.get((String)"desktop.msg.clientbug"), error, this.getAdditionalInfo());
        }
    }

    protected void handleServerError(CSBaseRuntimeException cserror) {
        String msg = cserror.getMessage();
        if (msg == null) {
            if (cserror instanceof UnavailableServiceException) {
                msg = LNG.get((String)"desktop.msg.unavailable");
            } else if (cserror instanceof ServiceFailureException) {
                msg = LNG.get((String)"desktop.msg.servicefailure");
            } else if (cserror instanceof PermissionException) {
                msg = LNG.get((String)"desktop.msg.permissionfailure");
            } else if (cserror instanceof AlgorithmValidationException) {
                msg = LNG.get((String)"desktop.msg.validationfailure");
                Validation validation = ((AlgorithmValidationException)cserror).getValidationResult();
                msg = String.valueOf(msg) + ValidationTranslator.translateMessage(validation);
            } else {
                msg = cserror instanceof BugException ? LNG.get((String)"desktop.msg.serverbug") : LNG.get((String)"desktop.msg.unknownerror");
            }
        }
        StandardErrorDialogs.showErrorDialog(this.parentWindow, this.taskTitle, msg, (Throwable)cserror, this.getAdditionalInfo());
    }

    protected void handleInfoError(InfoException infoError) {
        StandardErrorDialogs.showErrorDialog(this.parentWindow, this.taskTitle, infoError.getMessage());
    }
}

