/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.desktop.dircontents;

import csbase.client.desktop.DesktopFrame;
import csbase.client.desktop.dircontents.DirectoryContentsCellEditor;
import csbase.client.desktop.dircontents.DirectoryContentsTransferHandler;
import csbase.client.project.ProjectFileCellRenderer;
import csbase.client.project.ProjectFileContainer;
import csbase.client.project.ProjectTree;
import csbase.client.project.ProjectTreeAdapter;
import csbase.client.project.ProjectTreeSelectionEvent;
import csbase.client.project.ProjectTreeSelectionListener;
import csbase.client.project.action.CommonDirectoryCreationAction;
import csbase.client.project.action.CommonDirectoryRefreshAction;
import csbase.client.project.action.CommonFileChangeStateAction;
import csbase.client.project.action.CommonFileCopyAction;
import csbase.client.project.action.CommonFileCutAction;
import csbase.client.project.action.CommonFileDeleteAction;
import csbase.client.project.action.CommonFileDownloadAction;
import csbase.client.project.action.CommonFileImportAction;
import csbase.client.project.action.CommonFileOpenAction;
import csbase.client.project.action.CommonFilePasteAction;
import csbase.client.project.action.CommonFilePropertiesShowAction;
import csbase.client.project.action.CommonFileRenameAction;
import csbase.client.project.action.CommonFileTypeChangeAction;
import csbase.client.project.action.CommonMultiSelectionFileTypeChangeAction;
import csbase.client.project.action.ExportFilesToDirAction;
import csbase.client.project.action.ProjectTreeUpdateAction;
import csbase.client.project.action.SingleFileExportAction;
import csbase.client.project.tasks.FileTypeIconCellRenderer;
import csbase.client.project.tasks.GetChildrenTask;
import csbase.client.util.DateTableCellRenderer;
import csbase.client.util.SizeTableCellRenderer;
import csbase.logic.ClientProjectFile;
import csbase.logic.ClientProjectFileComparator;
import csbase.logic.CommonClientProject;
import csbase.logic.FileTypeComparator;
import csbase.logic.NoHiddenFileFilter;
import csbase.logic.ProjectFileFilter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SortOrder;
import javax.swing.TransferHandler;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import tecgraf.javautils.core.lng.FormatUtils;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.SwingThreadDispatcher;
import tecgraf.javautils.gui.table.ObjectTableModel;
import tecgraf.javautils.gui.table.ObjectTableProvider;
import tecgraf.javautils.gui.table.SortableTable;

public class DirectoryContentsPanel
extends JPanel
implements ProjectFileContainer {
    static final int TYPE_COL_INDEX = 0;
    static final int NAME_COL_INDEX = 1;
    static final int SIZE_COL_INDEX = 2;
    static final int DATE_COL_INDEX = 3;
    private SortableTable dirContentsTable;
    private ObjectTableModel<ClientProjectFile> dirModel;
    private JLabel statusBar;
    private String lastStatusBarText = " ";
    private JPopupMenu popupDir;
    private JPopupMenu popupFile;
    private JPopupMenu popupMultSelection;
    protected JMenuItem dirPasteFileMenuItem;
    private boolean currentEditingAllowed;
    private ClientProjectFile previousSelectedFile;
    protected JMenuItem dirDeleteFileMenuItem;
    protected JMenuItem dirCutFileMenuItem;
    protected JMenuItem dirRenameFileMenuItem;
    protected JMenuItem dirCreateDirMenuItem;
    protected JMenuItem dirRefreshDirMenuItem;
    protected JMenuItem dirCopyFileMenuItem;
    protected JMenuItem dirUploadMenuItem;
    protected JMenuItem dirExportMenuItem;
    protected JMenuItem fileOpenMenuItem;
    protected JMenuItem notepadFileOpenMenuItem;
    protected JMenuItem fileSeeFilePropertiesMenuItem;
    protected JMenuItem fileCutFileMenuItem;
    protected JMenuItem fileCopyFileMenuItem;
    protected JMenuItem fileRenameFileMenuItem;
    protected JMenuItem fileChangeFileTypeMenuItem;
    protected JMenuItem fileDeleteFileMenuItem;
    protected JMenuItem fileDownloadFileMenuItem;
    protected JMenuItem fileExportFileMenuItem;
    protected JMenu advancedSubmenu;
    protected JMenuItem fileChangeStateFileMenuItem;
    protected JMenuItem msChangeFileTypeMenuItem;
    protected JMenuItem msCutFileMenuItem;
    protected JMenuItem msCopyFileMenuItem;
    protected JMenuItem msDeleteFileMenuItem;
    protected JMenuItem msExportFileMenuItem;
    private Window ownerWindow;
    private String ownerTitle;
    private ProjectTree projectTree;
    private JScrollPane scrollPane;
    protected boolean transferEnabled;
    protected boolean deleteEnabled;
    protected boolean renameEnabled;
    protected boolean refreshEnabled;
    private ProjectFileFilter filter;

    public void clear() {
        this.clearModel();
        this.lastStatusBarText = " ";
        this.statusBar.setText(this.lastStatusBarText);
    }

    @Override
    public void clearClipboard() {
        DirectoryContentsTransferHandler handler = (DirectoryContentsTransferHandler)this.dirContentsTable.getTransferHandler();
        handler.clearClipboard();
    }

    private void clearModel() {
        SwingThreadDispatcher.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                DirectoryContentsPanel.this.dirModel.clear();
            }
        });
    }

    @Override
    public void clearSelection() {
        this.dirContentsTable.clearSelection();
    }

    public void configurePopupDir() {
        if (this.getSelectedFile().getParent() == null) {
            this.dirCutFileMenuItem.setEnabled(false);
            this.dirRenameFileMenuItem.setEnabled(false);
            this.dirDeleteFileMenuItem.setEnabled(false);
        } else {
            this.dirCutFileMenuItem.setEnabled(this.transferEnabled);
            this.dirRenameFileMenuItem.setEnabled(this.renameEnabled);
            this.dirDeleteFileMenuItem.setEnabled(this.deleteEnabled);
        }
        this.dirRefreshDirMenuItem.setEnabled(this.refreshEnabled);
        this.dirCopyFileMenuItem.setEnabled(this.transferEnabled);
        this.dirPasteFileMenuItem.setEnabled(this.transferEnabled && this.hasFileToPaste());
    }

    public void configurePopupFile(ClientProjectFile file) {
        this.fileCopyFileMenuItem.setEnabled(this.transferEnabled);
        this.fileCutFileMenuItem.setEnabled(this.transferEnabled);
        this.fileDeleteFileMenuItem.setEnabled(this.deleteEnabled);
        this.fileRenameFileMenuItem.setEnabled(this.renameEnabled);
        boolean isUnderConstruction = file.isUnderConstruction();
        this.advancedSubmenu.setEnabled(isUnderConstruction);
    }

    public void configurePopupMultiSelection() {
        if (this.hasDirectories(this.getSelectedFiles())) {
            this.msChangeFileTypeMenuItem.setEnabled(false);
        } else {
            this.msChangeFileTypeMenuItem.setEnabled(true);
        }
        this.msCutFileMenuItem.setEnabled(this.transferEnabled);
        this.msCopyFileMenuItem.setEnabled(this.transferEnabled);
        this.msDeleteFileMenuItem.setEnabled(this.deleteEnabled);
    }

    protected JPopupMenu createPopupDir() {
        this.dirCreateDirMenuItem = new JMenuItem(new CommonDirectoryCreationAction(this));
        this.dirRefreshDirMenuItem = new JMenuItem(new CommonDirectoryRefreshAction(this));
        this.dirCutFileMenuItem = new JMenuItem(new CommonFileCutAction(this));
        this.dirCopyFileMenuItem = new JMenuItem(new CommonFileCopyAction(this));
        this.dirPasteFileMenuItem = new JMenuItem(new CommonFilePasteAction(this));
        this.dirRenameFileMenuItem = new JMenuItem(new CommonFileRenameAction(this));
        this.dirDeleteFileMenuItem = new JMenuItem(new CommonFileDeleteAction(this));
        this.dirUploadMenuItem = new JMenuItem(new CommonFileImportAction(this));
        this.dirExportMenuItem = new JMenuItem(new ExportFilesToDirAction(this));
        JPopupMenu menu = new JPopupMenu();
        menu.add(this.dirCreateDirMenuItem);
        menu.add(this.dirRefreshDirMenuItem);
        menu.addSeparator();
        menu.add(this.dirCutFileMenuItem);
        menu.add(this.dirCopyFileMenuItem);
        menu.add(this.dirPasteFileMenuItem);
        menu.addSeparator();
        menu.add(this.dirRenameFileMenuItem);
        menu.add(this.dirDeleteFileMenuItem);
        menu.addSeparator();
        menu.add(this.dirUploadMenuItem);
        menu.add(this.dirExportMenuItem);
        return menu;
    }

    protected JPopupMenu createPopupFile() {
        this.fileOpenMenuItem = new JMenuItem(new CommonFileOpenAction(this));
        this.notepadFileOpenMenuItem = new JMenuItem(new CommonFileOpenAction(this, "notepad", LNG.get((String)"BasicProjectTree.open.notepad")));
        this.fileSeeFilePropertiesMenuItem = new JMenuItem(new CommonFilePropertiesShowAction(this));
        this.fileCutFileMenuItem = new JMenuItem(new CommonFileCutAction(this));
        this.fileCopyFileMenuItem = new JMenuItem(new CommonFileCopyAction(this));
        this.fileRenameFileMenuItem = new JMenuItem(new CommonFileRenameAction(this));
        this.fileChangeFileTypeMenuItem = new JMenuItem(new CommonFileTypeChangeAction(this));
        this.fileDeleteFileMenuItem = new JMenuItem(new CommonFileDeleteAction(this));
        this.fileDownloadFileMenuItem = new JMenuItem(new CommonFileDownloadAction(this));
        this.fileExportFileMenuItem = new JMenuItem(new SingleFileExportAction(this));
        this.advancedSubmenu = new JMenu(LNG.get((String)"BasicProjectTree.popupmenu.advanced"));
        this.fileChangeStateFileMenuItem = new JMenuItem(new CommonFileChangeStateAction(this));
        this.advancedSubmenu.add(this.fileChangeStateFileMenuItem);
        JPopupMenu menu = new JPopupMenu();
        menu.add(this.fileOpenMenuItem);
        menu.add(this.notepadFileOpenMenuItem);
        menu.addSeparator();
        menu.add(this.fileSeeFilePropertiesMenuItem);
        menu.addSeparator();
        menu.add(this.fileCutFileMenuItem);
        menu.add(this.fileCopyFileMenuItem);
        menu.addSeparator();
        menu.add(this.fileRenameFileMenuItem);
        menu.add(this.fileChangeFileTypeMenuItem);
        menu.add(this.fileDeleteFileMenuItem);
        menu.addSeparator();
        menu.add(this.fileDownloadFileMenuItem);
        menu.add(this.fileExportFileMenuItem);
        menu.addSeparator();
        menu.add(this.advancedSubmenu);
        return menu;
    }

    protected JPopupMenu createPopupMultSelection() {
        this.msCutFileMenuItem = new JMenuItem(new CommonFileCutAction(this));
        this.msCopyFileMenuItem = new JMenuItem(new CommonFileCopyAction(this));
        this.msDeleteFileMenuItem = new JMenuItem(new CommonFileDeleteAction(this));
        this.msChangeFileTypeMenuItem = new JMenuItem(new CommonMultiSelectionFileTypeChangeAction(this));
        this.msExportFileMenuItem = new JMenuItem(new ExportFilesToDirAction(this));
        JPopupMenu menu = new JPopupMenu();
        menu.add(this.msCutFileMenuItem);
        menu.add(this.msCopyFileMenuItem);
        menu.addSeparator();
        menu.add(this.msChangeFileTypeMenuItem);
        menu.add(this.msDeleteFileMenuItem);
        menu.addSeparator();
        menu.add(this.msExportFileMenuItem);
        return menu;
    }

    public void display(ClientProjectFile file) {
        if (file.isDirectory()) {
            this.displayDir(file);
        } else {
            this.displayFile(file);
        }
        this.statusBar.setText(this.lastStatusBarText);
    }

    public void display(ClientProjectFile[] files) {
        ArrayList<ClientProjectFile> fileList = new ArrayList<ClientProjectFile>();
        ClientProjectFile[] clientProjectFileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            ClientProjectFile file = clientProjectFileArray[n2];
            fileList.add(file);
            ++n2;
        }
        this.updateModel(fileList);
        this.lastStatusBarText = this.getStatusBarTextForFiles(files);
        this.statusBar.setText(this.lastStatusBarText);
    }

    private void displayDir(ClientProjectFile dir) {
        ArrayList<ClientProjectFile> dirList = new ArrayList<ClientProjectFile>();
        ClientProjectFile[] children = GetChildrenTask.runTask(dir);
        NoHiddenFileFilter noDotFileFilter = NoHiddenFileFilter.getInstance();
        boolean showHiddenFiles = DesktopFrame.getInstance().shouldShowHiddenFiles();
        long size = 0L;
        ClientProjectFile[] clientProjectFileArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            ClientProjectFile element;
            ClientProjectFile child = element = clientProjectFileArray[n2];
            if ((showHiddenFiles || noDotFileFilter.accept(child)) && (this.filter == null || this.filter.accept(child))) {
                dirList.add(child);
                if (!child.isDirectory()) {
                    size += child.size();
                }
            }
            ++n2;
        }
        this.updateModel(dirList);
        this.lastStatusBarText = this.getStatusBarTextForFiles(dirList.size(), size);
    }

    private void displayFile(ClientProjectFile file) {
        ArrayList<ClientProjectFile> fileList = new ArrayList<ClientProjectFile>();
        fileList.add(file);
        this.updateModel(fileList);
        this.lastStatusBarText = this.getStatusBarTextForFile(file);
    }

    @Override
    public void enableDeleteAction(boolean enable) {
        KeyStroke delKey = KeyStroke.getKeyStroke("DELETE");
        if (enable) {
            CommonFileDeleteAction deleteAction = new CommonFileDeleteAction(this);
            String actionName = (String)deleteAction.getValue("Name");
            this.dirContentsTable.getInputMap().put(delKey, actionName);
            this.dirContentsTable.getActionMap().put(actionName, deleteAction);
        } else {
            String actionName = (String)this.dirContentsTable.getInputMap().get(delKey);
            this.dirContentsTable.getActionMap().remove(actionName);
            this.dirContentsTable.getInputMap().remove(delKey);
        }
        this.deleteEnabled = enable;
    }

    @Override
    public void enableRefreshAction(boolean enable) {
        KeyStroke refreshKey = KeyStroke.getKeyStroke("F5");
        if (enable) {
            ProjectTreeUpdateAction refreshAction = new ProjectTreeUpdateAction(this.projectTree);
            String actionName = (String)refreshAction.getValue("Name");
            this.dirContentsTable.getInputMap().put(refreshKey, actionName);
            this.dirContentsTable.getActionMap().put(actionName, refreshAction);
        } else {
            String actionName = (String)this.dirContentsTable.getInputMap().get(refreshKey);
            this.dirContentsTable.getActionMap().remove(actionName);
            this.dirContentsTable.getInputMap().remove(refreshKey);
        }
        this.refreshEnabled = enable;
    }

    @Override
    public void enableRenameAction(boolean enable) {
        TableColumnModel columnModel = this.dirContentsTable.getColumnModel();
        TableColumn column = columnModel.getColumn(1);
        if (enable) {
            column.setCellEditor(new DirectoryContentsCellEditor(this.ownerWindow, this.ownerTitle));
        } else {
            column.setCellEditor(null);
        }
        this.renameEnabled = enable;
    }

    @Override
    public void enableTransferAction(boolean enable) {
        if (enable) {
            this.dirContentsTable.setDragEnabled(true);
            this.dirContentsTable.setTransferHandler((TransferHandler)new DirectoryContentsTransferHandler(this.ownerWindow, this.ownerTitle));
        } else {
            this.dirContentsTable.setDragEnabled(false);
            this.dirContentsTable.setTransferHandler(null);
        }
        this.transferEnabled = enable;
        this.enableTransferKeyBindings(enable);
    }

    private void enableTransferKeyBindings(boolean enable) {
        KeyStroke cutKey = KeyStroke.getKeyStroke("ctrl X");
        KeyStroke copyKey = KeyStroke.getKeyStroke("ctrl C");
        KeyStroke pasteKey = KeyStroke.getKeyStroke("ctrl V");
        InputMap inputMap = this.dirContentsTable.getInputMap();
        ActionMap actionMap = this.dirContentsTable.getActionMap();
        if (enable) {
            CommonFileCutAction cutAction = new CommonFileCutAction(this);
            CommonFileCopyAction copyAction = new CommonFileCopyAction(this);
            CommonFilePasteAction pasteAction = new CommonFilePasteAction(this);
            inputMap.put(cutKey, cutAction.getValue("Name"));
            inputMap.put(copyKey, copyAction.getValue("Name"));
            inputMap.put(pasteKey, pasteAction.getValue("Name"));
            actionMap.put(cutAction.getValue("Name"), cutAction);
            actionMap.put(copyAction.getValue("Name"), copyAction);
            actionMap.put(pasteAction.getValue("Name"), pasteAction);
        } else {
            String actionName = (String)inputMap.get(cutKey);
            actionMap.remove(actionName);
            inputMap.remove(cutKey);
            actionName = (String)inputMap.get(copyKey);
            actionMap.remove(actionName);
            inputMap.remove(copyKey);
            actionName = (String)inputMap.get(pasteKey);
            actionMap.remove(actionName);
            inputMap.remove(pasteKey);
        }
    }

    public int getFileColIndex() {
        return 1;
    }

    public JPopupMenu getPopupDir() {
        return this.popupDir;
    }

    public JPopupMenu getPopupFile() {
        return this.popupFile;
    }

    public JPopupMenu getPopupMultSelection() {
        return this.popupMultSelection;
    }

    @Override
    public CommonClientProject getProject() {
        return this.projectTree.getProject();
    }

    @Override
    public ClientProjectFile getSelectedFile() {
        int selectedRow = this.dirContentsTable.getSelectedRow();
        return (ClientProjectFile)this.dirContentsTable.getValueAt(selectedRow, 1);
    }

    @Override
    public ClientProjectFile[] getSelectedFiles() {
        int[] selectedRows = this.dirContentsTable.getSelectedRows();
        if (selectedRows == null || selectedRows.length == 0) {
            return null;
        }
        ClientProjectFile[] selectedFiles = new ClientProjectFile[selectedRows.length];
        int i = 0;
        while (i < selectedRows.length) {
            selectedFiles[i] = (ClientProjectFile)this.dirContentsTable.getValueAt(selectedRows[i], 1);
            ++i;
        }
        return selectedFiles;
    }

    @Override
    public int getSelectionCount() {
        int[] selectedRows = this.dirContentsTable.getSelectedRows();
        if (selectedRows == null) {
            return 0;
        }
        return selectedRows.length;
    }

    private String getStatusBarTextForFile(ClientProjectFile file) {
        long fileSize = file.size();
        String formattedFileSize = FormatUtils.formatSize((long)fileSize, (int)2);
        return MessageFormat.format(LNG.get((String)"DIR_CONTENTS_STATUS_BAR"), 1, formattedFileSize);
    }

    private String getStatusBarTextForFiles(ClientProjectFile[] files) {
        int fileCount = files.length;
        try {
            long dirSize = 0L;
            int i = 0;
            while (i < fileCount) {
                ClientProjectFile file = files[i];
                if (!file.isDirectory()) {
                    dirSize += file.size();
                }
                ++i;
            }
            return this.getStatusBarTextForFiles(fileCount, dirSize);
        }
        catch (Exception e) {
            e.printStackTrace();
            return LNG.get((String)"DIR_CONTENTS_STATUS_BAR_ERROR");
        }
    }

    private String getStatusBarTextForFiles(int fileCount, long totalSize) {
        String formattedDirSize = FormatUtils.formatSize((long)totalSize, (int)2);
        return MessageFormat.format(LNG.get((String)"DIR_CONTENTS_STATUS_BAR"), fileCount, formattedDirSize);
    }

    public SortableTable getTable() {
        return this.dirContentsTable;
    }

    @Override
    public String getTitle() {
        return this.ownerTitle;
    }

    @Override
    public Window getWindow() {
        return this.ownerWindow;
    }

    public boolean hasDirectories(ClientProjectFile[] projectFiles) {
        ClientProjectFile[] clientProjectFileArray = projectFiles;
        int n = projectFiles.length;
        int n2 = 0;
        while (n2 < n) {
            ClientProjectFile projectFile = clientProjectFileArray[n2];
            if (projectFile.isDirectory()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean hasFileToPaste() {
        DirectoryContentsTransferHandler transferHandler = (DirectoryContentsTransferHandler)this.dirContentsTable.getTransferHandler();
        return transferHandler != null && transferHandler.hasTransferableInClipboard();
    }

    public void setFilter(ProjectFileFilter filter) {
        this.filter = filter;
    }

    @Override
    public void startCopyAction() {
        TransferHandler handler = this.dirContentsTable.getTransferHandler();
        handler.exportToClipboard((JComponent)this.dirContentsTable, null, 1);
    }

    @Override
    public void startCutAction() {
        TransferHandler handler = this.dirContentsTable.getTransferHandler();
        handler.exportToClipboard((JComponent)this.dirContentsTable, null, 2);
    }

    @Override
    public void startPasteAction() {
        TransferHandler handler = this.dirContentsTable.getTransferHandler();
        handler.importData((JComponent)this.dirContentsTable, null);
        if (this.projectTree.getSelectionCount() == 1) {
            ClientProjectFile selectedFile = this.projectTree.getSelectedFile();
            this.display(selectedFile);
        }
    }

    @Override
    public void startRenamingAction() {
        int selectedRow = this.dirContentsTable.getSelectedRow();
        this.currentEditingAllowed = true;
        this.dirContentsTable.editCellAt(selectedRow, 1);
        this.currentEditingAllowed = false;
    }

    public void synchronizeSelection(ClientProjectFile file) {
        if (file == null) {
            return;
        }
        if (!file.equals((Object)this.projectTree.getSelectedFile())) {
            this.projectTree.setSelectedFile(file);
        }
    }

    private void update() {
        this.update(this.projectTree.getSelectedFiles(), true);
    }

    private void update(ClientProjectFile[] selectedFiles, boolean refresh) {
        if (selectedFiles == null || selectedFiles.length == 0) {
            this.clear();
            this.previousSelectedFile = null;
        } else if (selectedFiles.length == 1) {
            ClientProjectFile selFile = selectedFiles[0];
            if (refresh || !selFile.equals((Object)this.previousSelectedFile)) {
                this.display(selFile);
                this.previousSelectedFile = selFile;
            }
        } else {
            this.display(selectedFiles);
            this.previousSelectedFile = null;
        }
    }

    private void updateModel(final List<ClientProjectFile> fileList) {
        SwingThreadDispatcher.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                DirectoryContentsPanel.this.dirModel.setRows(fileList);
            }
        });
    }

    public DirectoryContentsPanel(Window ownerWindow, String ownerTitle, ProjectTree projectTree) {
        this.ownerWindow = ownerWindow;
        this.ownerTitle = ownerTitle;
        this.filter = null;
        this.projectTree = projectTree;
        this.projectTree.addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
                DirectoryContentsPanel.this.update();
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
                DirectoryContentsPanel.this.update();
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
                DirectoryContentsPanel.this.update();
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
                DirectoryContentsPanel.this.update();
            }
        });
        this.projectTree.addTreeSelectionListener(new ProjectTreeSelectionListener(){

            @Override
            public void update(ProjectTreeSelectionEvent event) {
                DirectoryContentsPanel.this.update(event.getSelectedFiles(), false);
            }
        });
        MyObjectTableProvider provider = new MyObjectTableProvider();
        this.dirModel = new ObjectTableModel<ClientProjectFile>(new ArrayList(), (ObjectTableProvider)provider){

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                if (!DirectoryContentsPanel.this.currentEditingAllowed) {
                    return false;
                }
                return columnIndex == 1;
            }
        };
        this.dirContentsTable = new SortableTable(this.dirModel);
        this.dirContentsTable.setNoSortStateEnabled(true);
        FileTypeComparator iconComparator = new FileTypeComparator();
        this.dirContentsTable.setComparator(0, (Comparator)iconComparator);
        ClientProjectFileComparator comparator = new ClientProjectFileComparator();
        this.dirContentsTable.setComparator(1, (Comparator)comparator);
        this.dirContentsTable.sort(1, SortOrder.ASCENDING);
        this.dirContentsTable.setDefaultRenderer(Date.class, (TableCellRenderer)new DateTableCellRenderer());
        this.dirContentsTable.setDefaultRenderer(Long.class, (TableCellRenderer)new SizeTableCellRenderer());
        TableColumnModel columnModel = this.dirContentsTable.getColumnModel();
        TableColumn nameColumn = columnModel.getColumn(1);
        nameColumn.setCellRenderer(new ProjectFileCellRenderer());
        TableColumn typeColumn = columnModel.getColumn(0);
        typeColumn.setCellRenderer(new FileTypeIconCellRenderer());
        typeColumn.setMaxWidth(25);
        typeColumn.setMinWidth(25);
        typeColumn.setPreferredWidth(25);
        TableColumn sizeColumn = columnModel.getColumn(2);
        sizeColumn.setPreferredWidth(80);
        sizeColumn.setMaxWidth(80);
        TableColumn dateColumn = columnModel.getColumn(3);
        dateColumn.setPreferredWidth(150);
        dateColumn.setMaxWidth(150);
        this.dirContentsTable.setShowGrid(false);
        this.dirContentsTable.setRowMargin(0);
        projectTree.addProjectTreeListener(new ProjectTreeAdapter(){

            @Override
            public void projectChanged(CommonClientProject project) {
                DirectoryContentsPanel.this.update();
            }

            @Override
            public void projectClosed(CommonClientProject project) {
                DirectoryContentsPanel.this.clear();
            }

            @Override
            public void projectInfoModified() {
                DirectoryContentsPanel.this.update();
            }

            @Override
            public void projectRemoved() {
                DirectoryContentsPanel.this.clear();
            }
        });
        this.scrollPane = new JScrollPane((Component)this.dirContentsTable);
        this.scrollPane.getViewport().setBackground(Color.WHITE);
        this.statusBar = new JLabel();
        this.statusBar.setText(this.lastStatusBarText);
        this.setLayout(new BorderLayout());
        this.add((Component)this.scrollPane, "Center");
        this.add((Component)this.statusBar, "South");
        this.setPreferredSize(new Dimension(220, 100));
        this.popupDir = this.createPopupDir();
        this.popupFile = this.createPopupFile();
        this.popupMultSelection = this.createPopupMultSelection();
    }

    private static class MyObjectTableProvider
    implements ObjectTableProvider {
        private static final Class<?>[] COL_CLASSES = new Class[]{ImageIcon.class, ClientProjectFile.class, Long.class, Date.class};
        private static final String[] COL_NAMES = new String[]{"", LNG.get((String)"DIR_CONTENTS_NAME"), LNG.get((String)"DIR_CONTENTS_SIZE"), LNG.get((String)"DIR_CONTENTS_DATE")};

        private MyObjectTableProvider() {
        }

        public Object getCellValue(Object row, int col) {
            ClientProjectFile file = (ClientProjectFile)row;
            switch (col) {
                case 0: {
                    return file;
                }
                case 1: {
                    return file;
                }
                case 2: {
                    return this.getSize(file);
                }
                case 3: {
                    return this.getDate(file);
                }
            }
            return null;
        }

        public Class<?>[] getColumnClasses() {
            return COL_CLASSES;
        }

        public String[] getColumnNames() {
            return COL_NAMES;
        }

        private Date getDate(ClientProjectFile file) {
            return new Date(file.getModificationDate());
        }

        private Long getSize(ClientProjectFile file) {
            if (file.isDirectory()) {
                return -1L;
            }
            return file.size();
        }
    }
}

