/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.desktop.dircontents;

import csbase.client.project.AbstractProjectFileTransferHandler;
import csbase.logic.ClientProjectFile;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import javax.swing.JComponent;
import javax.swing.JTable;

public class DirectoryContentsTransferHandler
extends AbstractProjectFileTransferHandler {
    @Override
    public boolean canImport(JComponent c, DataFlavor[] flavor) {
        if (!(c instanceof JTable)) {
            return false;
        }
        JTable table = (JTable)c;
        if (table.getEditingRow() != -1) {
            return false;
        }
        return super.canImport(c, flavor);
    }

    @Override
    protected ClientProjectFile getDestinationDirectory(JComponent destination) {
        if (destination instanceof JTable) {
            JTable table = (JTable)destination;
            int selectedRow = table.getSelectedRow();
            boolean column = true;
            ClientProjectFile dir = (ClientProjectFile)table.getValueAt(selectedRow, 1);
            return dir;
        }
        return null;
    }

    @Override
    protected ClientProjectFile[] getFilesToExport(JComponent source) {
        JTable table;
        int[] selectedRows;
        if (source instanceof JTable && (selectedRows = (table = (JTable)source).getSelectedRows()).length > 0) {
            ClientProjectFile[] files = new ClientProjectFile[selectedRows.length];
            int inx = 0;
            while (inx < files.length) {
                files[inx] = (ClientProjectFile)table.getValueAt(selectedRows[inx], 1);
                ++inx;
            }
            return files;
        }
        return null;
    }

    public DirectoryContentsTransferHandler(Window ownerWindow, String ownerTitle) {
        super(ownerWindow, ownerTitle);
    }
}

