/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.externalresources;

import csbase.client.externalresources.JNLPLocalFile;
import csbase.client.externalresources.LocalFile;
import csbase.exception.CSBaseException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.jnlp.BasicService;
import javax.jnlp.FileContents;
import javax.jnlp.FileOpenService;
import javax.jnlp.FileSaveService;
import javax.jnlp.ServiceManager;
import javax.jnlp.UnavailableServiceException;

public final class ExternalResources {
    private static final String UNAVAILABLE_SERVICE_MESSAGE = "O servi\u00e7o {0} n\u00e3o est\u00e1 dispon\u00edvel: {1}";
    private static final String BASIC_SERVICE_CLASS_NAME = "javax.jnlp.BasicService";
    private static final String FILE_OPEN_SERVICE_CLASS_NAME = "javax.jnlp.FileOpenService";
    private static final String FILE_SAVE_SERVICE_CLASS_NAME = "javax.jnlp.FileSaveService";
    private static ExternalResources instance;

    private ExternalResources() {
    }

    public static ExternalResources getInstance() {
        if (instance == null) {
            instance = new ExternalResources();
        }
        return instance;
    }

    public boolean isEnabled() {
        try {
            ServiceManager.lookup((String)BASIC_SERVICE_CLASS_NAME);
            return true;
        }
        catch (UnavailableServiceException e) {
            return false;
        }
    }

    public boolean showDocument(URL url) throws CSBaseException {
        try {
            BasicService basicService = (BasicService)ServiceManager.lookup((String)BASIC_SERVICE_CLASS_NAME);
            return basicService.showDocument(url);
        }
        catch (UnavailableServiceException e) {
            throw new CSBaseException(UNAVAILABLE_SERVICE_MESSAGE, new Object[]{BASIC_SERVICE_CLASS_NAME, e.getMessage()});
        }
    }

    public URL getCodeBase() throws CSBaseException {
        try {
            BasicService basicService = (BasicService)ServiceManager.lookup((String)BASIC_SERVICE_CLASS_NAME);
            return basicService.getCodeBase();
        }
        catch (UnavailableServiceException e) {
            throw new CSBaseException(UNAVAILABLE_SERVICE_MESSAGE, new Object[]{BASIC_SERVICE_CLASS_NAME, e.getMessage()});
        }
    }

    public LocalFile openFileDialog(String pathHint, String[] extensions) throws IOException, CSBaseException {
        FileContents fileContents;
        block3: {
            try {
                FileOpenService fileOpenService = (FileOpenService)ServiceManager.lookup((String)FILE_OPEN_SERVICE_CLASS_NAME);
                fileContents = fileOpenService.openFileDialog(pathHint, extensions);
                if (fileContents != null) break block3;
                return null;
            }
            catch (UnavailableServiceException e) {
                throw new CSBaseException(UNAVAILABLE_SERVICE_MESSAGE, new Object[]{FILE_OPEN_SERVICE_CLASS_NAME, e.getMessage()});
            }
        }
        return new JNLPLocalFile(fileContents);
    }

    public LocalFile[] openMultiFileDialog(String pathHint, String[] extensions) throws IOException, CSBaseException {
        FileContents[] fileContents;
        block4: {
            FileOpenService fileOpenService = (FileOpenService)ServiceManager.lookup((String)FILE_OPEN_SERVICE_CLASS_NAME);
            fileContents = fileOpenService.openMultiFileDialog(pathHint, extensions);
            if (fileContents != null) break block4;
            return null;
        }
        try {
            LocalFile[] localFiles = new LocalFile[fileContents.length];
            int i = 0;
            while (i < fileContents.length) {
                localFiles[i] = new JNLPLocalFile(fileContents[i]);
                ++i;
            }
            return localFiles;
        }
        catch (UnavailableServiceException e) {
            throw new CSBaseException(UNAVAILABLE_SERVICE_MESSAGE, new Object[]{FILE_OPEN_SERVICE_CLASS_NAME, e.getMessage()});
        }
    }

    public LocalFile saveFileDialog(String pathHint, String[] extensions, InputStream inputStream, String name) throws CSBaseException, IOException {
        FileContents fileContents;
        block3: {
            try {
                FileSaveService fileSaveService = (FileSaveService)ServiceManager.lookup((String)FILE_SAVE_SERVICE_CLASS_NAME);
                fileContents = fileSaveService.saveFileDialog(pathHint, extensions, inputStream, name);
                if (fileContents != null) break block3;
                return null;
            }
            catch (UnavailableServiceException e) {
                throw new CSBaseException(UNAVAILABLE_SERVICE_MESSAGE, new Object[]{FILE_SAVE_SERVICE_CLASS_NAME, e.getMessage()});
            }
        }
        return new JNLPLocalFile(fileContents);
    }

    public LocalFile saveAsFileDialog(String pathHint, String[] extensions, JNLPLocalFile localFile) throws CSBaseException, IOException {
        FileContents fileContents;
        block3: {
            try {
                FileSaveService fileSaveService = (FileSaveService)ServiceManager.lookup((String)FILE_SAVE_SERVICE_CLASS_NAME);
                fileContents = fileSaveService.saveAsFileDialog(pathHint, extensions, localFile.getFileContents());
                if (fileContents != null) break block3;
                return null;
            }
            catch (UnavailableServiceException e) {
                throw new CSBaseException(UNAVAILABLE_SERVICE_MESSAGE, new Object[]{FILE_SAVE_SERVICE_CLASS_NAME, e.getMessage()});
            }
        }
        return new JNLPLocalFile(fileContents);
    }
}

