/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.facilities.monitoringtable;

import csbase.client.facilities.monitoringtable.MonitoringTableEvent;
import csbase.client.facilities.monitoringtable.MonitoringTableObserver;
import csbase.client.remote.ClientRemoteMonitor;
import csbase.client.remote.srvproxies.SGAProxy;
import csbase.logic.MonitoringSet;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import javax.swing.table.TableModel;
import tecgraf.javautils.gui.SwingThreadDispatcher;
import tecgraf.javautils.gui.table.ObjectTableModel;
import tecgraf.javautils.gui.table.ObjectTableProvider;
import tecgraf.javautils.gui.table.SortableTable;

public abstract class MonitoringTable
extends SortableTable {
    protected UpdateMonTableThread updateThread = null;
    protected ObjectTableModel<MonitoringSet> model;
    private final Collection<MonitoringTableObserver> observers = new HashSet<MonitoringTableObserver>();

    public void addObserver(MonitoringTableObserver o) {
        this.observers.add(o);
    }

    public void removeObserver(MonitoringTableObserver o) {
        this.observers.remove(o);
    }

    private void notifyObservers(MonitoringTableEvent event) {
        for (MonitoringTableObserver obs : this.observers) {
            obs.update(event);
        }
    }

    public void wakeupThread() {
        this.updateThread.wakeupThread();
    }

    public void stopThread() {
        this.updateThread.stopThread();
    }

    public void startThread() {
        this.updateThread = new UpdateMonTableThread();
        this.updateThread.start();
    }

    public MonitoringSet getMonitoringSet(int row) {
        return (MonitoringSet)this.model.getRow(row);
    }

    protected Thread getUpdateThread() {
        return this.updateThread;
    }

    protected abstract ObjectTableProvider getObjectTableProvider();

    public abstract Vector<MonitoringSet> getNewRows() throws RemoteException;

    protected abstract void invalidateRows();

    public MonitoringTable() {
        this(0);
    }

    public MonitoringTable(int selectionMode) {
        this.setSelectionMode(selectionMode);
        this.model = new ObjectTableModel(new Vector(), this.getObjectTableProvider());
        this.setModel((TableModel)this.model);
        this.setRowSelectionAllowed(true);
        this.startThread();
    }

    private class UpdateMonTableThread
    extends Thread {
        private Vector<MonitoringSet> newRows = new Vector();
        private boolean exitUpdateThread = false;

        private UpdateMonTableThread() {
        }

        public void stopThread() {
            this.exitUpdateThread = true;
            try {
                this.interrupt();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public void wakeupThread() {
            try {
                this.interrupt();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateMonTable() {
            final Vector<String> selectedKeys = new Vector<String>();
            Vector<MonitoringSet> vector = this.newRows;
            synchronized (vector) {
                int[] selectedRows;
                int newRowCount = this.newRows.size();
                int oldRowCount = MonitoringTable.this.model.getRowCount();
                if (newRowCount > 0 && oldRowCount > 0 && (selectedRows = MonitoringTable.this.getSelectedRows()) != null && selectedRows.length > 0) {
                    int i = 0;
                    while (i < selectedRows.length) {
                        int tableIndex = selectedRows[i];
                        int modelIndex = MonitoringTable.this.convertRowIndexToModel(tableIndex);
                        if (modelIndex >= 0) {
                            MonitoringSet selectedSet = MonitoringTable.this.getMonitoringSet(modelIndex);
                            selectedKeys.add(selectedSet.getKey());
                        }
                        ++i;
                    }
                }
                MonitoringTable.this.model.setRows(this.newRows);
            }
            if (selectedKeys.isEmpty()) {
                return;
            }
            SwingThreadDispatcher.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    List rows = ((UpdateMonTableThread)UpdateMonTableThread.this).MonitoringTable.this.model.getRows();
                    int rowCount = rows.size();
                    block0: for (String selectedKey : selectedKeys) {
                        int modelIndex = 0;
                        while (modelIndex < rowCount) {
                            MonitoringSet set = (MonitoringSet)rows.get(modelIndex);
                            String key = set.getKey();
                            if (selectedKey.equals(key)) {
                                int viewIndex = MonitoringTable.this.convertRowIndexToView(modelIndex);
                                MonitoringTable.this.addRowSelectionInterval(viewIndex, viewIndex);
                                continue block0;
                            }
                            ++modelIndex;
                        }
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int updateIntervalAsInt = SGAProxy.getCommandsUpdateInterval();
            if (updateIntervalAsInt == -1) {
                return;
            }
            long updateInterval = (long)updateIntervalAsInt * 1000L;
            while (!this.exitUpdateThread) {
                try {
                    Vector<MonitoringSet> _newRows = MonitoringTable.this.getNewRows();
                    Vector<MonitoringSet> vector = this.newRows;
                    synchronized (vector) {
                        this.newRows = _newRows;
                    }
                    SwingThreadDispatcher.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            UpdateMonTableThread.this.updateMonTable();
                            MonitoringTable.this.notifyObservers(new MonitoringTableEvent(1));
                        }
                    });
                }
                catch (RemoteException e) {
                    SwingThreadDispatcher.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            MonitoringTable.this.invalidateRows();
                            ((UpdateMonTableThread)UpdateMonTableThread.this).MonitoringTable.this.model.fireTableDataChanged();
                            MonitoringTable.this.notifyObservers(new MonitoringTableEvent(-1));
                        }
                    });
                    ClientRemoteMonitor.getInstance().invalidate();
                }
                try {
                    Thread.sleep(updateInterval);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

