/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.ias;

import csbase.client.ias.AbstractPermissionPanel;
import csbase.client.ias.PermissionInfoDialog;
import csbase.logic.AttributesPermission;
import csbase.logic.Permission;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GBC;

class AttributesPanel
extends AbstractPermissionPanel {
    private JLabel newAttributeL = new JLabel(String.valueOf(LNG.get((String)"IAS_PERMISSION_NEW_ATTRIBUTE")) + ":");
    private JTextField newAttribute;
    private SortedListModel attribModel;
    private JScrollPane scrollList;
    private JButton includeButton;
    private JButton removeButton;

    AttributesPanel(PermissionInfoDialog dialog) {
        super((LayoutManager)new GridBagLayout(), dialog);
        JLabel attributesL = new JLabel(String.valueOf(LNG.get((String)"IAS_PERMISSION_ATTRIBUTES")) + ":");
        this.newAttribute = new JTextField(20);
        this.attribModel = new SortedListModel();
        final JList attributesList = new JList(this.attribModel);
        this.scrollList = new JScrollPane(attributesList);
        this.includeButton = new JButton(LNG.get((String)"IAS_ADD"));
        this.includeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String text = AttributesPanel.this.newAttribute.getText().trim();
                if (!text.equals("")) {
                    AttributesPanel.this.attribModel.add(text);
                }
                AttributesPanel.this.newAttribute.setText("");
            }
        });
        this.removeButton = new JButton(LNG.get((String)"IAS_REMOVE"));
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] indexes = attributesList.getSelectedIndices();
                if (indexes != null && indexes.length != 0) {
                    int i = indexes.length - 1;
                    while (i >= 0) {
                        AttributesPanel.this.attribModel.remove(indexes[i]);
                        --i;
                    }
                }
            }
        });
        GBC gbc = new GBC(0, 0).northwest().insets(5, 10, 10, 5);
        this.add((Component)this.newAttributeL, gbc);
        gbc = new GBC(1, 0).horizontal().northwest().insets(0, 0, 5, 0).fillxy();
        this.add((Component)this.newAttribute, gbc);
        gbc = new GBC(2, 0).northwest().insets(0, 5, 5, 10).fillx();
        this.add((Component)this.includeButton, gbc);
        gbc = new GBC(0, 1).northwest().insets(0, 10, 10, 5);
        this.add((Component)attributesL, gbc);
        gbc = new GBC(1, 1).horizontal().northwest().insets(0, 0, 5, 0).fillxy().both();
        this.add((Component)this.scrollList, gbc);
        gbc = new GBC(2, 1).northwest().insets(0, 5, 5, 10);
        this.add((Component)this.removeButton, gbc);
    }

    @Override
    void importFrom(Permission permission) {
        AttributesPermission attribPermission = (AttributesPermission)permission;
        String[] attributes = attribPermission.getAttributes();
        int i = 0;
        while (i < attributes.length) {
            this.attribModel.add(attributes[i]);
            ++i;
        }
        this.attribModel.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                AttributesPanel.this.dialog.checkDataChange();
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                AttributesPanel.this.dialog.checkDataChange();
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
            }
        });
    }

    @Override
    void exportTo(Permission permission) {
        AttributesPermission attribPermission = (AttributesPermission)permission;
        attribPermission.setAttributes(this.getAttributes());
    }

    String[] getAttributes() {
        Object[] attributesObj = this.attribModel.getAll();
        String[] screenAttributes = new String[attributesObj.length];
        System.arraycopy(attributesObj, 0, screenAttributes, 0, attributesObj.length);
        return screenAttributes;
    }

    @Override
    void clearFields() {
        this.newAttribute.setText("");
        this.attribModel.clear();
    }

    @Override
    boolean hasChanged(Permission permission) {
        AttributesPermission attribPermission = (AttributesPermission)permission;
        Object[] screenAttributes = this.getAttributes();
        Object[] currentAttributes = attribPermission.getAttributes();
        Arrays.sort(currentAttributes);
        return !Arrays.equals(screenAttributes, currentAttributes);
    }

    private class SortedListModel
    extends AbstractListModel {
        List<String> items = new ArrayList<String>();

        @Override
        public int getSize() {
            return this.items.size();
        }

        @Override
        public Object getElementAt(int index) {
            return this.items.get(index);
        }

        public Object[] getAll() {
            return this.items.toArray();
        }

        public void add(String item) {
            if (item == null) {
                return;
            }
            int index = Collections.binarySearch(this.items, item);
            if (index < 0) {
                index = -index - 1;
            }
            this.items.add(index, item);
            this.fireIntervalAdded(this, index, index);
        }

        public String remove(int index) {
            if (index == -1) {
                return null;
            }
            if (this.items.size() == 0) {
                return null;
            }
            if (index < 0 || index > this.items.size() - 1) {
                return null;
            }
            String item = this.items.remove(index);
            this.fireIntervalRemoved(this, index, index);
            return item;
        }

        public void clear() {
            this.items.clear();
            this.fireIntervalRemoved(this, 0, 0);
        }
    }
}

