/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.ias;

import csbase.client.desktop.DesktopTask;
import csbase.client.ias.IncludePasswordDialog;
import csbase.client.ias.UserInfoDialog;
import csbase.client.remote.ClientRemoteMonitor;
import csbase.client.remote.srvproxies.UserProxy;
import csbase.client.util.ClientUtilities;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.User;
import csbase.logic.UserInfo;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.StandardDialogs;

public class ModifyUserInfoDialog
extends UserInfoDialog {
    protected User user;
    protected JButton modifyUserButton;
    protected JButton passwordButton;
    protected boolean passwordGiven;

    public ModifyUserInfoDialog(Window ownerWindow, Object userId) {
        super(ownerWindow, ClientUtilities.addSystemNameToTitle(LNG.get((String)"ias.user.update_title")));
        if (userId == null) {
            throw new IllegalArgumentException("userId == null");
        }
        this.user = UserProxy.getUser(ownerWindow, this.dialogTitle, LNG.get((String)"IAS_WAITING_USER_INFO"), userId);
        this.passwordGiven = false;
    }

    @Override
    protected boolean confirmClose() {
        int selected;
        Object[] options = new Object[]{LNG.get((String)"IAS_UPDATE"), LNG.get((String)"IAS_NOT_UPDATE"), LNG.get((String)"IAS_CANCEL")};
        if (options[selected = JOptionPane.showOptionDialog(this.userInfoDialog, LNG.get((String)"IAS_USER_UPDATE_CONFIRMATION"), LNG.get((String)"IAS_USER_UPDATE_NOT_DONE_TITLE"), -1, 1, null, options, options[0])].equals(LNG.get((String)"IAS_UPDATE"))) {
            if (this.requiredFieldsAreFilled()) {
                return this.modifyUser();
            }
            StandardErrorDialogs.showErrorDialog((Window)this.userInfoDialog, this.dialogTitle, LNG.get((String)"IAS_FILL_ALL_FIELDS"));
            return false;
        }
        return options[selected].equals(LNG.get((String)"IAS_NOT_UPDATE"));
    }

    @Override
    protected JPanel makeUpperPanel() {
        JPanel panel = super.makeUpperPanel();
        this.login.setEditable(false);
        this.fillFieldsWithUserData();
        return panel;
    }

    protected void fillFieldsWithUserData() {
        DesktopTask task = new DesktopTask(){

            @Override
            public void performTask() throws Exception {
                ModifyUserInfoDialog.this.userInfo.setAttribute("name", (Object)ModifyUserInfoDialog.this.user.getName());
                ModifyUserInfoDialog.this.userInfo.setAttribute("login", (Object)ModifyUserInfoDialog.this.user.getLogin());
                ModifyUserInfoDialog.this.userInfo.setAttribute("emails", (Object)ModifyUserInfoDialog.this.user.getEmails());
                ModifyUserInfoDialog.this.userInfo.setAttribute("unId", ModifyUserInfoDialog.this.user.getAttribute("unId"));
                ModifyUserInfoDialog.this.userInfo.setAttribute("roleIds", ModifyUserInfoDialog.this.user.getAttribute("roleIds"));
                ModifyUserInfoDialog.this.userInfo.setAttribute("permissionIds", ModifyUserInfoDialog.this.user.getAttribute("permissionIds"));
                ModifyUserInfoDialog.this.userInfo.setAttribute("forceLocalLogin", ModifyUserInfoDialog.this.user.getAttribute("forceLocalLogin"));
                ModifyUserInfoDialog.this.userInfo.setAttribute("creationDate", ModifyUserInfoDialog.this.user.getAttribute("creationDate"));
                this.setResult(ModifyUserInfoDialog.this.userInfo);
            }
        };
        task.start(this.userInfoDialog, this.dialogTitle, LNG.get((String)"IAS_WAITING_USER_INFO"));
        Exception exception = task.getException();
        if (exception != null) {
            StandardErrorDialogs.showErrorDialog((Window)this.userInfoDialog, String.valueOf(LNG.get((String)"ERRO")) + " - " + this.dialogTitle, (Throwable)exception);
            return;
        }
        this.userInfo = (UserInfo)task.getResult();
        this.login.setText(this.userInfo.getLogin());
        this.name.setText((String)this.userInfo.getAttribute("name"));
        String[] emails = (String[])this.userInfo.getAttribute("emails");
        if (emails != null) {
            String[] stringArray = emails;
            int n = emails.length;
            int n2 = 0;
            while (n2 < n) {
                String email = stringArray[n2];
                this.emailsModel.addElement(email);
                ++n2;
            }
        }
    }

    protected JButton makePasswordButton() {
        this.passwordButton = new JButton(LNG.get((String)"IAS_USER_PASSWORD_UPDATE"));
        this.passwordButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ModifyUserInfoDialog.this.modifyPassword();
            }
        });
        return this.passwordButton;
    }

    private void modifyPassword() {
        IncludePasswordDialog dialog = new IncludePasswordDialog(this.userInfoDialog, this.user);
        String password = dialog.getNewPassword();
        if (password == null) {
            return;
        }
        this.userInfo.setAttribute("password", (Object)password);
        this.passwordGiven = true;
        this.enableModifyUserButtonIfAllowed();
    }

    private JButton makeModifyUserButton() {
        JButton button = new JButton(LNG.get((String)"IAS_USER_UPDATE"));
        button.setEnabled(false);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (ModifyUserInfoDialog.this.requiredFieldsAreFilled()) {
                    if (ModifyUserInfoDialog.this.modifyUser()) {
                        ModifyUserInfoDialog.this.userInfoDialog.close();
                    }
                } else {
                    StandardErrorDialogs.showErrorDialog((Window)ModifyUserInfoDialog.this.userInfoDialog, ModifyUserInfoDialog.this.dialogTitle, LNG.get((String)"IAS_FILL_ALL_FIELDS"));
                }
            }
        });
        return button;
    }

    protected boolean modifyUser() {
        this.updateUserInfo();
        this.userInfo.setAttribute("passwordDigest", (Object)this.user.getPasswordDigest());
        User modifiedUser = UserProxy.modifyUser(this.userInfoDialog, this.dialogTitle, LNG.get((String)"IAS_WAITING_USER_MODIFICATION"), this.user.getId(), this.userInfo);
        if (modifiedUser == null) {
            return false;
        }
        ClientRemoteMonitor.getInstance().setPassword((String)this.userInfo.getAttribute("password"));
        StandardDialogs.showInfoDialog((Component)this.userInfoDialog, (String)this.dialogTitle, (Object)MessageFormat.format(LNG.get((String)"IAS_USER_MODIFIED_WITH_SUCCESS"), this.user.getLogin()));
        this.user = modifiedUser;
        this.passwordGiven = false;
        this.modifyUserButton.setEnabled(false);
        return true;
    }

    @Override
    protected JPanel makeLowerPanel() {
        JPanel buttonPanel = super.makeLowerPanel();
        this.modifyUserButton = this.makeModifyUserButton();
        this.modifyUserButton.setEnabled(false);
        buttonPanel.add((Component)this.modifyUserButton, 0);
        return buttonPanel;
    }

    @Override
    protected JPanel makeMiddlePanel() {
        JPanel panel = super.makeMiddlePanel();
        boolean forceLocalLogin = false;
        Object attribute = this.user.getAttribute("forceLocalLogin");
        if (attribute != null) {
            forceLocalLogin = (Boolean)attribute;
        }
        if (ClientRemoteMonitor.getInstance().canChangePasswords() || forceLocalLogin) {
            this.passwordButton = this.makePasswordButton();
            panel.add(this.passwordButton);
        }
        return panel;
    }

    @Override
    protected boolean unsavedDataInput() {
        if (!this.login.getText().trim().equals(this.user.getLogin())) {
            return true;
        }
        if (this.userInfo.getAttribute("password") != null) {
            return true;
        }
        if (!this.name.getText().trim().equals(this.user.getName())) {
            return true;
        }
        String[] currentEmails = (String[])this.userInfo.getAttribute("emails");
        if (currentEmails == null) {
            return this.emailsModel.getSize() > 0;
        }
        if (currentEmails.length != this.emailsModel.getSize()) {
            return true;
        }
        int inx = 0;
        while (inx < currentEmails.length) {
            if (!currentEmails[inx].equals(this.emailsModel.get(inx))) {
                return true;
            }
            ++inx;
        }
        return false;
    }

    protected void enableModifyUserButtonIfAllowed() {
        this.modifyUserButton.setEnabled(this.unsavedDataInput() && this.requiredFieldsAreFilled());
    }

    @Override
    protected void fireOnDataChanged() {
        this.enableModifyUserButtonIfAllowed();
    }
}

