/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.ias;

import csbase.client.desktop.DesktopComponentDialog;
import csbase.client.remote.srvproxies.PermissionProxy;
import csbase.client.remote.srvproxies.RoleProxy;
import csbase.client.util.ClientUtilities;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.Permission;
import csbase.logic.Role;
import csbase.logic.RoleInfo;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GUIUtils;
import tecgraf.javautils.gui.StandardDialogs;
import tecgraf.javautils.gui.selector.ContainerSelection;
import tecgraf.javautils.gui.selector.ContainerSelectionListener;
import tecgraf.javautils.gui.table.DefaultObjectTableProvider;
import tecgraf.javautils.gui.table.ObjectTableProvider;

public class RoleDefinitionDialog {
    private boolean isNew;
    private JFrame owner;
    private DesktopComponentDialog mainDialog;
    private String dialogTitle;
    private JTextField roleName;
    private JTextField description;
    private ContainerSelection<Permission> permissionsSelection;
    private Role role;
    private JButton actionButton;

    public void showCreateDialog() {
        this.isNew = true;
        this.dialogTitle = LNG.get((String)"IAS_ROLE_INCLUSION_TITLE");
        this.mainDialog = new DesktopComponentDialog((Window)this.owner, this.dialogTitle);
        Vector<Permission> permissions = PermissionProxy.getAllPermissions(this.mainDialog, this.dialogTitle, LNG.get((String)"IAS_WAITING_ALL_PERMISSIONS"));
        this.showDialog(null, null, permissions, new Vector<Permission>());
    }

    public void showUpdateDialog(Role role) {
        this.isNew = false;
        this.dialogTitle = LNG.get((String)"IAS_ROLE_UPDATE_TITLE");
        this.mainDialog = new DesktopComponentDialog((Window)this.owner, this.dialogTitle);
        this.role = role;
        Object[] selectedIds = role.getPermissionIds();
        Permission[] selectedPermissions = new Permission[selectedIds.length];
        try {
            int i = 0;
            while (i < selectedIds.length) {
                Permission permission = Permission.getPermission((Object)selectedIds[i]);
                if (permission == null) {
                    throw new Exception("N\u00e3o foi poss\u00edvel carregar a permiss\u00e3o de id " + selectedIds[i]);
                }
                selectedPermissions[i] = permission;
                ++i;
            }
        }
        catch (Exception e) {
            StandardErrorDialogs.showErrorDialog((Window)this.mainDialog, String.valueOf(LNG.get((String)"ERRO")) + " - " + this.dialogTitle, (Throwable)e);
        }
        Vector<Permission> selectedPermissionsVector = new Vector<Permission>();
        selectedPermissionsVector.addAll(Arrays.asList(selectedPermissions));
        Vector<Permission> permissions = PermissionProxy.getAllPermissions(this.mainDialog, this.dialogTitle, LNG.get((String)"IAS_WAITING_ALL_PERMISSIONS"));
        this.showDialog(role.getName(), role.getDescription(), permissions, selectedPermissionsVector);
    }

    private void showDialog(String name, String desc, Vector<Permission> selectablePermissions, Vector<Permission> selectedPermissions) {
        Container cp = this.mainDialog.getContentPane();
        if (this.isNew) {
            this.roleName = new JTextField();
            this.description = new JTextField();
        } else {
            this.roleName = new JTextField(name);
            this.roleName.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    RoleDefinitionDialog.this.checkDataChange();
                }
            });
            this.description = new JTextField(desc);
            this.description.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    RoleDefinitionDialog.this.checkDataChange();
                }
            });
        }
        JComponent[][] nameComp = new JComponent[][]{{new JLabel(LNG.get((String)"IAS_ROLE_NAME")), this.roleName}, {new JLabel(LNG.get((String)"IAS_ROLE_DESCRIPTION")), this.description}};
        cp.add((Component)GUIUtils.createBasicGridPanel((JComponent[][])nameComp), "North");
        JPanel selectionPanel = this.createSelectionPanel(selectablePermissions, selectedPermissions);
        cp.add((Component)selectionPanel, "Center");
        if (this.isNew) {
            this.actionButton = new JButton(LNG.get((String)"IAS_ROLE_INCLUDE"));
        } else {
            this.actionButton = new JButton(LNG.get((String)"IAS_ROLE_UPDATE"));
            this.actionButton.setEnabled(false);
        }
        this.actionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (RoleDefinitionDialog.this.validateFields()) {
                    if (RoleDefinitionDialog.this.isNew) {
                        RoleDefinitionDialog.this.createRole();
                    } else {
                        RoleDefinitionDialog.this.modifyRole();
                        RoleDefinitionDialog.this.mainDialog.close();
                    }
                } else {
                    StandardErrorDialogs.showErrorDialog((Window)RoleDefinitionDialog.this.mainDialog, RoleDefinitionDialog.this.dialogTitle, LNG.get((String)"IAS_FILL_ALL_FIELDS"));
                }
            }
        });
        JButton closeButton = new JButton(LNG.get((String)"IAS_CLOSE"));
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selected;
                if (RoleDefinitionDialog.this.isNew || !RoleDefinitionDialog.this.hasChanged()) {
                    RoleDefinitionDialog.this.mainDialog.close();
                    return;
                }
                Object[] options = new Object[]{LNG.get((String)"IAS_ROLE_UPDATE"), LNG.get((String)"IAS_CANCEL")};
                if (options[selected = JOptionPane.showOptionDialog(RoleDefinitionDialog.this.mainDialog, LNG.get((String)"IAS_ROLE_UPDATE_QUESTION"), RoleDefinitionDialog.this.dialogTitle, -1, 1, null, options, options[0])] == LNG.get((String)"IAS_CANCEL")) {
                    RoleDefinitionDialog.this.mainDialog.close();
                } else if (RoleDefinitionDialog.this.validateFields()) {
                    RoleDefinitionDialog.this.modifyRole();
                    RoleDefinitionDialog.this.mainDialog.close();
                }
            }
        });
        ClientUtilities.adjustEqualSizes(this.actionButton, closeButton);
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.add(this.actionButton);
        buttonsPanel.add(closeButton);
        cp.add((Component)buttonsPanel, "South");
        this.mainDialog.pack();
        this.mainDialog.center(this.owner);
        this.mainDialog.setVisible(true);
    }

    private JPanel createSelectionPanel(Vector<Permission> selectablePermissions, Vector<Permission> selectedPermissions) {
        DefaultObjectTableProvider selectableFormat = new DefaultObjectTableProvider(){

            public Object[] getCellValues(Object item) {
                String[] stringArray;
                Permission permission = (Permission)item;
                if (permission == null) {
                    stringArray = null;
                } else {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = permission.getName();
                }
                return stringArray;
            }

            public String[] getColumnNames() {
                return new String[]{LNG.get((String)"IAS_AVAILABLE_PERMISSIONS")};
            }

            public Class<?>[] getColumnClasses() {
                return new Class[]{String.class};
            }
        };
        DefaultObjectTableProvider selectedFormat = new DefaultObjectTableProvider(){

            public Object[] getCellValues(Object item) {
                String[] stringArray;
                Permission permission = (Permission)item;
                if (permission == null) {
                    stringArray = null;
                } else {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = permission.getName();
                }
                return stringArray;
            }

            public String[] getColumnNames() {
                return new String[]{LNG.get((String)"IAS_SELECTED_PERMISSIONS")};
            }

            public Class<?>[] getColumnClasses() {
                return new Class[]{String.class};
            }
        };
        this.permissionsSelection = new ContainerSelection((ObjectTableProvider)selectableFormat, (ObjectTableProvider)selectedFormat, true, false);
        this.permissionsSelection.loadItems(selectablePermissions, selectedPermissions);
        this.permissionsSelection.adjustTableColumns();
        if (!this.isNew) {
            this.permissionsSelection.addContainerSelectionListener(new ContainerSelectionListener(){

                public void containerChanged() {
                    RoleDefinitionDialog.this.checkDataChange();
                }
            });
        }
        return this.permissionsSelection.getPanel();
    }

    private boolean validateFields() {
        String nameText = this.roleName.getText().trim();
        return !nameText.equals("");
    }

    private RoleInfo getScreenRoleInfo() {
        String nameText = this.roleName.getText().trim();
        String descriptionText = this.description.getText();
        List selectedPermissions = this.permissionsSelection.getSelectedItems();
        Object[] permissionIds = new Object[selectedPermissions.size()];
        int i = 0;
        while (i < selectedPermissions.size()) {
            permissionIds[i] = ((Permission)selectedPermissions.get(i)).getId();
            ++i;
        }
        return new RoleInfo(nameText, descriptionText, permissionIds);
    }

    private void createRole() {
        RoleInfo info = this.getScreenRoleInfo();
        this.role = RoleProxy.createRole(this.mainDialog, this.dialogTitle, LNG.get((String)"IAS_WAITING_ROLE_CREATION"), info);
        if (this.role != null) {
            StandardDialogs.showInfoDialog((Component)this.mainDialog, (String)this.dialogTitle, (Object)LNG.get((String)"IAS_ROLE_INCLUSION_WITH_SUCCESS"));
            this.clearFields();
        }
    }

    private void modifyRole() {
        RoleInfo info = this.getScreenRoleInfo();
        Role modifiedRole = RoleProxy.modifyRole(this.mainDialog, this.dialogTitle, LNG.get((String)"IAS_WAITING_ROLE_MODIFICATION"), this.role.getId(), info);
        if (modifiedRole != null) {
            this.role = modifiedRole;
            StandardDialogs.showInfoDialog((Component)this.mainDialog, (String)this.dialogTitle, (Object)LNG.get((String)"IAS_ROLE_UPDATED_WITH_SUCCESS"));
        }
    }

    private void clearFields() {
        this.roleName.setText("");
        this.description.setText("");
        this.permissionsSelection.clear();
        Vector<Permission> permissions = PermissionProxy.getAllPermissions(this.mainDialog, this.dialogTitle, LNG.get((String)"IAS_WAITING_ALL_PERMISSIONS"));
        this.permissionsSelection.loadItems(permissions);
        this.permissionsSelection.adjustTableColumns();
        this.roleName.requestFocus();
    }

    private boolean hasChanged() {
        if (!this.roleName.getText().trim().equals(this.role.getName())) {
            return true;
        }
        if (!this.description.getText().trim().equals(this.role.getDescription())) {
            return true;
        }
        List selectedPermissions = this.permissionsSelection.getSelectedItems();
        Object[] selectedPermIds = new Object[selectedPermissions.size()];
        int i = 0;
        while (i < selectedPermissions.size()) {
            selectedPermIds[i] = ((Permission)selectedPermissions.get(i)).getId();
            ++i;
        }
        Arrays.sort(selectedPermIds);
        Object[] rolePermIds = this.role.getPermissionIds();
        Arrays.sort(rolePermIds);
        return !Arrays.equals(rolePermIds, selectedPermIds);
    }

    private void checkDataChange() {
        if (this.hasChanged()) {
            this.actionButton.setEnabled(true);
        } else {
            this.actionButton.setEnabled(false);
        }
    }

    public RoleDefinitionDialog(JFrame owner) {
        this.owner = owner;
    }
}

