/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.ias;

import csbase.client.ias.ManagerPanel;
import csbase.client.ias.RoleDefinitionDialog;
import csbase.client.ias.RoleUserDefinitionDialog;
import csbase.client.remote.srvproxies.RoleProxy;
import csbase.client.util.ClientUtilities;
import csbase.client.util.StandardErrorDialogs;
import csbase.client.util.SwingObserverWrapper;
import csbase.logic.Role;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Observer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.table.TableModel;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.StandardDialogs;
import tecgraf.javautils.gui.table.DefaultObjectTableProvider;
import tecgraf.javautils.gui.table.ObjectTableModel;
import tecgraf.javautils.gui.table.ObjectTableProvider;

public class RoleManagerPanel
extends ManagerPanel {
    private JFrame parent;
    private JButton associateButton;
    private static final int debug = 0;

    public RoleManagerPanel(JFrame parent) {
        this.parent = parent;
        Vector<Object> roles = RoleProxy.getAllRoles(parent, parent.getTitle(), LNG.get((String)"IAS_WAITING_ADMIN_DATA"));
        if (roles == null) {
            roles = new Vector();
        }
        Collections.sort(roles, Role.getNameComparator());
        DefaultObjectTableProvider provider = new DefaultObjectTableProvider(){

            public Object[] getCellValues(Object item) {
                Role role = (Role)item;
                if (role == null) {
                    return null;
                }
                return new Object[]{role.getId(), role.getName(), role.getDescription()};
            }

            public String[] getColumnNames() {
                String[] stringArray = new String[3];
                stringArray[1] = LNG.get((String)"IAS_ROLE_NAME");
                stringArray[2] = LNG.get((String)"IAS_ROLE_DESCRIPTION");
                return stringArray;
            }

            public Class<?>[] getColumnClasses() {
                return new Class[]{Object.class, String.class, String.class};
            }
        };
        ObjectTableModel model = new ObjectTableModel(roles, (ObjectTableProvider)provider);
        Comparator[] comparatorArray = new Comparator[3];
        comparatorArray[1] = ClientUtilities.getStringComparatorIgnoreCase();
        comparatorArray[2] = ClientUtilities.getStringComparatorIgnoreCase();
        Comparator[] comparators = comparatorArray;
        this.make((TableModel)model, comparators, false);
        Role.addObserver((Observer)new SwingObserverWrapper(this));
    }

    @Override
    public void beforeClose() {
        Role.deleteObserver((Observer)new SwingObserverWrapper(this));
    }

    @Override
    public void add() {
        new RoleDefinitionDialog(this.parent).showCreateDialog();
    }

    @Override
    public void modify(Object id) {
        Role role = this.getRole(id);
        if (role == null) {
            return;
        }
        new RoleDefinitionDialog(this.parent).showUpdateDialog(role);
    }

    private Role getRole(Object id) {
        Role role = RoleProxy.getRole(this.parent, this.parent.getTitle(), LNG.get((String)"IAS_WAITING_ROLE"), id);
        if (role == null) {
            this.displayError(LNG.get((String)"IAS_ROLEMGR_ROLE_NOT_FOUND"));
        }
        return role;
    }

    @Override
    public void delete(Object id) {
        Role role = this.getRole(id);
        if (role == null) {
            return;
        }
        String roleName = role.getName();
        int res = StandardDialogs.showYesNoDialog((Component)this.parent, (String)this.parent.getTitle(), (Object)MessageFormat.format(LNG.get((String)"IAS_ROLEMGR_ROLE_REMOVAL_CONFIRMATION"), roleName));
        if (res == 0) {
            RoleProxy.deleteRole(this.parent, this.parent.getTitle(), MessageFormat.format(LNG.get((String)"IAS_ROLEMGR_WAITING_REMOVE_ROLE"), roleName), role.getId());
        }
    }

    protected void displayMessage(String title, String message) {
        StandardDialogs.showInfoDialog((Component)this.parent, (String)title, (Object)message);
    }

    protected void displayError(String message) {
        StandardErrorDialogs.showErrorDialog((Window)this.parent, this.parent.getTitle(), message);
    }

    @Override
    protected JPanel makeButtons() {
        JPanel panel = super.makeButtons();
        panel.add(new JPanel());
        this.createAssociateButton(panel, false);
        return panel;
    }

    private void createAssociateButton(JPanel panel, boolean enabled) {
        this.associateButton = new JButton(LNG.get((String)"IAS_ROLE_USERS_BUTTON"));
        this.associateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = RoleManagerPanel.this.getTable().getSelectedRow();
                Object id = RoleManagerPanel.this.getRowId(row);
                RoleManagerPanel.this.associate(id);
            }
        });
        this.associateButton.setEnabled(enabled);
        panel.add(this.associateButton);
        this.addButtonToSelectionListener(this.associateButton);
    }

    protected void associate(Object id) {
        Role role = this.getRole(id);
        if (role == null) {
            return;
        }
        new RoleUserDefinitionDialog(this.parent).showDialog(role);
    }
}

