/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.ias;

import csbase.client.desktop.DesktopComponentDialog;
import csbase.client.remote.srvproxies.UserProxy;
import csbase.client.util.ClientUtilities;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.Role;
import csbase.logic.User;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.StandardDialogs;
import tecgraf.javautils.gui.selector.ContainerSelection;
import tecgraf.javautils.gui.selector.ContainerSelectionListener;
import tecgraf.javautils.gui.table.DefaultObjectTableProvider;
import tecgraf.javautils.gui.table.ObjectTableProvider;

public final class RoleUserDefinitionDialog {
    private JFrame owner;
    private String dialogTitle;
    private DesktopComponentDialog mainDialog;
    private Container cp;
    private boolean wasChanged;
    private ContainerSelection<User> usersSelection;
    private JButton actionButton;
    private Role role;

    public RoleUserDefinitionDialog(JFrame owner) {
        this.owner = owner;
        this.dialogTitle = LNG.get((String)"IAS_ROLE_USERS_TITLE");
        this.mainDialog = new DesktopComponentDialog((Window)this.owner, this.dialogTitle);
        this.cp = this.mainDialog.getContentPane();
        this.wasChanged = false;
    }

    public void showDialog(Role role) {
        this.role = role;
        Vector<User> users = this.getUsers();
        Vector<User> selectedUsers = this.getSelectedUsers(users);
        JPanel selectionPanel = this.createSelectionPanel(users, selectedUsers);
        this.cp.add((Component)selectionPanel, "Center");
        this.wasChanged = false;
        this.createActionButton();
        JButton closeButton = this.createCloseButton();
        ClientUtilities.adjustEqualSizes(this.actionButton, closeButton);
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.add(this.actionButton);
        buttonsPanel.add(closeButton);
        this.cp.add((Component)buttonsPanel, "South");
        this.mainDialog.pack();
        this.mainDialog.center(this.owner);
        this.mainDialog.setVisible(true);
    }

    private JButton createCloseButton() {
        JButton closeButton = new JButton(LNG.get((String)"IAS_CLOSE"));
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selected;
                Object[] options;
                if (RoleUserDefinitionDialog.this.wasChanged && (options = new Object[]{LNG.get((String)"IAS_ROLE_UPDATE"), LNG.get((String)"IAS_CANCEL")})[selected = JOptionPane.showOptionDialog(RoleUserDefinitionDialog.this.mainDialog, LNG.get((String)"IAS_ROLE_UPDATE_QUESTION"), RoleUserDefinitionDialog.this.dialogTitle, -1, 1, null, options, options[0])] == LNG.get((String)"IAS_ROLE_UPDATE")) {
                    RoleUserDefinitionDialog.this.updateRolesUserList();
                }
                RoleUserDefinitionDialog.this.mainDialog.close();
            }
        });
        return closeButton;
    }

    private void createActionButton() {
        this.actionButton = new JButton(LNG.get((String)"IAS_ROLE_UPDATE"));
        this.actionButton.setEnabled(false);
        this.actionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RoleUserDefinitionDialog.this.updateRolesUserList();
                RoleUserDefinitionDialog.this.mainDialog.close();
            }
        });
    }

    private Vector<User> getUsers() {
        Vector<User> users = null;
        users = UserProxy.getAllUsers(this.mainDialog, this.dialogTitle, String.valueOf(LNG.get((String)"ERRO")) + " - " + this.dialogTitle);
        for (User user : users) {
            if (!user.getId().equals(User.getAdminId())) continue;
            users.remove(user);
            break;
        }
        return users;
    }

    private Vector<User> getSelectedUsers(Vector users) {
        Vector<User> selectedUsers = new Vector<User>();
        for (User user : users) {
            if (user.getRole(this.role.getId()) == null) continue;
            selectedUsers.add(user);
        }
        return selectedUsers;
    }

    private JPanel createSelectionPanel(Vector<User> selectableUsers, Vector<User> selectedUsers) {
        DefaultObjectTableProvider selectableFormat = new DefaultObjectTableProvider(){

            public Object[] getCellValues(Object item) {
                String[] stringArray;
                User user = (User)item;
                if (user == null) {
                    stringArray = null;
                } else {
                    String[] stringArray2 = new String[2];
                    stringArray2[0] = user.getId().toString();
                    stringArray = stringArray2;
                    stringArray2[1] = user.getName();
                }
                return stringArray;
            }

            public String[] getColumnNames() {
                return new String[]{LNG.get((String)"IAS_USERS_KEY"), LNG.get((String)"IAS_AVAILABLE_USERS")};
            }

            public Class<?>[] getColumnClasses() {
                return new Class[]{String.class, String.class};
            }
        };
        DefaultObjectTableProvider selectedFormat = new DefaultObjectTableProvider(){

            public Object[] getCellValues(Object item) {
                String[] stringArray;
                User user = (User)item;
                if (user == null) {
                    stringArray = null;
                } else {
                    String[] stringArray2 = new String[2];
                    stringArray2[0] = user.getId().toString();
                    stringArray = stringArray2;
                    stringArray2[1] = user.getName();
                }
                return stringArray;
            }

            public String[] getColumnNames() {
                return new String[]{LNG.get((String)"IAS_USERS_KEY"), LNG.get((String)"IAS_SELECTED_USERS")};
            }

            public Class<?>[] getColumnClasses() {
                return new Class[]{String.class, String.class};
            }
        };
        this.usersSelection = new ContainerSelection((ObjectTableProvider)selectableFormat, (ObjectTableProvider)selectedFormat, true, false);
        this.usersSelection.loadItems(selectableUsers, selectedUsers);
        this.usersSelection.adjustTableColumns();
        this.usersSelection.addContainerSelectionListener(new ContainerSelectionListener(){

            public void containerChanged() {
                RoleUserDefinitionDialog.this.wasChanged = true;
                RoleUserDefinitionDialog.this.actionButton.setEnabled(true);
            }
        });
        return this.usersSelection.getPanel();
    }

    private void updateRolesUserList() {
        boolean success = true;
        try {
            List usersAvailable = this.usersSelection.getAvailableItems();
            for (User user : usersAvailable) {
                user.removeRole(this.role);
            }
            UserProxy.modifyUsers(this.owner, this.dialogTitle, LNG.get((String)"IAS_WAITING_USER_MODIFICATION"), usersAvailable);
            List usersSelected = this.usersSelection.getSelectedItems();
            for (User user : usersSelected) {
                user.addRole(this.role);
            }
            UserProxy.modifyUsers(this.owner, this.dialogTitle, LNG.get((String)"IAS_WAITING_USER_MODIFICATION"), usersSelected);
            String msg = LNG.get((String)(success ? "IAS_ROLE_UPDATED_WITH_SUCCESS" : "IAS_ROLE_UPDATED_WITH_ERROR"));
            StandardDialogs.showInfoDialog((Component)this.mainDialog, (String)this.dialogTitle, (Object)msg);
            this.wasChanged = false;
        }
        catch (Exception e) {
            success = false;
            StandardErrorDialogs.showErrorDialog((Window)this.owner, String.valueOf(LNG.get((String)"ERRO")) + " - " + this.dialogTitle, (Throwable)e);
        }
    }
}

