/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.ias;

import csbase.client.ias.AdminModifyUserInfoDialog;
import csbase.client.ias.ExportUsersDialog;
import csbase.client.ias.ImportUsersDialog;
import csbase.client.ias.IncludeUserInfoDialog;
import csbase.client.ias.ManagerPanel;
import csbase.client.ias.ModifyUserInfoDialog;
import csbase.client.ias.UserInfoCallBackInterface;
import csbase.client.ias.UserInfoDialog;
import csbase.client.remote.srvproxies.UserGroupProxy;
import csbase.client.remote.srvproxies.UserProxy;
import csbase.client.util.ClientUtilities;
import csbase.client.util.StandardErrorDialogs;
import csbase.client.util.SwingObserverWrapper;
import csbase.logic.AdministrationEvent;
import csbase.logic.User;
import csbase.logic.UserGroup;
import csbase.logic.UserOutline;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.table.TableModel;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GUIUtils;
import tecgraf.javautils.gui.StandardDialogs;
import tecgraf.javautils.gui.table.DefaultObjectTableProvider;
import tecgraf.javautils.gui.table.ObjectTableModel;
import tecgraf.javautils.gui.table.ObjectTableProvider;

public class UserManagerPanel
extends ManagerPanel {
    private JFrame parent;
    private JButton importCSVButton;
    private JButton exportCVSButton;
    private UserInfoDialog dialog;
    private UserInfoCallBackInterface callBack;
    public static SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");

    @Override
    public void beforeClose() {
        User.deleteObserver((Observer)new SwingObserverWrapper(this));
        UserGroup.deleteObserver((Observer)new SwingObserverWrapper(this));
    }

    @Override
    public void add() {
        Vector<UserGroup> userGroups = UserGroupProxy.getAllUserGroups(this.parent, this.parent.getTitle(), LNG.get((String)"IAS_WAITING_ALL_USERGROUPS"));
        if (userGroups == null || userGroups.size() == 0) {
            StandardDialogs.showInfoDialog((Component)this.parent, (String)this.parent.getTitle(), (Object)LNG.get((String)"IAS_NO_USERGROUPS"));
            return;
        }
        this.dialog = new IncludeUserInfoDialog(this.parent);
        ((IncludeUserInfoDialog)this.dialog).sendUserInfoCallBackObject(this.callBack);
        this.dialog.setVisible(true);
    }

    @Override
    public void modify(Object id) {
        this.dialog = User.getLoggedUser().isAdmin() ? new AdminModifyUserInfoDialog((Window)this.parent, id) : new ModifyUserInfoDialog((Window)this.parent, id);
        this.dialog.setVisible(true);
    }

    @Override
    public void delete(Object id) {
        User user = UserProxy.getUser(this.parent, this.parent.getTitle(), LNG.get((String)"IAS_WAITING_USER_INFO"), id);
        if (user == null) {
            this.displayError(LNG.get((String)"IAS_USERMGR_USER_NOT_FOUND"));
            return;
        }
        if (user.getId().equals(User.getAdminId())) {
            this.displayError(LNG.get((String)"IAS_USERMGR_ADMIN_CANNOT_BE_REMOVED_ERROR"));
            return;
        }
        Object[] options = new Object[]{LNG.get((String)"IAS_USERMGR_BUTTON_REMOVE"), LNG.get((String)"IAS_USERMGR_BUTTON_CANCEL")};
        int res = StandardDialogs.showOptionDialog((Component)this.parent, (String)this.parent.getTitle(), (Object)MessageFormat.format(LNG.get((String)"IAS_USERMGR_USER_REMOVAL_CONFIRMATION"), user.getLogin()), (Object[])options);
        if (res == 0) {
            UserProxy.deleteUser(this.parent, this.parent.getTitle(), MessageFormat.format(LNG.get((String)"IAS_USERMGR_WAITING_REMOVE_USER"), user.getLogin()), id);
        }
    }

    public void reload() {
        Vector<Object> userOutlines = UserProxy.getAllOutlines(this.parent, this.parent.getTitle(), LNG.get((String)"IAS_WAITING_ADMIN_DATA"));
        if (userOutlines == null) {
            userOutlines = new Vector();
        }
        super.setItems(userOutlines);
    }

    @Override
    public void doUpdate(Observable observable, Object arg) {
        AdministrationEvent action = (AdministrationEvent)arg;
        Object item = action.item;
        if (item instanceof UserGroup) {
            if (action.type == 2) {
                this.reload();
            }
        } else {
            super.doUpdate(observable, arg);
        }
    }

    protected void displayMessage(String title, String message) {
        StandardDialogs.showInfoDialog((Component)this.parent, (String)title, (Object)message);
    }

    protected void displayError(String message) {
        StandardErrorDialogs.showErrorDialog((Window)this.parent, this.parent.getTitle(), message);
    }

    public UserManagerPanel(JFrame parent) {
        this.parent = parent;
        Vector<Object> userOutlines = UserProxy.getAllOutlines(parent, parent.getTitle(), LNG.get((String)"IAS_WAITING_ADMIN_DATA"));
        if (userOutlines == null) {
            userOutlines = new Vector();
        }
        DefaultObjectTableProvider provider = new DefaultObjectTableProvider(){

            public Object[] getCellValues(Object item) {
                UserOutline outline = (UserOutline)item;
                if (outline == null) {
                    return null;
                }
                String date = null;
                if (outline.getCreationDate() != null) {
                    date = dateFormat.format(outline.getCreationDate());
                }
                return new Object[]{outline.getId(), outline.getLogin(), outline.getName(), outline.getUserGroup(), date};
            }

            public String[] getColumnNames() {
                String[] stringArray = new String[5];
                stringArray[1] = LNG.get((String)"IAS_USER");
                stringArray[2] = LNG.get((String)"IAS_USER_NAME");
                stringArray[3] = LNG.get((String)"IAS_USERGROUP");
                stringArray[4] = LNG.get((String)"IAS_USER_CREATION_DATE");
                return stringArray;
            }

            public Class<?>[] getColumnClasses() {
                return new Class[]{Object.class, String.class, String.class, String.class, String.class};
            }
        };
        ObjectTableModel model = new ObjectTableModel(userOutlines, (ObjectTableProvider)provider);
        Comparator[] comparatorArray = new Comparator[5];
        comparatorArray[1] = ClientUtilities.getStringComparatorIgnoreCase();
        comparatorArray[2] = ClientUtilities.getStringComparatorIgnoreCase();
        comparatorArray[3] = ClientUtilities.getStringComparatorIgnoreCase();
        comparatorArray[4] = ClientUtilities.getStringComparatorIgnoreCase();
        Comparator[] comparators = comparatorArray;
        this.make((TableModel)model, comparators, true);
        User.addObserver((Observer)new SwingObserverWrapper(this));
        UserGroup.addObserver((Observer)new SwingObserverWrapper(this));
    }

    public void setUserInfoCallBackObject(UserInfoCallBackInterface callBack) {
        this.callBack = callBack;
    }

    @Override
    protected JPanel makeButtons() {
        JPanel panel = super.makeButtons();
        panel.add(new JPanel());
        this.createImportButton(panel);
        this.createExportButton(panel);
        GUIUtils.matchPreferredSizes((JComponent[])new JComponent[]{this.importCSVButton, this.exportCVSButton});
        return panel;
    }

    private void createImportButton(JPanel panel) {
        this.importCSVButton = new JButton(LNG.get((String)"IAS_IMPORT_USERS_BUTTON"));
        this.importCSVButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new ImportUsersDialog(UserManagerPanel.this.parent).showDialog();
            }
        });
        panel.add(this.importCSVButton);
    }

    private void createExportButton(JPanel panel) {
        this.exportCVSButton = new JButton(LNG.get((String)"IAS_EXPORT_USERS_BUTTON"));
        this.exportCVSButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new ExportUsersDialog(UserManagerPanel.this.parent).showDialog();
            }
        });
        panel.add(this.exportCVSButton);
    }
}

