/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.login;

import csbase.client.login.AbstractLoginUI;
import csbase.client.login.InitialContext;
import csbase.client.login.LocaleComboBoxItem;
import csbase.client.login.LocaleComboBoxModel;
import csbase.client.login.LoginMessage;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import tecgraf.javautils.configurationmanager.Configuration;
import tecgraf.javautils.configurationmanager.ConfigurationManager;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.GUIUtils;
import tecgraf.javautils.gui.SwingThreadDispatcher;

public class LoginUI
extends AbstractLoginUI {
    private static final String IMAGE_PATH_PROPERTY = "image.path";
    private static final String ICON_PATH_PROPERTY = "icon.path";
    private static final String ICON_DIRECTORY = "/csbase/client/resources/applicationimages/";
    private final Configuration configuration;
    private final JProgressBar progressBar = LoginUI.createProgressBar(Color.black);
    private JPanel statusPanel;
    private JLabel messageLabel;
    private JPanel dataPanel;
    private JLabel image;
    private JPanel inputPanel;
    private JComponent[][] extraInputComponents;
    private final JFrame frame = new JFrame();
    private final JButton loginButton = new JButton("");
    private final JButton cancelButton = new JButton("");
    private final JTextField loginTextField = new JTextField();
    private final JPasswordField passwordTextField = new JPasswordField();
    private final JComboBox languageComboBox = new JComboBox();

    public LoginUI() {
        this.frame.setResizable(false);
        this.setButtonsListeners();
        this.registerDefaultActions(this.frame);
        this.frame.setDefaultCloseOperation(0);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                LoginUI.this.cancel();
            }
        });
        try {
            this.configuration = ConfigurationManager.getInstance().getConfiguration(this.getClass());
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    protected void initializeUI(Locale locale) {
        this.languageComboBox.setModel(new LocaleComboBoxModel());
        int i = 0;
        while (i < this.languageComboBox.getItemCount()) {
            LocaleComboBoxItem comboItem = (LocaleComboBoxItem)this.languageComboBox.getItemAt(i);
            Locale itemLocale = comboItem.getLocale();
            if (itemLocale.equals(locale)) {
                LocaleComboBoxModel model = (LocaleComboBoxModel)this.languageComboBox.getModel();
                model.setSelectedItem(comboItem);
                break;
            }
            ++i;
        }
        this.mountDialog();
        this.frame.pack();
        GUIUtils.centerOnScreen((Window)this.frame);
        this.frame.toFront();
    }

    @Override
    protected void updateUIForLoginStarting() {
        this.showProgress();
        this.disableDialog();
    }

    @Override
    protected String getLogin() {
        return this.loginTextField.getText();
    }

    @Override
    protected String getPassword() {
        return new String(this.passwordTextField.getPassword());
    }

    @Override
    protected Locale getSelectedLocale() {
        LocaleComboBoxItem selectedLocale = (LocaleComboBoxItem)this.languageComboBox.getSelectedItem();
        return selectedLocale.getLocale();
    }

    @Override
    protected boolean validateLoginUI() {
        if (this.getLogin().isEmpty()) {
            this.showInvalidLoginMessage(LoginMessage.EMPTY_LOGIN);
            this.passwordTextField.setText("");
            this.loginTextField.requestFocusInWindow();
            return false;
        }
        if (this.getPassword().isEmpty()) {
            if (!this.loginTextField.isFocusOwner()) {
                this.showInvalidLoginMessage(LoginMessage.EMPTY_PASSWORD);
            }
            this.passwordTextField.requestFocusInWindow();
            return false;
        }
        return true;
    }

    private void restoreDialog(final LoginMessage message, final boolean enableLogin) {
        SwingThreadDispatcher.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                LoginUI.this.passwordTextField.setText("");
                LoginUI.this.enableDialog();
                LoginUI.this.showInvalidLoginMessage(message);
                LoginUI.this.hideProgress();
                LoginUI.this.loginButton.setEnabled(enableLogin);
            }
        });
    }

    @Override
    protected void updateUIForInvalidLoginInfo() {
        this.restoreDialog(LoginMessage.INVALID_LOGIN_INFO, true);
        this.loginTextField.requestFocusInWindow();
    }

    @Override
    protected void updateUIForInvalidClientVersion() {
        this.restoreDialog(LoginMessage.INVALID_CLIENT_VERSION, false);
    }

    @Override
    protected void updateUIForLoginException() {
        this.restoreDialog(LoginMessage.LOGIN_EXCEPTION, true);
    }

    @Override
    public void preClientInitializationException() {
        this.adjustDialogStatus(true);
    }

    protected final JFrame getFrame() {
        return this.frame;
    }

    protected final JButton getLoginButton() {
        return this.loginButton;
    }

    protected final JButton getCancelButton() {
        return this.cancelButton;
    }

    protected final JTextField getLoginTextField() {
        return this.loginTextField;
    }

    protected final JPasswordField getPasswordTextField() {
        return this.passwordTextField;
    }

    protected final JComboBox getLanguageComboBox() {
        return this.languageComboBox;
    }

    @Override
    protected void setLogin(String login) {
        this.getLoginTextField().setText(login);
    }

    @Override
    protected void setPassword(String password) {
        this.getPasswordTextField().setText(password);
    }

    @Override
    protected void cancel() {
        this.setCanceled(true);
        this.disposeUI();
        this.unlock();
    }

    @Override
    public void disposeUI() {
        this.frame.dispose();
    }

    private void disableDialog() {
        this.frame.setCursor(Cursor.getPredefinedCursor(3));
        this.loginButton.setEnabled(false);
        this.cancelButton.setEnabled(false);
        this.adjustDialogStatus(false);
    }

    private void enableDialog() {
        this.frame.setCursor(Cursor.getPredefinedCursor(0));
        this.adjustDialogStatus(true);
        this.loginButton.setEnabled(true);
        this.cancelButton.setEnabled(true);
    }

    @Override
    public void preClientInitialization() {
        this.showProgress();
    }

    private void setButtonsListeners() {
        this.loginButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                LoginUI.this.login();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                LoginUI.this.cancel();
            }
        });
    }

    @Override
    public InitialContext getLoginData() {
        if (this.isCanceled()) {
            return null;
        }
        LocaleComboBoxItem item = (LocaleComboBoxItem)this.languageComboBox.getSelectedItem();
        InitialContext loginData = new InitialContext(item.getLocale());
        return loginData;
    }

    @Override
    protected void showUI() {
        this.frame.setVisible(true);
    }

    private Image createIconImage() {
        String iconPath = this.configuration.getOptionalProperty(ICON_PATH_PROPERTY);
        if (iconPath == null) {
            return null;
        }
        URL iconPathUrl = this.getClass().getResource(iconPath);
        return Toolkit.getDefaultToolkit().getImage(iconPathUrl);
    }

    private void addMessageLabel() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.insets = new Insets(3, 3, 2, 2);
        gbc.anchor = 17;
        this.statusPanel.add((Component)this.messageLabel, gbc);
    }

    private JPanel createMainPanel() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridBagLayout());
        this.dataPanel = this.createDataPanel();
        mainPanel.add((Component)this.dataPanel, new GBC(1, 1));
        mainPanel.add((Component)this.createButtonPanel(), new GBC(1, 2));
        return mainPanel;
    }

    private JPanel createButtonPanel() {
        JButton loginButton = this.getLoginButton();
        loginButton.setText("Entrar");
        JButton cancelButton = this.getCancelButton();
        cancelButton.setText("Cancelar");
        JComponent[] cmps = new JComponent[]{loginButton, cancelButton};
        GUIUtils.matchPreferredSizes((JComponent[])cmps);
        JPanel buttonPanel = new JPanel(new FlowLayout());
        buttonPanel.add(loginButton);
        buttonPanel.add(cancelButton);
        return buttonPanel;
    }

    public void addExtraInputComponents(JComponent[][] extraComponents) {
        this.extraInputComponents = extraComponents;
    }

    protected JPanel createDataPanel() {
        JTextField loginTextField = this.getLoginTextField();
        JLabel userLabel = new JLabel("Usu\u00e1rio:");
        JPasswordField passwordTextField = this.getPasswordTextField();
        JLabel passwordLabel = new JLabel("Senha:");
        JComboBox languageComboBox = this.getLanguageComboBox();
        JLabel localeLabel = new JLabel("Idioma:");
        JPanel panel = new JPanel(new GridBagLayout());
        this.image = this.createImageLabel();
        if (this.image != null) {
            panel.add((Component)this.image, new GBC(0, 0).center().insets(5, 10, 5, 5));
        }
        JComponent[][] inputComponents = new JComponent[][]{{userLabel, loginTextField}, {passwordLabel, passwordTextField}, {localeLabel, languageComboBox}};
        if (this.extraInputComponents != null) {
            int c = inputComponents[0].length + this.extraInputComponents[0].length;
            int r = inputComponents.length + this.extraInputComponents.length;
            JComponent[][] jc = new JComponent[r][c];
            System.arraycopy(inputComponents, 0, jc, 0, inputComponents.length);
            System.arraycopy(this.extraInputComponents, 0, jc, inputComponents.length, this.extraInputComponents.length);
            this.inputPanel = GUIUtils.createBasicGridPanel((JComponent[][])jc);
        } else {
            this.inputPanel = GUIUtils.createBasicGridPanel((JComponent[][])inputComponents);
        }
        panel.add((Component)this.inputPanel, new GBC(1, 0).center());
        return panel;
    }

    private JLabel createImageLabel() {
        String imagePath = this.configuration.getOptionalProperty(IMAGE_PATH_PROPERTY);
        if (imagePath == null) {
            return null;
        }
        URL imagePathUrl = this.getClass().getResource(imagePath);
        return new JLabel(new ImageIcon(imagePathUrl));
    }

    protected void showProgress() {
        String property = "progress.message";
        String progressMessage = this.configuration.getOptionalProperty("progress.message", "Aguarde...");
        this.progressBar.setString(progressMessage);
        if (this.messageLabel != null) {
            this.statusPanel.remove(this.messageLabel);
        }
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.fill = 1;
        this.statusPanel.add((Component)this.progressBar, gbc);
        this.statusPanel.validate();
        this.statusPanel.repaint();
    }

    protected void hideProgress() {
        this.statusPanel.remove(this.progressBar);
        this.addMessageLabel();
        JFrame frame = this.getFrame();
        frame.pack();
        this.statusPanel.validate();
        this.statusPanel.repaint();
    }

    private static JProgressBar createProgressBar(Color c) {
        Object selectionBackground = UIManager.get("ProgressBar.selectionBackground");
        Object selectionForeground = UIManager.get("ProgressBar.selectionForeground");
        UIManager.put("ProgressBar.selectionBackground", new ColorUIResource(c));
        UIManager.put("ProgressBar.selectionForeground", new ColorUIResource(c));
        JProgressBar pb = new JProgressBar();
        UIManager.put("ProgressBar.selectionBackground", selectionBackground);
        UIManager.put("ProgressBar.selectionForeground", selectionForeground);
        pb.setIndeterminate(true);
        pb.setStringPainted(true);
        return pb;
    }

    private void setEnableContainer(Container container, boolean b) {
        Component[] componentArray = container.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            if (c instanceof Container) {
                this.setEnableContainer((Container)c, b);
            }
            c.setEnabled(b);
            ++n2;
        }
    }

    protected void adjustDialogStatus(boolean status) {
        if (status) {
            this.setEnableContainer(this.dataPanel, true);
        } else {
            this.setEnableContainer(this.dataPanel, false);
            if (this.image != null) {
                this.image.setEnabled(true);
            }
        }
    }

    protected void showInvalidLoginMessage(LoginMessage msg) {
        ImageIcon ERROR_ICON = new ImageIcon(LoginUI.class.getResource("/csbase/client/resources/applicationimages/Error16.png"));
        this.messageLabel.setVerticalTextPosition(1);
        this.messageLabel.setIcon(ERROR_ICON);
        this.messageLabel.setText(msg.getDefaultDescription());
    }

    protected void showDefaultLoginMessage() {
        String property = "status.message";
        String statusMessage = this.configuration.getOptionalProperty(property);
        if (statusMessage == null) {
            return;
        }
        ImageIcon INFO_ICON = new ImageIcon(LoginUI.class.getResource("/csbase/client/resources/applicationimages/Information16.png"));
        this.messageLabel.setVerticalTextPosition(1);
        this.messageLabel.setIcon(INFO_ICON);
        this.messageLabel.setText(statusMessage);
    }

    protected void mountDialog() {
        JFrame frame = this.getFrame();
        String title = this.getTitle();
        frame.setTitle(title);
        Image icon = this.createIconImage();
        if (icon != null) {
            frame.setIconImage(icon);
        }
        JTextField loginText = this.getLoginTextField();
        JPasswordField pwdText = this.getPasswordTextField();
        int N = 15;
        pwdText.setColumns(15);
        loginText.setColumns(15);
        JPanel panel = new JPanel(new BorderLayout());
        JPanel mainPanel = this.createMainPanel();
        panel.add((Component)mainPanel, "Center");
        this.statusPanel = new JPanel(new GridBagLayout());
        this.statusPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        panel.add((Component)this.statusPanel, "South");
        this.messageLabel = new JLabel();
        this.showDefaultLoginMessage();
        if (this.messageLabel != null) {
            this.addMessageLabel();
        }
        frame.setContentPane(panel);
    }

    protected String getTitle() {
        return this.configuration.getOptionalProperty("title", "CSBase");
    }
}

