/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.openbus;

import csbase.client.openbus.OpenBusAccessPoint;
import csbase.client.openbus.OpenBusEventReceiverInterface;
import csbase.exception.CSBaseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.StringHolder;
import org.omg.PortableServer.Servant;
import scs.core.ComponentContext;
import scs.core.ComponentId;
import scs.core.IComponent;
import scs.core.IComponentHelper;
import scs.core.IComponentHolder;
import scs.core.exception.SCSException;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.openbus.session_service.v1_05.ISession;
import tecgraf.openbus.session_service.v1_05.ISessionHelper;
import tecgraf.openbus.session_service.v1_05.ISessionService;
import tecgraf.openbus.session_service.v1_05.ISessionServiceHelper;
import tecgraf.openbus.session_service.v1_05.SessionEvent;
import tecgraf.openbus.session_service.v1_05.SessionEventSink;
import tecgraf.openbus.session_service.v1_05.SessionEventSinkHelper;
import tecgraf.openbus.session_service.v1_05.SessionEventSinkPOA;

public class OpenBusSession {
    private static final String SEP = "___@@___";
    private final List<OpenBusEventReceiverInterface> eventReceivers = new ArrayList<OpenBusEventReceiverInterface>();
    private IComponent sessionMember;
    private String sessionMemberIdentifier;
    private ISession session;
    private SessionEventSink sessionEventSink;
    private SessionEventSinkPOA sessionMemberEventSinkServant;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public OpenBusSession(Class<? extends SessionEventSinkPOA> sessionEventSinkClass) throws CSBaseException {
        Object obj;
        ISessionService ss;
        if (sessionEventSinkClass != null) {
            try {
                this.sessionMemberEventSinkServant = sessionEventSinkClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new CSBaseException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new CSBaseException((Throwable)e);
            }
            ComponentId componentId = new ComponentId("SessionEventSink", 1, 0, 0, "Java");
            try {
                ComponentContext context = new ComponentContext(OpenBusAccessPoint.getInstance().getORB(), OpenBusAccessPoint.getInstance().getRootPOA(), componentId);
                context.addFacet("SessionEventSink", SessionEventSinkHelper.id(), (Servant)this.sessionMemberEventSinkServant);
                IComponent obj2 = context.getIComponent();
                this.sessionMember = IComponentHelper.narrow((Object)obj2);
            }
            catch (SCSException e) {
                throw new CSBaseException((Throwable)e);
            }
        }
        if ((ss = this.getSessionService()) == null) {
            throw new CSBaseException();
        }
        if (this.sessionMember == null) return;
        IComponent sessionComponent = ss.getSession();
        if (sessionComponent == null) {
            IComponentHolder sessionComponentHolder = new IComponentHolder();
            StringHolder memberIdentifierHolder = new StringHolder();
            boolean created = ss.createSession(this.sessionMember, sessionComponentHolder, memberIdentifierHolder);
            if (!created) throw new IllegalStateException("Cannot create OpenBus session!");
            sessionComponent = sessionComponentHolder.value;
            obj = sessionComponent.getFacet(ISessionHelper.id());
            this.session = ISessionHelper.narrow((Object)obj);
            this.sessionMemberIdentifier = memberIdentifierHolder.value;
        } else {
            obj = sessionComponent.getFacet(ISessionHelper.id());
            this.session = ISessionHelper.narrow((Object)obj);
            this.sessionMemberIdentifier = this.session.addMember(this.sessionMember);
        }
        obj = sessionComponent.getFacet(SessionEventSinkHelper.id());
        this.sessionEventSink = SessionEventSinkHelper.narrow((Object)obj);
    }

    private ISessionService getSessionService() throws CSBaseException {
        Properties props = new Properties();
        props.put("openbus.component.interface", ISessionServiceHelper.id());
        IComponent component = OpenBusAccessPoint.getInstance().findService(props);
        if (component == null) {
            throw new CSBaseException(this.getString("service.error"));
        }
        Object facet = component.getFacet(ISessionServiceHelper.id());
        ISessionService sessionService = ISessionServiceHelper.narrow((Object)facet);
        return sessionService;
    }

    public SessionEventSink getSessionEventSink() {
        return this.sessionEventSink;
    }

    public String getSessionMemberIdentifier() {
        return this.sessionMemberIdentifier;
    }

    public SessionEventSinkPOA getSessionMemberEventSinkServant() {
        return this.sessionMemberEventSinkServant;
    }

    protected final void signalEventReceived(boolean treated, String sourceId, String destId, String type, java.lang.Object value) {
        String msg = this.createEventDebugString("RECEIVED", treated, sourceId, destId, type, value);
        System.out.println(msg);
    }

    private String createEventDebugString(String prefix, boolean treated, String sourceId, String destId, String type, java.lang.Object value) {
        String className = "NULL";
        String valueText = "null";
        if (value != null) {
            className = value.getClass().getSimpleName();
            valueText = value.toString();
        }
        Date now = new Date();
        String fmt = "%1$tH:%1$tM:%1$tS:%1$tL - %1$td/%1$tm";
        String timePart = String.format("%1$tH:%1$tM:%1$tS:%1$tL - %1$td/%1$tm", now);
        String headerPart = "[" + timePart + "] " + prefix + " EVENT ";
        String pathPart = String.valueOf(sourceId) + " ---> " + destId + " / ";
        String treatedPart = String.valueOf(type) + " (treated = " + treated + ") ";
        String initPart = String.valueOf(headerPart) + pathPart + treatedPart;
        String valuePart = "- [" + className + "]; value = \"" + valueText + "\"";
        String msg = String.valueOf(initPart) + valuePart;
        return msg;
    }

    private void signalEventSent(boolean treated, String sourceId, String destId, String type, java.lang.Object value) {
        String msg = this.createEventDebugString("SENT", treated, sourceId, destId, type, value);
        System.out.println(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<OpenBusEventReceiverInterface> getEventReceivers() {
        List<OpenBusEventReceiverInterface> list = this.eventReceivers;
        synchronized (list) {
            return this.eventReceivers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addEventReceiver(OpenBusEventReceiverInterface receiver) {
        if (receiver == null) {
            String err = this.getString("null.receiver.error");
            throw new IllegalArgumentException(err);
        }
        List<OpenBusEventReceiverInterface> list = this.eventReceivers;
        synchronized (list) {
            this.eventReceivers.add(receiver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void delEventReceiver(OpenBusEventReceiverInterface receiver) {
        if (receiver == null) {
            String err = this.getString("null.receiver.error");
            throw new IllegalArgumentException(err);
        }
        List<OpenBusEventReceiverInterface> list = this.eventReceivers;
        synchronized (list) {
            this.eventReceivers.remove(receiver);
        }
    }

    private Any createAny() {
        ORB orb = OpenBusAccessPoint.getInstance().getORB();
        Any any = orb.create_any();
        return any;
    }

    boolean internalSendEventWithNoValue(String sourceId, String destId, String type) {
        Any any = this.createAny();
        String rawType = this.insertPathTypeData(sourceId, destId, type);
        this.sessionEventSink.push(this.sessionMemberIdentifier, new SessionEvent(rawType, any));
        System.out.println(rawType);
        this.signalEventSent(true, sourceId, destId, type, null);
        return true;
    }

    boolean internalSendEventWithStringValue(String sourceId, String destId, String type, String stringValue) {
        Any any = this.createAny();
        any.insert_string(stringValue);
        String rawType = this.insertPathTypeData(sourceId, destId, type);
        this.sessionEventSink.push(this.sessionMemberIdentifier, new SessionEvent(rawType, any));
        this.signalEventSent(true, sourceId, destId, type, stringValue);
        return true;
    }

    private void checkHasNoSeparatorString(String string) {
        if (string.matches("")) {
            String fmt = "Bad string for event mount: %s";
            String err = String.format("Bad string for event mount: %s", string);
            throw new IllegalArgumentException(err);
        }
    }

    private void checkNotNullString(String string, String text) {
        if (string == null) {
            String fmt = "Null string event (part: %s) detected!";
            String err = String.format("Null string event (part: %s) detected!", text);
            throw new IllegalArgumentException(err);
        }
    }

    private String insertPathTypeData(String sourceId, String destId, String type) {
        this.checkNotNullString(type, "type");
        this.checkHasNoSeparatorString(sourceId);
        this.checkHasNoSeparatorString(destId);
        this.checkHasNoSeparatorString(type);
        String sId = sourceId == null ? "" : sourceId;
        String dId = destId == null ? "" : destId;
        String typePart = type.trim();
        String sourceIdPart = sId.trim();
        String destIdPart = dId.trim();
        String rawType = String.valueOf(sourceIdPart) + SEP + destIdPart + SEP + typePart;
        return rawType;
    }

    String[] extractPathTypeData(String receivedRawType) {
        String type;
        String destId;
        String sourceId;
        this.checkNotNullString(receivedRawType, "raw-type");
        String rawType = receivedRawType.trim();
        String[] array = rawType.split(SEP);
        if (array != null && array.length == 3) {
            String arg0 = array[0];
            String arg1 = array[1];
            String arg2 = array[2];
            this.checkNotNullString(arg0, "source");
            this.checkNotNullString(arg1, "destination");
            this.checkNotNullString(arg2, "type");
            sourceId = arg0.trim();
            destId = arg1.trim();
            type = arg2.trim();
            if (type.isEmpty()) {
                String err = "Empty converted type (\"\") not allowed!";
                throw new IllegalArgumentException("Empty converted type (\"\") not allowed!");
            }
        } else {
            sourceId = null;
            destId = null;
            type = rawType;
        }
        String[] extracted = new String[]{sourceId, destId, type};
        return extracted;
    }

    boolean internalSendEventWithBooleanValue(String sourceId, String destId, String type, boolean booleanValue) {
        Any any = this.createAny();
        any.insert_boolean(booleanValue);
        String rawType = this.insertPathTypeData(sourceId, destId, type);
        this.sessionEventSink.push(this.sessionMemberIdentifier, new SessionEvent(rawType, any));
        this.signalEventSent(true, sourceId, destId, type, booleanValue);
        return true;
    }

    private String getString(String key) {
        String prefix = this.getClass().getSimpleName();
        return LNG.get((String)(String.valueOf(prefix) + "." + key));
    }
}

