/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.preferences.editors;

import csbase.client.applicationmanager.ApplicationManager;
import csbase.client.applicationmanager.resourcehelpers.ApplicationSelectionDialog;
import csbase.client.applications.ApplicationImages;
import csbase.client.preferences.PreferenceEditor;
import csbase.client.preferences.PreferenceValue;
import csbase.logic.applicationservice.ApplicationRegistry;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import tecgraf.javautils.gui.GBC;

public class FavoriteApplicationsEditor
extends PreferenceEditor<List<String>> {
    public FavoriteApplicationsEditor(PreferenceValue<List<String>> pv) {
        super(pv);
    }

    @Override
    protected JComponent createComponent() {
        AbstractTableModel model = new AbstractTableModel(){

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                return ((List)FavoriteApplicationsEditor.this.getValue()).get(rowIndex);
            }

            @Override
            public int getRowCount() {
                return ((List)FavoriteApplicationsEditor.this.getValue()).size();
            }

            @Override
            public String getColumnName(int column) {
                return null;
            }

            @Override
            public int getColumnCount() {
                return 1;
            }
        };
        JTable table = new JTable();
        table.setModel(model);
        table.setSelectionMode(2);
        table.setShowHorizontalLines(false);
        table.setDefaultRenderer(Object.class, new InternalRenderer());
        JScrollPane pane = new JScrollPane(table);
        pane.setPreferredSize(new Dimension(400, 200));
        JToolBar toolbar = this.buildToolbar(table);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)pane, new GBC(0, 0).both());
        panel.add((Component)toolbar, new GBC(1, 0).vertical());
        this.setTitledBorder(panel);
        return panel;
    }

    private JToolBar buildToolbar(JTable table) {
        JToolBar toolbar = new JToolBar(1);
        toolbar.setFloatable(false);
        AbstractAction addAction = this.buildAddAction(table);
        AbstractAction delAction = this.buildDelAction(table);
        addAction.setEnabled(this.isEditable());
        delAction.setEnabled(this.isEditable());
        toolbar.add(addAction);
        toolbar.add(delAction);
        return toolbar;
    }

    private AbstractAction buildDelAction(final JTable table) {
        AbstractAction delAction = new AbstractAction(null, ApplicationImages.ICON_ROWDELETE_16){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] rowIds = table.getSelectedRows();
                if (rowIds == null || rowIds.length == 0) {
                    return;
                }
                List value = (List)FavoriteApplicationsEditor.this.getValue();
                ArrayList<String> appsToRemove = new ArrayList<String>(rowIds.length);
                int[] nArray = rowIds;
                int n = rowIds.length;
                int n2 = 0;
                while (n2 < n) {
                    int rowId = nArray[n2];
                    appsToRemove.add((String)value.get(rowId));
                    ++n2;
                }
                value.removeAll(appsToRemove);
                FavoriteApplicationsEditor.this.updateTable(table);
                FavoriteApplicationsEditor.this.notifyListeners();
            }
        };
        return delAction;
    }

    private AbstractAction buildAddAction(final JTable table) {
        AbstractAction addAction = new AbstractAction(null, ApplicationImages.ICON_ADD_16){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList regs = FavoriteApplicationsEditor.this.getOthersApplicationsRegistries();
                ApplicationSelectionDialog dialog = new ApplicationSelectionDialog(null, regs);
                dialog.setTitle(FavoriteApplicationsEditor.this.getLabel());
                dialog.setVisible(true);
                List<String> ids = dialog.getSelectedApplications();
                List value = (List)FavoriteApplicationsEditor.this.getValue();
                for (String id : ids) {
                    if (value.contains(id)) continue;
                    value.add(id);
                }
                FavoriteApplicationsEditor.this.updateTable(table);
                FavoriteApplicationsEditor.this.notifyListeners();
            }
        };
        return addAction;
    }

    private void updateTable(JTable table) {
        ((AbstractTableModel)table.getModel()).fireTableDataChanged();
    }

    private ArrayList<ApplicationRegistry> getOthersApplicationsRegistries() {
        ApplicationManager manager = ApplicationManager.getInstance();
        ArrayList<ApplicationRegistry> allRegs = manager.getAllApplicationRegistries();
        ArrayList<ApplicationRegistry> regs = new ArrayList<ApplicationRegistry>();
        for (ApplicationRegistry reg : allRegs) {
            String id = reg.getId();
            if (((List)this.getValue()).contains(id)) continue;
            regs.add(reg);
        }
        return regs;
    }

    private class InternalRenderer
    extends DefaultTableCellRenderer {
        private final Color LIGHT = new Color(15266558);

        private InternalRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component cmp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            JLabel label = (JLabel)cmp;
            label.setText(null);
            label.setIcon(null);
            label.setHorizontalAlignment(10);
            String id = (String)value;
            if (id == null) {
                return label;
            }
            ApplicationManager manager = ApplicationManager.getInstance();
            ApplicationRegistry reg = manager.getApplicationRegistry(id);
            if (reg == null) {
                label.setText("!!!");
            } else {
                Locale locale = manager.getLocale();
                label.setText(reg.getApplicationName(locale));
                label.setIcon(manager.getApplicationIcon(id));
            }
            if (!isSelected) {
                label.setBackground(row % 2 == 0 ? Color.WHITE : this.LIGHT);
            }
            return label;
        }
    }
}

