/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.preferences.types;

import csbase.client.facilities.configurabletable.table.ColumnState;
import csbase.client.facilities.configurabletable.table.ConfigurableTable;
import csbase.client.preferences.PreferenceValue;
import csbase.client.preferences.definition.PreferenceDefinition;
import csbase.client.preferences.definition.PreferencePolicy;
import csbase.client.preferences.editors.PVTablesEditor;
import csbase.client.preferences.util.PreferenceBundle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PVTables
extends PreferenceValue<Map<String, List<ColumnState>>> {
    public PVTables(PreferenceDefinition name, String value, String defaultValue, PreferencePolicy policy, PreferenceBundle preferenceBundle) {
        super(name, value, defaultValue, policy, preferenceBundle);
        this.setPreferenceEditorClass(PVTablesEditor.class);
    }

    @Override
    public String getClassName() {
        return this.getClass().getName();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry entry : ((Map)this.getValue()).entrySet()) {
            String tableId = (String)entry.getKey();
            List states = (List)entry.getValue();
            builder.append(tableId);
            builder.append("=");
            builder.append(this.serializeStates(states));
            builder.append(";");
        }
        return builder.toString();
    }

    @Override
    public Map<String, List<ColumnState>> toValue(String value) {
        Pattern p = Pattern.compile("(.*?)=(.*?);");
        HashMap<String, List<ColumnState>> result = new HashMap<String, List<ColumnState>>();
        Matcher m = p.matcher(value);
        while (m.find()) {
            result.put(m.group(1), this.deserializeState(m.group(2)));
        }
        return result;
    }

    @Override
    public PreferenceValue<Map<String, List<ColumnState>>> clone() {
        return new PVTables(this.name, this.toString(), this.defaultValue, this.policy, this.preferenceBundle);
    }

    public void loadTables(List<ConfigurableTable<?>> tables) {
        if (tables == null) {
            throw new IllegalArgumentException("tables n\u00e3o pode ser nulo.");
        }
        for (ConfigurableTable<?> table : tables) {
            this.loadTable(table);
        }
    }

    public void loadTable(ConfigurableTable<?> table) {
        if (table == null) {
            throw new IllegalArgumentException("table n\u00e3o pode ser nulo.");
        }
        Map v = (Map)this.getValue();
        List columnsState = (List)v.get(table.getId());
        if (columnsState != null && !columnsState.isEmpty()) {
            table.setColumnsState(columnsState);
            table.updateColumns();
        }
    }

    public void storeTables(List<ConfigurableTable<?>> tables) {
        if (tables == null) {
            throw new IllegalArgumentException("tables n\u00e3o pode ser nulo.");
        }
        for (ConfigurableTable<?> table : tables) {
            this.storeTable(table);
        }
    }

    public void storeTable(ConfigurableTable<?> table) {
        if (table == null) {
            throw new IllegalArgumentException("table n\u00e3o pode ser nulo.");
        }
        Map v = (Map)this.getValue();
        v.put(table.getId(), table.getColumnsState());
    }

    private String serializeStates(List<ColumnState> states) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < states.size()) {
            ColumnState state = states.get(i);
            builder.append("[");
            builder.append(state.getColumnId());
            builder.append(",");
            builder.append(state.isVisible());
            builder.append("]");
            if (i != states.size() - 1) {
                builder.append(",");
            }
            ++i;
        }
        return builder.toString();
    }

    private List<ColumnState> deserializeState(String states) {
        String[] statesArray;
        ArrayList<ColumnState> result = new ArrayList<ColumnState>();
        String[] stringArray = statesArray = states.split(",(?=\\[)");
        int n = statesArray.length;
        int n2 = 0;
        while (n2 < n) {
            String state = stringArray[n2];
            String columnId = state.substring(state.indexOf("[") + 1, state.indexOf(","));
            String visible = state.substring(state.indexOf(",") + 1, state.indexOf("]"));
            result.add(new ColumnState(columnId, Boolean.valueOf(visible)));
            ++n2;
        }
        return result;
    }
}

