/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.project;

import csbase.client.desktop.RemoteTask;
import csbase.client.project.ProjectFileContainer;
import csbase.client.project.TransferableNode;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.ClientProjectFile;
import csbase.util.restart.RestartListener;
import csbase.util.restart.RestartManager;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.InputEvent;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import tecgraf.javautils.core.lng.LNG;

public abstract class AbstractProjectFileTransferHandler
extends TransferHandler {
    private static final DataFlavor[] _flavors = new DataFlavor[]{ProjectFileContainer.PROJECT_FILE_FLAVOR};
    private final Window _ownerWindow;
    private final String _ownerTitle;

    public AbstractProjectFileTransferHandler(Window ownerWindow, String ownerTitle) {
        this._ownerWindow = ownerWindow;
        this._ownerTitle = ownerTitle;
    }

    public boolean hasTransferableInClipboard() {
        TransferInfo info = TransferInfoManager.getTransferInfo();
        return info != null && info instanceof ClipboardTransferInfo;
    }

    public void clearClipboard() {
        if (this.hasTransferableInClipboard()) {
            TransferInfoManager.clear();
        }
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 3;
    }

    @Override
    public boolean canImport(JComponent c, DataFlavor[] flavor) {
        int i = 0;
        int n = flavor.length;
        while (i < n) {
            int j = 0;
            int m = _flavors.length;
            while (j < m) {
                if (flavor[i].equals(_flavors[j])) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    @Override
    public void exportAsDrag(JComponent source, InputEvent event, int action) {
        TransferInfoManager.setTransferInfo(new DragTransferInfo(source));
        super.exportAsDrag(source, event, action);
    }

    @Override
    public void exportToClipboard(JComponent source, Clipboard clip, int action) {
        this.clearClipboard();
        if (clip != null) {
            throw new IllegalArgumentException("Clipboard deve ser vazio.");
        }
        Transferable transferable = this.createTransferable(source);
        if (transferable != null) {
            TransferInfoManager.setTransferInfo(new ClipboardTransferInfo(source, transferable, action));
        }
    }

    @Override
    public Transferable createTransferable(JComponent dragSource) {
        ClientProjectFile[] files = this.getFilesToExport(dragSource);
        if (files == null || files.length == 0) {
            return null;
        }
        return new TransferableNode(files, _flavors);
    }

    @Override
    public boolean importData(JComponent destination, Transferable data) {
        boolean imported = false;
        try {
            if (!this.canImport(destination, _flavors)) {
                return false;
            }
            TransferInfo info = TransferInfoManager.getTransferInfo();
            if (info == null) {
                return false;
            }
            if (TransferInfo.ExportMethod.CLIPBOARD == info.getMethod()) {
                data = ((ClipboardTransferInfo)info).getTransferable();
            }
            if (data == null) {
                return false;
            }
            if (!data.isDataFlavorSupported(_flavors[0])) {
                return false;
            }
            ClientProjectFile destinationDirectory = this.getDestinationDirectory(destination);
            if (destinationDirectory == null || !destinationDirectory.isDirectory()) {
                return false;
            }
            info.setDestinationDirectory(destinationDirectory);
            imported = true;
            if (TransferInfo.ExportMethod.CLIPBOARD == info.getMethod()) {
                this.exportDone(info.getSource(), data, ((ClipboardTransferInfo)info).getAction());
            }
            boolean bl = imported;
            return bl;
        }
        finally {
            if (!imported) {
                TransferInfoManager.clear();
            }
        }
    }

    @Override
    protected void exportDone(JComponent source, Transferable data, int action) {
        ClientProjectFile destinationDirectory;
        int transferAction = this.getSourceActions(source) & action;
        if (transferAction == 0) {
            return;
        }
        TransferInfo info = TransferInfoManager.getTransferInfo();
        if (info == null) {
            return;
        }
        if (TransferInfo.ExportMethod.CLIPBOARD == info.getMethod()) {
            data = ((ClipboardTransferInfo)info).getTransferable();
        }
        if ((destinationDirectory = info.getDestinationDirectory()) == null) {
            return;
        }
        if (data.isDataFlavorSupported(_flavors[0])) {
            try {
                ClientProjectFile[] files = (ClientProjectFile[])data.getTransferData(_flavors[0]);
                if (files == null || files.length == 0) {
                    return;
                }
                switch (transferAction) {
                    case 1: {
                        this.copy(files, destinationDirectory);
                        break;
                    }
                    case 2: {
                        if (this.isMoveValid(files)) {
                            this.move(files, destinationDirectory);
                        }
                        this.clearClipboard();
                    }
                }
            }
            catch (Exception e) {
                this.clearClipboard();
                StandardErrorDialogs.showErrorDialog(this._ownerWindow, this._ownerTitle, LNG.get((String)"AbstractProjectFileTransferHandler.error.export"), e);
            }
        }
    }

    protected abstract ClientProjectFile[] getFilesToExport(JComponent var1);

    protected abstract ClientProjectFile getDestinationDirectory(JComponent var1);

    private boolean isMoveValid(ClientProjectFile[] files) {
        ClientProjectFile[] clientProjectFileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            ClientProjectFile file = clientProjectFileArray[n2];
            if (file == null || file.getParent() == null) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private void copy(final ClientProjectFile[] files, final ClientProjectFile dir) {
        RemoteTask<Void> task = new RemoteTask<Void>(){

            protected void performTask() throws Exception {
                int inx = 0;
                while (inx < files.length) {
                    files[inx].copy(dir);
                    ++inx;
                }
            }
        };
        task.execute(this._ownerWindow, this._ownerTitle, LNG.get((String)"PRJ_WAITING_FILE_COPY"));
    }

    private void move(final ClientProjectFile[] files, final ClientProjectFile dir) {
        RemoteTask<Void> task = new RemoteTask<Void>(){

            protected void performTask() throws Exception {
                int inx = 0;
                while (inx < files.length) {
                    files[inx].move(dir);
                    ++inx;
                }
            }
        };
        task.execute(this._ownerWindow, this._ownerTitle, LNG.get((String)"PRJ_WAITING_FILE_MOVE"));
    }

    static class ClipboardTransferInfo
    extends TransferInfo {
        private final Transferable _transferable;
        private final int _action;

        public ClipboardTransferInfo(JComponent source, Transferable transferable, int action) {
            super(source, TransferInfo.ExportMethod.CLIPBOARD);
            this._transferable = transferable;
            this._action = action;
        }

        public int getAction() {
            return this._action;
        }

        public Transferable getTransferable() {
            return this._transferable;
        }

        @Override
        public void fireOnLoad() {
            if (2 != this.getAction()) {
                return;
            }
            try {
                ClientProjectFile[] files;
                ClientProjectFile[] clientProjectFileArray = files = (ClientProjectFile[])this.getTransferable().getTransferData(_flavors[0]);
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    ClientProjectFile file = clientProjectFileArray[n2];
                    file.setMoving(true);
                    ++n2;
                }
            }
            catch (Exception e) {
                StandardErrorDialogs.showErrorDialog(null, "Clipboard", LNG.get((String)"AbstractProjectFileTransferHandler.error.export"), e);
            }
            this.getSource().repaint();
        }

        @Override
        public void fireOnUnload() {
            if (2 != this.getAction()) {
                return;
            }
            try {
                ClientProjectFile[] files;
                ClientProjectFile[] clientProjectFileArray = files = (ClientProjectFile[])this.getTransferable().getTransferData(_flavors[0]);
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    ClientProjectFile file = clientProjectFileArray[n2];
                    file.setMoving(false);
                    ++n2;
                }
            }
            catch (Exception e) {
                StandardErrorDialogs.showErrorDialog(null, "Clipboard", LNG.get((String)"AbstractProjectFileTransferHandler.error.export"), e);
            }
            this.getSource().repaint();
        }
    }

    static class DragTransferInfo
    extends TransferInfo {
        protected DragTransferInfo(JComponent source) {
            super(source, TransferInfo.ExportMethod.DRAG);
        }
    }

    static class TransferInfo {
        private final JComponent _source;
        private final ExportMethod _method;
        private ClientProjectFile _destinationDirectory;

        protected TransferInfo(JComponent source, ExportMethod method) {
            this._source = source;
            this._method = method;
        }

        public JComponent getSource() {
            return this._source;
        }

        public ExportMethod getMethod() {
            return this._method;
        }

        public ClientProjectFile getDestinationDirectory() {
            return this._destinationDirectory;
        }

        public void setDestinationDirectory(ClientProjectFile destinationDirectory) {
            this._destinationDirectory = destinationDirectory;
        }

        public void fireOnLoad() {
        }

        public void fireOnUnload() {
        }

        public static enum ExportMethod {
            CLIPBOARD,
            DRAG;

        }
    }

    static class TransferInfoManager {
        private static TransferInfo _info;

        static {
            RestartManager.getInstance().addListener(new RestartListener(){

                public void restart() {
                    TransferInfoManager.clear();
                }
            });
        }

        TransferInfoManager() {
        }

        public static synchronized void clear() {
            TransferInfoManager.setTransferInfo(null);
        }

        public static synchronized void setTransferInfo(TransferInfo info) {
            if (_info != null) {
                _info.fireOnUnload();
            }
            _info = info;
            if (info != null) {
                info.fireOnLoad();
            }
        }

        private static void checkAndUnsetFilesMoving() {
            if (_info == null) {
                return;
            }
            if (TransferInfo.ExportMethod.CLIPBOARD != _info.getMethod()) {
                return;
            }
        }

        public static TransferInfo getTransferInfo() {
            return _info;
        }
    }
}

