/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.project;

import csbase.client.desktop.LocalTask;
import csbase.client.util.StandardErrorDialogs;
import java.awt.Window;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import tecgraf.javautils.core.lng.LNG;

public class ExportStringTask
extends LocalTask<Void> {
    private static final String EXPORT_TITLE = "PRJ_PROJECT_FILE_EXPORT_TITLE";
    private static final String ERROR_PREFIX = "cabase.title.error";
    private static final String EXPORT_IO_ERROR = "PRJ_PROJECT_FILE_EXPORT_IO_ERROR";
    private static final int BUFFER_SIZE = 49152;
    private static final String EXPORT_STEP = "PRJ_PROJECT_FILE_EXPORT_STEP";
    private Window window;
    private String content;
    private File rootTargetFile;
    private long totalSize;

    public ExportStringTask(File targetFile, String content, Window win) {
        this.window = win;
        this.content = content;
        this.rootTargetFile = targetFile;
    }

    @Override
    protected void handleError(Exception error) {
        if (error instanceof IOException) {
            String msg = MessageFormat.format(LNG.get((String)EXPORT_IO_ERROR), this.rootTargetFile.getName());
            StandardErrorDialogs.showErrorDialog(this.window, String.valueOf(LNG.get((String)ERROR_PREFIX)) + " - " + LNG.get((String)EXPORT_TITLE), msg);
            return;
        }
        super.handleError(error);
    }

    protected void performTask() throws Exception {
        this.transfer(this.rootTargetFile);
    }

    private void transfer(File targetFile) throws IOException {
        this.totalSize += (long)this.content.length();
        this.transferFile(targetFile);
    }

    private void transferFile(File targetFile) throws IOException {
        String msg = MessageFormat.format(LNG.get((String)EXPORT_STEP), targetFile.getName());
        this.setStepText(msg);
        targetFile.createNewFile();
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(targetFile));
        byte[] buf = this.content.getBytes();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(buf);
        try {
            byte[] buffer = new byte[49152];
            int readBytes = 0;
            while ((readBytes = inputStream.read(buffer)) > 0) {
                out.write(buffer, 0, readBytes);
            }
            out.flush();
        }
        finally {
            out.close();
            inputStream.close();
        }
    }

    public long getTotalSize() {
        return this.totalSize;
    }
}

