/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.project;

import csbase.client.desktop.DesktopComponentDialog;
import csbase.client.desktop.RemoteTask;
import csbase.client.project.AppendDescriptionDialog;
import csbase.client.project.ClientProjectFileProperties;
import csbase.client.util.ClientUtilities;
import csbase.logic.ClientProjectFile;
import csbase.logic.CommonClientProject;
import csbase.logic.ProjectFileType;
import csbase.logic.User;
import csbase.logic.Utilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import tecgraf.javautils.core.lng.FormatUtils;
import tecgraf.javautils.core.lng.LNG;

public class FilePropertiesDialog {
    private DesktopComponentDialog propertiesDialog = null;
    private Window owner = null;
    private JButton closeButton;
    private CommonClientProject project;
    private ClientProjectFile file;
    private JTextArea descriptionArea;
    private String fileName;
    private long fileSize;
    private Object fileOwner;
    private long fileCreationDate;
    private long fileLastUpdateDate;

    public static void show(Window owner, CommonClientProject project, ClientProjectFile file) {
        new FilePropertiesDialog(owner, project, file);
    }

    private DesktopComponentDialog makeDialog() {
        DesktopComponentDialog dialog = new DesktopComponentDialog(this.owner, this.getTitle());
        dialog.setModal(false);
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add(this.makePropertiesPanel(dialog.getBackground()));
        mainPanel.add((Component)this.makeButtonPanel(), "South");
        dialog.getContentPane().add(mainPanel);
        dialog.pack();
        dialog.center(this.owner);
        dialog.getRootPane().setDefaultButton(this.closeButton);
        return dialog;
    }

    private JPanel makePropertiesPanel(Color background) {
        String userName;
        String typeName;
        String description;
        ImageIcon icon = ClientProjectFileProperties.getImageIcon(this.file);
        try {
            description = this.file.getDescription();
        }
        catch (Exception e) {
            e.printStackTrace();
            description = "";
        }
        String accessMode = ClientProjectFileProperties.getAccessMode(this.file);
        try {
            ProjectFileType type = ProjectFileType.getFileType((String)this.file.getType());
            typeName = type.getDescription();
        }
        catch (Exception e) {
            typeName = " ";
        }
        JTextField nameTextField = new JTextField(this.fileName);
        nameTextField.setEditable(false);
        String fileLocalization = this.buildLocalization();
        JTextField pathTextField = new JTextField(fileLocalization);
        pathTextField.setEditable(false);
        JLabel typeLabel = new JLabel(icon, 2);
        JTextArea typeTextArea = new JTextArea(" " + typeName);
        typeTextArea.setBackground(background);
        typeTextArea.setEditable(false);
        JPanel typePanel = new JPanel(new FlowLayout(3, 0, 0));
        typePanel.add(typeLabel);
        typePanel.add(typeTextArea);
        JTextArea readOnlyTextArea = new JTextArea(accessMode);
        readOnlyTextArea.setBackground(background);
        readOnlyTextArea.setEditable(false);
        JTextArea sizeTextArea = new JTextArea(FormatUtils.formatSize((long)this.fileSize, (int)2));
        sizeTextArea.setBackground(background);
        sizeTextArea.setEditable(false);
        String creationDate = " ";
        if (this.fileCreationDate != 0L) {
            creationDate = Utilities.getFormattedDate((long)this.fileCreationDate);
        }
        JTextArea creationDateTextArea = new JTextArea(creationDate);
        creationDateTextArea.setBackground(background);
        creationDateTextArea.setEditable(false);
        String lastUpdateDate = " ";
        if (this.fileLastUpdateDate != 0L) {
            lastUpdateDate = Utilities.getFormattedDate((long)this.fileLastUpdateDate);
        }
        JTextArea lastUpdateDateTextArea = new JTextArea(lastUpdateDate);
        lastUpdateDateTextArea.setBackground(background);
        lastUpdateDateTextArea.setEditable(false);
        try {
            userName = User.getName((Object)this.fileOwner);
            if (userName == null) {
                userName = " ";
            }
        }
        catch (Exception e) {
            userName = " ";
        }
        JTextArea ownerTextArea = new JTextArea(userName);
        ownerTextArea.setBackground(background);
        ownerTextArea.setEditable(false);
        this.descriptionArea = new JTextArea(description);
        this.descriptionArea.setBackground(background);
        this.descriptionArea.setEditable(false);
        this.descriptionArea.setFont(new Font("Monospaced", 0, 12));
        this.descriptionArea.setLineWrap(true);
        this.descriptionArea.setWrapStyleWord(true);
        JScrollPane textScrollPane = new JScrollPane(this.descriptionArea);
        Dimension scrDim = new Dimension(400, 200);
        textScrollPane.setSize(scrDim);
        textScrollPane.setPreferredSize(scrDim);
        textScrollPane.setMinimumSize(scrDim);
        textScrollPane.setBorder(BorderFactory.createTitledBorder(LNG.get((String)"PRJ_FILE_DESCRIPTION")));
        JPanel panel = this.buildPropertiesLayout(nameTextField, pathTextField, typePanel, readOnlyTextArea, sizeTextArea, creationDateTextArea, lastUpdateDateTextArea, ownerTextArea, textScrollPane);
        return panel;
    }

    private JPanel buildPropertiesLayout(JTextField nameTextField, JTextField pathTextField, JPanel typePanel, JTextArea readOnlyTextArea, JTextArea sizeTextArea, JTextArea creationDateTextArea, JTextArea lastUpdateDateTextArea, JTextArea ownerTextArea, JScrollPane textScrollPane) {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(2, 2, 2, 5);
        c.fill = 0;
        c.anchor = 18;
        JLabel nameLabel = new JLabel(LNG.get((String)"PRJ_FILE_NAME"));
        panel.add((Component)nameLabel, c);
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 10.0;
        c.weighty = 0.0;
        c.insets = new Insets(2, 2, 2, 5);
        c.fill = 2;
        c.anchor = 18;
        panel.add((Component)nameTextField, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(2, 2, 2, 5);
        c.fill = 0;
        c.anchor = 18;
        JLabel pathTextLabel = new JLabel(LNG.get((String)"PRJ_FILE_LOCALIZATION"));
        panel.add((Component)pathTextLabel, c);
        c.gridx = 1;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(2, 2, 2, 5);
        c.fill = 2;
        c.anchor = 18;
        panel.add((Component)pathTextField, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(2, 2, 2, 5);
        c.fill = 0;
        c.anchor = 18;
        JLabel typePanelLabel = new JLabel(LNG.get((String)"PRJ_FILE_TYPE"));
        panel.add((Component)typePanelLabel, c);
        c.gridx = 1;
        c.gridy = 2;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(2, 2, 2, 5);
        c.fill = 2;
        c.anchor = 18;
        panel.add((Component)typePanel, c);
        c.gridx = 1;
        c.gridy = 3;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(2, 2, 2, 5);
        c.fill = 2;
        c.anchor = 18;
        panel.add((Component)readOnlyTextArea, c);
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(2, 2, 2, 5);
        c.fill = 0;
        c.anchor = 18;
        JLabel sizeLabel = new JLabel(LNG.get((String)"PRJ_FILE_SIZE"));
        panel.add((Component)sizeLabel, c);
        c.gridx = 1;
        c.gridy = 4;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(2, 2, 2, 5);
        c.fill = 2;
        c.anchor = 18;
        panel.add((Component)sizeTextArea, c);
        c.gridx = 0;
        c.gridy = 5;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(2, 2, 2, 5);
        c.fill = 0;
        c.anchor = 18;
        JLabel creationDateLabel = new JLabel(LNG.get((String)"PRJ_FILE_CREATION_DATE"));
        panel.add((Component)creationDateLabel, c);
        c.gridx = 1;
        c.gridy = 5;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(2, 2, 2, 5);
        c.fill = 2;
        c.anchor = 18;
        panel.add((Component)creationDateTextArea, c);
        c.gridx = 0;
        c.gridy = 6;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(2, 2, 2, 5);
        c.fill = 0;
        c.anchor = 18;
        JLabel lastUpdateDateLabel = new JLabel(LNG.get((String)"PRJ_FILE_LAST_UPDATE_DATE"));
        panel.add((Component)lastUpdateDateLabel, c);
        c.gridx = 1;
        c.gridy = 6;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(2, 2, 2, 5);
        c.fill = 2;
        c.anchor = 18;
        panel.add((Component)lastUpdateDateTextArea, c);
        c.gridx = 0;
        c.gridy = 7;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(2, 2, 2, 5);
        c.fill = 0;
        c.anchor = 18;
        JLabel ownerLabel = new JLabel(LNG.get((String)"PRJ_FILE_AUTHOR"));
        panel.add((Component)ownerLabel, c);
        c.gridx = 1;
        c.gridy = 7;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(2, 2, 2, 5);
        c.fill = 2;
        c.anchor = 18;
        panel.add((Component)ownerTextArea, c);
        c.gridx = 0;
        c.gridy = 8;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(2, 2, 2, 5);
        c.fill = 0;
        c.anchor = 18;
        JLabel sourceLabel = new JLabel(LNG.get((String)"PRJ_FILE_SOURCE"));
        panel.add((Component)sourceLabel, c);
        c.gridx = 0;
        c.gridy = 9;
        c.gridwidth = 2;
        c.gridheight = 8;
        c.weightx = 10.0;
        c.weighty = 10.0;
        c.insets = new Insets(8, 2, 2, 5);
        c.fill = 1;
        c.anchor = 18;
        panel.add((Component)textScrollPane, c);
        return panel;
    }

    private JPanel makeButtonPanel() {
        JPanel panel = new JPanel();
        JButton descriptionButton = new JButton(LNG.get((String)"PRJ_FILE_ADD_DESCRIPTION"));
        panel.add(descriptionButton);
        descriptionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AppendDescriptionDialog appendDialog = new AppendDescriptionDialog(FilePropertiesDialog.this);
                appendDialog.setVisible(true);
            }
        });
        this.closeButton = new JButton(LNG.get((String)"UTIL_CLOSE"));
        panel.add(this.closeButton);
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilePropertiesDialog.this.propertiesDialog.close();
            }
        });
        return panel;
    }

    public JDialog getDialog() {
        return this.propertiesDialog;
    }

    protected String getTitle() {
        String title = MessageFormat.format(LNG.get((String)"project.file_see_properties_title"), this.fileName);
        return ClientUtilities.addSystemNameToTitle(title);
    }

    private void retrieveFileProperties() {
        RemoteTask<Void> task = new RemoteTask<Void>(){

            public void performTask() throws Exception {
                FilePropertiesDialog.this.file.updateInfo();
                FilePropertiesDialog.this.fileName = FilePropertiesDialog.this.file.getName();
                FilePropertiesDialog.this.fileSize = FilePropertiesDialog.this.file.size();
                FilePropertiesDialog.this.fileOwner = FilePropertiesDialog.this.file.whoCreated();
                FilePropertiesDialog.this.fileCreationDate = FilePropertiesDialog.this.file.getCreationDate();
                FilePropertiesDialog.this.fileLastUpdateDate = FilePropertiesDialog.this.file.getModificationDate();
            }
        };
        task.execute(this.owner, this.getTitle(), LNG.get((String)"PRJ_WAITING_OBTAIN_FILE_PROPERTIES"));
    }

    private String buildLocalization() {
        String path = "[" + this.project.getName() + "]" + ": ";
        String[] filePath = this.file.getPath();
        int i = 1;
        while (i < filePath.length - 1) {
            path = String.valueOf(path) + filePath[i] + "/";
            ++i;
        }
        return path;
    }

    private FilePropertiesDialog(Window owner, CommonClientProject project, ClientProjectFile file) {
        this.owner = owner;
        this.project = project;
        this.file = file;
        this.retrieveFileProperties();
        this.propertiesDialog = this.makeDialog();
        this.propertiesDialog.setVisible(true);
    }

    public void updateDescription() {
        String description;
        try {
            description = this.file.getDescription();
        }
        catch (Exception e) {
            e.printStackTrace();
            description = "";
        }
        this.descriptionArea.setText(description);
    }

    public ClientProjectFile getFile() {
        return this.file;
    }
}

