/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.project;

import csbase.client.desktop.RemoteTask;
import csbase.client.externalresources.LocalFile;
import csbase.client.externalresources.StandaloneLocalFile;
import csbase.client.util.StandardErrorDialogs;
import csbase.exception.BugException;
import csbase.exception.project.FileLockedException;
import csbase.logic.ClientProjectFile;
import csbase.logic.CommonClientProject;
import csbase.logic.ProjectFileInfo;
import java.awt.Component;
import java.awt.Window;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.StandardDialogs;

public class ImportTask
extends RemoteTask<Integer> {
    private static final String FILES_SORTING_ERROR = "PRJ_PROJECT_FILE_UPLOAD_FILES_SORTING_ERROR";
    private static final String TITLE = "PRJ_PROJECT_FILE_IMPORT_TITLE";
    private static final String IO_ERROR = "PRJ_PROJECT_FILE_IMPORT_IO_ERROR";
    private static final String IMPORT_STEP = "PRJ_PROJECT_FILE_IMPORT_STEP";
    private static final int BUFFER_SIZE = 0x100000;
    private LocalFile[] sourceFiles;
    private ClientProjectFile targetDir;
    private CommonClientProject project;
    private Window window;
    public long transferStart;
    private long totalSize;
    private ClientProjectFile currentTransferFile;

    public ImportTask(CommonClientProject project, Window window, LocalFile[] sourceFiles, ClientProjectFile targetDir) {
        this.project = project;
        this.window = window;
        this.sourceFiles = sourceFiles;
        this.targetDir = targetDir;
    }

    @Override
    protected void handleError(Exception error) {
        if (error instanceof FileLockedException) {
            StandardDialogs.showErrorDialog((Component)this.window, (String)LNG.get((String)TITLE), (String)String.format(LNG.get((String)"csbase.file.locked.error"), this.currentTransferFile.getName()));
        } else if (error instanceof IOException) {
            this.showError(LNG.get((String)IO_ERROR), error);
        } else {
            super.handleError(error);
        }
    }

    protected void performTask() throws Exception {
        this.createAllFiles();
        ClientProjectFile[] targetFiles = this.getFilesToImport();
        this.transferStart = System.currentTimeMillis();
        int errors = 0;
        int i = 0;
        while (i < targetFiles.length) {
            LocalFile sourceFile = this.sourceFiles[i];
            ClientProjectFile targetFile = targetFiles[i];
            if (targetFile == null) {
                ++errors;
            } else {
                this.currentTransferFile = targetFile;
                this.transferFile(sourceFile, targetFile);
            }
            ++i;
        }
        if (errors > 0) {
            if (errors == targetFiles.length) {
                this.setResult(-1);
            } else {
                this.setResult(errors);
            }
        } else {
            this.setResult(0);
        }
    }

    private void createAllFiles() throws IOException, RemoteException {
        List<ProjectFileInfo> filesInfos = this.getAllFileInfos();
        ArrayList<ProjectFileInfo> filesToCreate = new ArrayList<ProjectFileInfo>();
        for (ProjectFileInfo aFileInfo : filesInfos) {
            if (this.targetDir.getChild(aFileInfo) != null) continue;
            filesToCreate.add(aFileInfo);
        }
        this.project.createAndWaitForFiles(this.targetDir, filesToCreate);
    }

    private ClientProjectFile[] getFilesToImport() throws RemoteException, IOException {
        ClientProjectFile[] files = new ClientProjectFile[this.sourceFiles.length];
        int inx = 0;
        while (inx < files.length) {
            files[inx] = this.targetDir.getChild(this.sourceFiles[inx].getName());
            ++inx;
        }
        return files;
    }

    private void transferFile(LocalFile sourceFile, ClientProjectFile targetFile) throws IOException {
        if (targetFile.isDirectory()) {
            StandaloneLocalFile[] sourceChildren = ((StandaloneLocalFile)sourceFile).listFiles();
            Arrays.sort(sourceChildren, new Comparator<LocalFile>(){

                @Override
                public int compare(LocalFile f1, LocalFile f2) {
                    try {
                        return f1.getName().compareTo(f2.getName());
                    }
                    catch (IOException ex) {
                        ImportTask.this.showError(ImportTask.FILES_SORTING_ERROR, ex);
                        return 0;
                    }
                }
            });
            Object[] targetChildren = targetFile.getChildren();
            Arrays.sort(targetChildren);
            int j = 0;
            while (j < targetChildren.length) {
                StandaloneLocalFile sourceChild = sourceChildren[j];
                Object targetChild = targetChildren[j];
                if (!sourceChild.getName().equals(targetChild.getName())) {
                    throw new BugException(String.format("Importa\u00e7\u00e3o: %s >>> %s", sourceChild.getName(), targetChild.getName()));
                }
                this.transferFile(sourceChild, (ClientProjectFile)targetChild);
                ++j;
            }
        } else {
            this.transferFileContents(sourceFile, targetFile);
        }
    }

    private void transferFileContents(LocalFile sourceFile, ClientProjectFile targetFile) throws IOException {
        String fileName = sourceFile.getName();
        String msg = MessageFormat.format(LNG.get((String)IMPORT_STEP), fileName);
        this.setStepText(msg);
        BufferedInputStream in = new BufferedInputStream(sourceFile.getInputStream());
        targetFile.upload((InputStream)in, 0x100000L, null);
        in.close();
    }

    private List<ProjectFileInfo> getAllFileInfos() throws IOException {
        ArrayList<ProjectFileInfo> fileInfos = new ArrayList<ProjectFileInfo>();
        LocalFile[] localFileArray = this.sourceFiles;
        int n = this.sourceFiles.length;
        int n2 = 0;
        while (n2 < n) {
            LocalFile file = localFileArray[n2];
            ArrayList<String> path = new ArrayList<String>();
            path.add(file.getName());
            this.addAllFileInfos(file, path, fileInfos);
            ++n2;
        }
        return fileInfos;
    }

    private void addAllFileInfos(LocalFile file, List<String> path, List<ProjectFileInfo> fileInfoList) throws IOException {
        ProjectFileInfo fileInfo = new ProjectFileInfo(path.toArray(new String[path.size()]));
        fileInfo.setType("UNKNOWN");
        fileInfo.setSize(file.getLength());
        this.totalSize += fileInfo.getSize();
        fileInfoList.add(fileInfo);
        if (file instanceof StandaloneLocalFile) {
            StandaloneLocalFile STFile = (StandaloneLocalFile)file;
            StandaloneLocalFile[] children = STFile.listFiles();
            if (children == null) {
                return;
            }
            fileInfo.setType("DIRECTORY_TYPE");
            if (children.length > 0) {
                StandaloneLocalFile[] standaloneLocalFileArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    StandaloneLocalFile child = standaloneLocalFileArray[n2];
                    ArrayList<String> childPath = new ArrayList<String>();
                    childPath.addAll(path);
                    childPath.add(child.getName());
                    this.addAllFileInfos(child, childPath, fileInfoList);
                    ++n2;
                }
            }
        }
    }

    private void showError(String msg, Exception ex) {
        StandardErrorDialogs.showErrorDialog(this.window, LNG.get((String)TITLE), msg, ex);
    }

    public long getTransferStart() {
        return this.transferStart;
    }

    public long getTotalSize() {
        return this.totalSize;
    }
}

