/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.project;

import csbase.client.project.ProjectTree;
import csbase.client.project.ProjectTreeAdapter;
import csbase.client.project.ProjectTreeSelectionEvent;
import csbase.client.project.ProjectTreeSelectionListener;
import csbase.logic.ClientProjectFile;
import csbase.logic.CommonClientProject;
import csbase.logic.Utilities;
import java.awt.Font;
import javax.swing.JTextField;

public class ProjectLocationBar
extends JTextField {
    private final ProjectTree projectTree;

    public ProjectLocationBar(ProjectTree projectTree) {
        this.projectTree = projectTree;
        this.addProjectTreeListeners();
        this.setEditable(false);
        Font font = this.getFont();
        int style = font.getStyle();
        int size = font.getSize();
        this.setFont(new Font("Monospaced", style, size));
    }

    private void addProjectTreeListeners() {
        this.projectTree.addProjectTreeListener(new ProjectTreeAdapter(){

            @Override
            public void projectChanged(CommonClientProject proj) {
                String location = "";
                if (proj != null) {
                    location = Utilities.makePath((String[])proj.getRoot().getPath());
                }
                ProjectLocationBar.this.setText(location);
            }
        });
        this.projectTree.addTreeSelectionListener(new ProjectTreeSelectionListener(){

            @Override
            public void update(ProjectTreeSelectionEvent event) {
                ClientProjectFile[] selectedFiles = event.getSelectedFiles();
                int numSelected = selectedFiles.length;
                if (numSelected == 1) {
                    ClientProjectFile selected = selectedFiles[0];
                    String pathText = Utilities.makePath((String[])selected.getPath());
                    ProjectLocationBar.this.setText(pathText);
                } else {
                    String text = "";
                    int maxItens = 3;
                    int n = numSelected < 3 ? numSelected : 3;
                    int i = 0;
                    while (i < n) {
                        ClientProjectFile selected = selectedFiles[i];
                        String pathText = Utilities.makePath((String[])selected.getPath());
                        text = String.valueOf(text) + pathText + ", ";
                        ++i;
                    }
                    if (numSelected > 3) {
                        text = String.valueOf(text) + "...";
                    }
                    ProjectLocationBar.this.setText(text);
                    ProjectLocationBar.this.setCaretPosition(0);
                }
            }
        });
    }
}

