/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.project;

import csbase.client.desktop.DesktopComponentDialog;
import csbase.client.desktop.DesktopFrame;
import csbase.client.desktop.RemoteTask;
import csbase.client.project.ProjectKeyboardFocusManager;
import csbase.client.project.ProjectTableModel;
import csbase.client.project.ProjectTableSortableTable;
import csbase.logic.CommonClientProject;
import csbase.logic.ProjectAdminInfo;
import csbase.logic.User;
import csbase.logic.UserOutline;
import csbase.logic.UserProjectInfo;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.ProjectServiceInterface;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.ButtonGroup;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.RowFilter;
import javax.swing.SortOrder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Document;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.GUIUtils;
import tecgraf.javautils.gui.StandardDialogs;

public class ProjectOpenDialog
extends DesktopComponentDialog {
    protected JButton defaultButton;
    protected CommonClientProject project;
    protected JRadioButton choiceOpenUser;
    protected JRadioButton choiceOpenShared;
    protected JRadioButton choiceOpenAny;
    private JTextField filterText;
    private JButton filterButton;
    private ProjectTableSortableTable projectsTable;
    private ProjectTableModel.RowData selectedProject;
    private List<ProjectTableModel.RowData> sharedProjectsList;
    private List<ProjectTableModel.RowData> currentUserProjectsList;
    private List<ProjectTableModel.RowData> allUsersProjectsList;
    private AbstractAction openAction;
    private AbstractAction cancelAction;
    private AbstractAction refreshROProjAction;
    private ProjectKeyboardFocusManager projectKeyboardFocusManager;

    public ProjectOpenDialog(Window owner) {
        super(owner, LNG.get((String)"ProjectOpenDialog.title.open"));
        this.makeDialog();
        this.setVisible(true);
    }

    private void makeDialog() {
        this.initializeActions();
        JPanel mainPanel = new JPanel(new GridBagLayout());
        this.makeOpenOptionsPanel(mainPanel);
        this.createProjectPanel(mainPanel);
        GBC gbc = new GBC(0, 6).northwest().bottom(5).horizontal();
        mainPanel.add((Component)this.makeButtonPanel(), gbc);
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ProjectOpenDialog.this.close();
            }
        });
        this.projectKeyboardFocusManager = new ProjectKeyboardFocusManager(this, this.projectsTable, this.filterText);
        this.getContentPane().add(mainPanel);
        this.setPreferredSize(new Dimension(450, 400));
        this.pack();
        this.center(this.getOwner());
        JRootPane dialogRootPane = this.getRootPane();
        dialogRootPane.setDefaultButton(this.defaultButton);
        InputMap iMap = dialogRootPane.getInputMap(1);
        ActionMap aMap = dialogRootPane.getActionMap();
        KeyStroke escKeystroke = KeyStroke.getKeyStroke(27, 0);
        String actionMapKey = escKeystroke.toString();
        iMap.put(escKeystroke, actionMapKey);
        aMap.put(actionMapKey, this.cancelAction);
        keyboardFocusManager.addKeyEventDispatcher(this.projectKeyboardFocusManager);
    }

    @Override
    public void close() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this.projectKeyboardFocusManager);
        super.close();
    }

    private void initializeActions() {
        this.openAction = new AbstractAction(LNG.get((String)"ProjectOpenDialog.open")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectOpenDialog.this.handleOpenAction();
            }
        };
        this.cancelAction = new AbstractAction(LNG.get((String)"CommonProjectSelectDialog.cancel")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectOpenDialog.this.close();
            }
        };
        this.refreshROProjAction = new AbstractAction(LNG.get((String)"ProjectOpenDialog.refresh.button")){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ProjectOpenDialog.this.handleRefreshAction();
            }
        };
    }

    protected void makeOpenOptionsPanel(JPanel mainPanel) {
        this.choiceOpenUser = new JRadioButton(LNG.get((String)"ProjectOpenDialog.option.user"));
        this.choiceOpenUser.setEnabled(this.userHasHisOwnProjects());
        GBC gbc = new GBC(0, 0).left(11).west().top(10).none();
        mainPanel.add((Component)this.choiceOpenUser, gbc);
        this.choiceOpenShared = new JRadioButton(LNG.get((String)"ProjectOpenDialog.option.others"));
        this.choiceOpenShared.setEnabled(this.userHasSharedProjects());
        gbc = new GBC(0, 1).left(11).west().none();
        mainPanel.add((Component)this.choiceOpenShared, gbc);
        if (User.getLoggedUser().isAdmin()) {
            this.choiceOpenAny = new JRadioButton(LNG.get((String)"ProjectOpenDialog.option.any"));
            gbc = new GBC(0, 2).left(11).west().none();
            mainPanel.add((Component)this.choiceOpenAny, gbc);
        }
        this.configureRadioButtons();
    }

    private boolean userHasHisOwnProjects() {
        List<ProjectTableModel.RowData> ownProjects = this.getCurrentUserProjectsList(true);
        return ownProjects != null && !ownProjects.isEmpty();
    }

    private boolean userHasSharedProjects() {
        List<ProjectTableModel.RowData> sharedProjects = this.getSharedProjects(true);
        return sharedProjects != null && !sharedProjects.isEmpty();
    }

    private void configureRadioButtons() {
        if (this.userHasHisOwnProjects()) {
            this.choiceOpenUser.setSelected(true);
        } else if (this.userHasSharedProjects()) {
            this.choiceOpenShared.setSelected(true);
        } else if (this.choiceOpenAny != null) {
            this.choiceOpenAny.setSelected(true);
        }
        ButtonGroup mainRadiosGroup = new ButtonGroup();
        this.choiceOpenUser.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    List projectList = ProjectOpenDialog.this.getCurrentUserProjectsList(true);
                    ProjectOpenDialog.this.updateProjectTable(projectList, ProjectTableModel.VisibleColumns.NAME);
                }
            }
        });
        mainRadiosGroup.add(this.choiceOpenUser);
        this.choiceOpenShared.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ProjectOpenDialog.this.updateProjectTable(ProjectOpenDialog.this.getSharedProjects(false), ProjectTableModel.VisibleColumns.OWNER_NAME_PERMISSION);
                }
            }
        });
        mainRadiosGroup.add(this.choiceOpenShared);
        if (this.choiceOpenAny != null) {
            this.choiceOpenAny.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        List projectList = ProjectOpenDialog.this.getAllUsersProjectsList(true);
                        ProjectOpenDialog.this.updateProjectTable(projectList, ProjectTableModel.VisibleColumns.OWNER_NAME);
                    }
                }
            });
            mainRadiosGroup.add(this.choiceOpenAny);
        }
    }

    private void createProjectPanel(JPanel mainPanel) {
        if (this.choiceOpenUser.isSelected()) {
            this.projectsTable = new ProjectTableSortableTable(this.getCurrentUserProjectsList(true), ProjectTableModel.VisibleColumns.NAME);
        } else if (this.choiceOpenShared.isSelected()) {
            this.projectsTable = new ProjectTableSortableTable(this.getSharedProjects(true), ProjectTableModel.VisibleColumns.OWNER_NAME_PERMISSION);
        } else if (this.choiceOpenAny != null && this.choiceOpenAny.isSelected()) {
            this.projectsTable = new ProjectTableSortableTable(this.getAllUsersProjectsList(true), ProjectTableModel.VisibleColumns.OWNER_NAME);
        } else {
            throw new RuntimeException("op\u00e7\u00e3o desconhecida");
        }
        ListSelectionModel listSelectionModel = this.projectsTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ProjectOpenDialog.this.selectedProject = ProjectOpenDialog.this.projectsTable.getSelectedRowData();
            }
        });
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ProjectOpenDialog.this.handleOpenAction();
                }
            }
        };
        this.projectsTable.addMouseListener(mouseListener);
        InputMap im = this.projectsTable.getInputMap(1);
        ActionMap actionMap = this.projectsTable.getActionMap();
        im.put(KeyStroke.getKeyStroke(10, 0), "openProjectActionName");
        actionMap.put("openProjectActionName", this.openAction);
        this.projectsTable.sort(0, SortOrder.ASCENDING);
        this.projectsTable.setSelectedFirstRow();
        JPanel filterPanel = new JPanel(new GridBagLayout());
        JScrollPane scrollPane = new JScrollPane((Component)((Object)this.projectsTable));
        GBC gbc = new GBC(0, 3).insets(10, 15, 10, 15).both();
        mainPanel.add((Component)scrollPane, gbc);
        JPanel refreshPanel = new JPanel(new GridBagLayout());
        gbc = new GBC(0, 0).center().insets(0, 20, 0, 20);
        refreshPanel.add((Component)new JButton(this.refreshROProjAction), gbc);
        gbc = new GBC(0, 4).none();
        mainPanel.add((Component)refreshPanel, gbc);
        gbc = new GBC(0, 0).west().insets(10, 15, 10, 0);
        JLabel filterLabel = new JLabel(LNG.get((String)"ProjectSelectonPanel.filter.label"));
        filterPanel.add((Component)filterLabel, gbc);
        this.filterText = new JTextField();
        gbc = new GBC(1, 0).insets(10).horizontal().filly();
        filterPanel.add((Component)this.filterText, gbc);
        this.filterButton = new JButton(LNG.get((String)"ProjectSelectonPanel.filter.clear"));
        gbc = new GBC(2, 0).east().insets(10, 0, 10, 15);
        filterPanel.add((Component)this.filterButton, gbc);
        gbc = new GBC(0, 5).horizontal().northwest();
        mainPanel.add((Component)filterPanel, gbc);
        this.setupFilterControls();
    }

    private void setupFilterControls() {
        Document document = this.filterText.getDocument();
        document.addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                ProjectOpenDialog.this.filterTableContent();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                ProjectOpenDialog.this.filterTableContent();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ProjectOpenDialog.this.filterTableContent();
            }
        });
        this.filterText.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                ProjectOpenDialog.this.filterText.selectAll();
            }

            @Override
            public void focusLost(FocusEvent e) {
                ProjectOpenDialog.this.filterText.select(0, 0);
            }
        });
        this.filterButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectOpenDialog.this.filterText.setText("");
                ProjectOpenDialog.this.filterTableContent();
            }
        });
    }

    private void filterTableContent() {
        String text = this.filterText.getText();
        if (!text.isEmpty()) {
            this.projectsTable.setRowFilter(RowFilter.regexFilter("(?i).*" + text + ".*", 0, 1));
        } else {
            this.projectsTable.setRowFilter(null);
        }
        this.projectsTable.setSelectedFirstRow();
    }

    public void updateProjectTable(List<ProjectTableModel.RowData> projectList, ProjectTableModel.VisibleColumns visibleColumns) {
        this.projectsTable.setVisibleColumns(visibleColumns);
        this.projectsTable.setNewValues(projectList);
        this.projectsTable.sort(0, SortOrder.ASCENDING);
        this.projectsTable.setSelectedFirstRow();
    }

    private List<ProjectTableModel.RowData> getAllUsersProjectsList(boolean useCache) {
        if (useCache && this.allUsersProjectsList != null) {
            return this.allUsersProjectsList;
        }
        RemoteTask<List<ProjectTableModel.RowData>> task = new RemoteTask<List<ProjectTableModel.RowData>>(){

            protected void performTask() throws Exception {
                ArrayList projectsList = new ArrayList();
                List allUsers = User.getAllOutlines();
                for (UserOutline outline : allUsers) {
                    List projectListTemp = ProjectOpenDialog.this.getAllProjectsByUser(outline);
                    if (projectListTemp == null || projectListTemp.isEmpty()) continue;
                    projectsList.addAll(projectListTemp);
                }
                this.setResult(projectsList);
            }
        };
        if (!task.execute(this.getOwner(), this.getDialogTitle(), LNG.get((String)"OpenAnyProjectDialog.getUsers"))) {
            return null;
        }
        this.allUsersProjectsList = (List)task.getResult();
        return this.allUsersProjectsList;
    }

    private List<ProjectTableModel.RowData> getCurrentUserProjectsList(boolean useCache) {
        if (useCache && this.currentUserProjectsList != null) {
            return this.currentUserProjectsList;
        }
        RemoteTask<List<ProjectTableModel.RowData>> task = new RemoteTask<List<ProjectTableModel.RowData>>(){

            protected void performTask() throws Exception {
                this.setResult(ProjectOpenDialog.this.getAllProjectsByUser(User.getLoggedUser().getOutline()));
            }
        };
        if (!task.execute(this.getOwner(), this.getDialogTitle(), LNG.get((String)"OpenAnyProjectDialog.getUsers"))) {
            return null;
        }
        this.currentUserProjectsList = (List)task.getResult();
        return this.currentUserProjectsList;
    }

    private List<ProjectTableModel.RowData> getAllProjectsByUser(UserOutline outLine) throws RemoteException {
        ArrayList<ProjectTableModel.RowData> projectList = new ArrayList<ProjectTableModel.RowData>();
        UserOutline user = outLine;
        List projNames = CommonClientProject.getAllProjects((Object)user.getId());
        if (projNames != null) {
            int i = 0;
            while (i < projNames.size()) {
                ProjectTableModel.RowData rowData = new ProjectTableModel.RowData(user, (UserProjectInfo)projNames.get(i));
                projectList.add(rowData);
                ++i;
            }
        }
        return projectList;
    }

    private List<ProjectTableModel.RowData> getSharedProjects(boolean useCache) {
        if (useCache && this.sharedProjectsList != null) {
            return this.sharedProjectsList;
        }
        final Object currentUserId = User.getLoggedUser().getId();
        RemoteTask<List<ProjectTableModel.RowData>> task = new RemoteTask<List<ProjectTableModel.RowData>>(){

            protected void performTask() throws Exception {
                ArrayList<ProjectTableModel.RowData> projectList = new ArrayList<ProjectTableModel.RowData>();
                List allUserProjects = CommonClientProject.getAllUserProjectsFromOthers((Object)currentUserId);
                for (UserProjectInfo userProjectInfo : allUserProjects) {
                    Object userId = userProjectInfo.getOwnerId();
                    User user = User.getUser((Object)userId);
                    if (user == null) {
                        System.err.println(String.format("Usu\u00e1rio '%s' n\u00e3o est\u00e1 cadastrado mas possui projetos", userId.toString()));
                        continue;
                    }
                    ProjectTableModel.RowData rowData = new ProjectTableModel.RowData(user.getOutline(), userProjectInfo);
                    projectList.add(rowData);
                }
                this.setResult(projectList);
            }
        };
        String msg = LNG.get((String)"CommonProjectSelectDialog.info.get.projects");
        this.sharedProjectsList = null;
        if (!task.execute(this.getOwner(), this.getDialogTitle(), msg)) {
            return null;
        }
        this.sharedProjectsList = (List)task.getResult();
        return this.sharedProjectsList;
    }

    protected JPanel makeButtonPanel() {
        JPanel panel = new JPanel();
        this.defaultButton = (JButton)panel.add(new JButton(this.openAction));
        JButton cancelButton = (JButton)panel.add(new JButton(this.cancelAction));
        GUIUtils.matchPreferredSizes((JComponent[])new JComponent[]{this.defaultButton, cancelButton});
        return panel;
    }

    protected void handleOpenAction() {
        if (this.selectedProject == null) {
            StandardDialogs.showErrorDialog((Component)this.getOwner(), (String)this.getDialogTitle(), (String)LNG.get((String)"ProjectOpenDialog.error.no.selection"));
            return;
        }
        if (!this.checkOpenableProject(this.selectedProject)) {
            return;
        }
        this.close();
        Object projectId = this.selectedProject.project.getProjectId();
        DesktopFrame desktop = DesktopFrame.getInstance();
        desktop.openProject(projectId);
    }

    protected void handleRefreshAction() {
        if (this.choiceOpenUser.isSelected()) {
            this.updateProjectTable(this.getCurrentUserProjectsList(false), ProjectTableModel.VisibleColumns.NAME);
        } else if (this.choiceOpenShared.isSelected()) {
            this.updateProjectTable(this.getSharedProjects(false), ProjectTableModel.VisibleColumns.OWNER_NAME_PERMISSION);
        } else if (this.choiceOpenAny.isSelected()) {
            this.updateProjectTable(this.getAllUsersProjectsList(false), ProjectTableModel.VisibleColumns.OWNER_NAME);
        }
        this.projectsTable.setSelectedFirstRow();
    }

    private boolean checkOpenableProject(final ProjectTableModel.RowData selectedRowData) {
        RemoteTask<Boolean> task = new RemoteTask<Boolean>(){

            protected void performTask() {
                try {
                    ProjectServiceInterface psi = ClientRemoteLocator.projectService;
                    Object projectId = selectedRowData.project.getProjectId();
                    ProjectAdminInfo projectAdminInfo = psi.getProjectAdminInfo(projectId);
                    if (projectAdminInfo == null) {
                        this.setResult(true);
                    } else {
                        this.setResult(projectAdminInfo.isUnlockedWithAreaAllocated());
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        };
        DesktopFrame desktopFrame = DesktopFrame.getInstance();
        JFrame frame = desktopFrame.getView();
        task.execute(frame, LNG.get((String)"CommonProjectSelectDialog.checking.project.blocked.title"), LNG.get((String)"CommonProjectSelectDialog.checking.project.blocked.msg"));
        if (task.wasCancelled()) {
            StandardDialogs.showErrorDialog((Component)desktopFrame.getView(), (String)LNG.get((String)"CommonProjectSelectDialog.cancelled.task.title"), (String)LNG.get((String)"CommonProjectSelectDialog.cancelled.task.msg"));
            return false;
        }
        if (!task.getStatus()) {
            StandardDialogs.showErrorDialog((Component)desktopFrame.getView(), (String)LNG.get((String)"CommonProjectSelectDialog.locked.project.failure.title"), (String)LNG.get((String)"CommonProjectSelectDialog.locked.project.failure.msg"));
            return false;
        }
        boolean openable = (Boolean)task.getResult();
        if (!openable) {
            StandardDialogs.showErrorDialog((Component)desktopFrame.getView(), (String)LNG.get((String)"CommonProjectSelectDialog.locked.project.title"), (String)LNG.get((String)"CommonProjectSelectDialog.locked.project.msg"));
        }
        return openable;
    }

    public String getDialogTitle() {
        return LNG.get((String)"ProjectOpenDialog.title.open");
    }
}

