/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.project;

import csbase.client.project.ProjectTreeNode;
import csbase.client.project.ProjectTreeNodeNameComparator;
import csbase.client.project.ProjectTreeStructureListener;
import csbase.logic.ClientProjectFile;
import csbase.logic.CommonClientProject;
import csbase.logic.DirRefreshedEvent;
import csbase.logic.NewProjectFileEvent;
import csbase.logic.NewProjectFilesEvent;
import csbase.logic.ProjectDeletedEvent;
import csbase.logic.ProjectEvent;
import csbase.logic.ProjectFileDeletedEvent;
import csbase.logic.ProjectFileFilter;
import csbase.logic.ProjectFileRenamedEvent;
import csbase.logic.ProjectFileStateChangedEvent;
import csbase.logic.ProjectFilesDeletedEvent;
import csbase.logic.ProjectInfoModifiedEvent;
import csbase.logic.TreeChangedEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import tecgraf.javautils.gui.SwingThreadDispatcher;

public final class ProjectTreeModel
implements TreeModel {
    private ProjectTreeNode rootNode;
    private Set<TreeModelListener> listenerSet = new HashSet<TreeModelListener>();
    private Set<ProjectTreeStructureListener> listenerChangesSet = new HashSet<ProjectTreeStructureListener>();
    private CommonClientProject clientProject;
    private ProjectObserver projectObserver = new ProjectObserver();
    private ProjectFileFilter filter;
    private Comparator<ProjectTreeNode> comparator;

    public ProjectTreeModel(CommonClientProject clientProject) {
        this(clientProject, null, ProjectTreeNodeNameComparator.getInstance());
    }

    public ProjectTreeModel(CommonClientProject clientProject, Comparator<ProjectTreeNode> comparator) {
        this(clientProject, null, comparator);
    }

    public ProjectTreeModel(CommonClientProject clientProject, ProjectFileFilter filter) {
        this(clientProject, filter, ProjectTreeNodeNameComparator.getInstance());
    }

    public ProjectTreeModel(CommonClientProject clientProject, ProjectFileFilter filter, Comparator<ProjectTreeNode> comparator) {
        this.filter = filter;
        this.comparator = comparator;
        this.setProject(clientProject);
    }

    void setProject(CommonClientProject clientProject) {
        if (this.rootNode != null) {
            this.fireTreeWillChange(this.rootNode.getTreePath());
        }
        if (clientProject != null) {
            this.rootNode = new ProjectTreeNode(clientProject, this.filter, this.comparator);
            clientProject.addObserver((Observer)this.projectObserver);
        } else {
            this.rootNode = null;
        }
        if (this.clientProject != null) {
            this.clientProject.deleteObserver((Observer)this.projectObserver);
        }
        this.clientProject = clientProject;
        if (this.rootNode != null) {
            this.fireTreeStructureChanged(this.rootNode.getTreePath());
        } else {
            this.fireTreeStructureChanged(null);
        }
    }

    public final CommonClientProject getProject() {
        return this.clientProject;
    }

    void setComparator(Comparator<ProjectTreeNode> comparator) {
        if (this.rootNode != null) {
            this.fireTreeWillChange(this.rootNode.getTreePath());
        }
        this.comparator = comparator;
        if (this.rootNode != null) {
            this.rootNode.setComparator(comparator);
            this.fireTreeStructureChanged(this.rootNode.getTreePath());
        }
    }

    public void addTreeWillChangeStructureListener(ProjectTreeStructureListener l) {
        this.listenerChangesSet.add(l);
    }

    public void removeTreeWillChangeStructureListener(ProjectTreeStructureListener l) {
        this.listenerChangesSet.remove(l);
    }

    void fireTreeStructureChanged(TreePath subTreeRoot) {
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, subTreeRoot);
        for (TreeModelListener treeModelListener : this.listenerSet) {
            treeModelListener.treeStructureChanged(treeModelEvent);
        }
        this.fireTreeWasChanged(subTreeRoot);
    }

    void fireTreeWillChange(TreePath subTreeRoot) {
        TreeModelEvent event = new TreeModelEvent((Object)this, subTreeRoot);
        for (ProjectTreeStructureListener listener : this.listenerChangesSet) {
            listener.treeWillChange(event);
        }
    }

    private void fireTreeWasChanged(TreePath subTreeRoot) {
        TreeModelEvent event = new TreeModelEvent((Object)this, subTreeRoot);
        for (ProjectTreeStructureListener listener : this.listenerChangesSet) {
            listener.treeWasChanged(event);
        }
    }

    private void fireTreeNodesInserted(TreePath parentTreePath, int[] insertedIndexes, ProjectTreeNode[] insertedNodes) {
        this.sort(insertedIndexes, insertedNodes);
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, parentTreePath, insertedIndexes, (Object[])insertedNodes);
        for (TreeModelListener treeModelListener : this.listenerSet) {
            try {
                treeModelListener.treeNodesInserted(treeModelEvent);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    private void fireTreeNodesRemoved(TreePath parentTreePath, int[] removedIndexes, ProjectTreeNode[] removedNodes) {
        this.sort(removedIndexes, removedNodes);
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, parentTreePath, removedIndexes, (Object[])removedNodes);
        for (TreeModelListener treeModelListener : this.listenerSet) {
            try {
                treeModelListener.treeNodesRemoved(treeModelEvent);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    private void fireTreeNodesChanged(TreePath parentTreePath, int[] changedIndexes, ProjectTreeNode[] changedNodes) {
        this.sort(changedIndexes, changedNodes);
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, parentTreePath, changedIndexes, (Object[])changedNodes);
        for (TreeModelListener treeModelListener : this.listenerSet) {
            try {
                treeModelListener.treeNodesChanged(treeModelEvent);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    @Override
    public Object getRoot() {
        return this.rootNode;
    }

    @Override
    public int getChildCount(Object parent) {
        ProjectTreeNode projectTreeNode = (ProjectTreeNode)parent;
        return projectTreeNode.getChildCount();
    }

    @Override
    public boolean isLeaf(Object node) {
        ProjectTreeNode projectTreeNode = (ProjectTreeNode)node;
        return projectTreeNode.isLeaf();
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listenerSet.add(l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listenerSet.remove(l);
    }

    @Override
    public Object getChild(Object parent, int index) {
        ProjectTreeNode projectTreeNode = (ProjectTreeNode)parent;
        return projectTreeNode.getChildAt(index);
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        ProjectTreeNode projectTreeNode = (ProjectTreeNode)parent;
        return projectTreeNode.getIndex((ProjectTreeNode)child);
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    public TreePath getTreePath(ClientProjectFile file) {
        ProjectTreeNode node;
        String[] path = file.getPath();
        Object[] pathToRootArray = new ProjectTreeNode[path.length + 1];
        pathToRootArray[0] = node = this.rootNode;
        int i = 0;
        while (i < path.length) {
            if ((node = node.getChild(path[i])) == null) {
                return null;
            }
            pathToRootArray[i + 1] = node;
            ++i;
        }
        return new TreePath(pathToRootArray);
    }

    public boolean exists(TreePath path) {
        if (this.rootNode == null) {
            return false;
        }
        Object[] pathComponents = path.getPath();
        ProjectTreeNode cursor = this.rootNode;
        int i = 0;
        while (i < pathComponents.length) {
            ProjectTreeNode target = (ProjectTreeNode)pathComponents[i];
            if (!target.equals(cursor)) {
                return false;
            }
            cursor = cursor.getChild(target.getName());
            ++i;
        }
        return true;
    }

    private void handleEvent(ProjectInfoModifiedEvent event) {
    }

    private void handleEvent(ProjectDeletedEvent event) {
        Runnable handler = new Runnable(){

            @Override
            public void run() {
                ProjectTreeModel.this.setProject(null);
            }
        };
        if (SwingThreadDispatcher.isEventDispatchThread()) {
            handler.run();
        } else {
            SwingThreadDispatcher.invokeLater((Runnable)handler);
        }
    }

    private void handleEvent(NewProjectFileEvent event) {
        final ClientProjectFile insertedFile = event.getFile();
        Runnable handler = new Runnable(){

            @Override
            public void run() {
                ProjectTreeModel.this.addNewNode(insertedFile);
            }
        };
        if (SwingThreadDispatcher.isEventDispatchThread()) {
            handler.run();
        } else {
            SwingThreadDispatcher.invokeLater((Runnable)handler);
        }
    }

    private void handleEvent(NewProjectFilesEvent event) {
        final ClientProjectFile[] files = event.getFiles();
        if (files == null) {
            throw new IllegalArgumentException("files == null");
        }
        Runnable handler = new Runnable(){

            @Override
            public void run() {
                int inx = 0;
                while (inx < files.length) {
                    ProjectTreeModel.this.addNewNode(files[inx]);
                    ++inx;
                }
            }
        };
        if (SwingThreadDispatcher.isEventDispatchThread()) {
            handler.run();
        } else {
            SwingThreadDispatcher.invokeLater((Runnable)handler);
        }
    }

    private void addNewNode(ClientProjectFile file) {
        TreePath parentTreePath = this.getTreePath(file.getParent());
        if (parentTreePath == null) {
            return;
        }
        ProjectTreeNode parentTreeNode = (ProjectTreeNode)parentTreePath.getLastPathComponent();
        boolean wasLeaf = parentTreeNode.isLeaf();
        if (!parentTreeNode.addChild(file)) {
            return;
        }
        if (wasLeaf) {
            ClientProjectFile grandDir = file.getParent().getParent();
            if (grandDir == null) {
                grandDir = file.getParent();
            }
            TreePath grandTreePath = this.getTreePath(grandDir);
            this.fireTreeWillChange(grandTreePath);
            this.fireTreeStructureChanged(grandTreePath);
        } else {
            ProjectTreeNode treeNode = parentTreeNode.getChild(file);
            ProjectTreeNode[] insertedNodes = new ProjectTreeNode[]{treeNode};
            int[] insertedIndexes = parentTreeNode.getIndexes(insertedNodes);
            this.fireTreeNodesInserted(parentTreePath, insertedIndexes, insertedNodes);
        }
    }

    private void handleEvent(ProjectFileDeletedEvent event) {
        final ClientProjectFile removedFile = event.getRemovedFile();
        final TreePath parentTreePath = this.getTreePath(removedFile.getParent());
        if (parentTreePath == null) {
            return;
        }
        final ProjectTreeNode parentTreeNode = (ProjectTreeNode)parentTreePath.getLastPathComponent();
        final TreePath fileTreePath = this.getTreePath(removedFile);
        if (fileTreePath == null) {
            return;
        }
        Runnable handler = new Runnable(){

            @Override
            public void run() {
                ProjectTreeNode fileTreeNode = (ProjectTreeNode)fileTreePath.getLastPathComponent();
                ProjectTreeNode[] removedNodes = new ProjectTreeNode[]{fileTreeNode};
                int[] removedIndexes = parentTreeNode.getIndexes(removedNodes);
                if (!parentTreeNode.removeChild(removedFile)) {
                    return;
                }
                ProjectTreeModel.this.fireTreeNodesRemoved(parentTreePath, removedIndexes, removedNodes);
            }
        };
        if (SwingThreadDispatcher.isEventDispatchThread()) {
            handler.run();
        } else {
            SwingThreadDispatcher.invokeLater((Runnable)handler);
        }
    }

    private void handleEvent(ProjectFilesDeletedEvent event) {
        ClientProjectFile[] removedFiles = event.getRemovedFiles();
        final HashMap<TreePath, ArrayList<TreePath>> parent2Children = new HashMap<TreePath, ArrayList<TreePath>>();
        ClientProjectFile[] clientProjectFileArray = removedFiles;
        int n = removedFiles.length;
        int n2 = 0;
        while (n2 < n) {
            TreePath fileTreePath;
            ClientProjectFile file = clientProjectFileArray[n2];
            TreePath parentTreePath = this.getTreePath(file.getParent());
            if (parentTreePath != null && (fileTreePath = this.getTreePath(file)) != null) {
                ArrayList<TreePath> list = (ArrayList<TreePath>)parent2Children.get(parentTreePath);
                if (list == null) {
                    list = new ArrayList<TreePath>();
                    parent2Children.put(parentTreePath, list);
                }
                list.add(fileTreePath);
            }
            ++n2;
        }
        if (parent2Children.size() == 0) {
            return;
        }
        Runnable handler = new Runnable(){

            @Override
            public void run() {
                for (TreePath parent : parent2Children.keySet()) {
                    List children = (List)parent2Children.get(parent);
                    ProjectTreeNode[] nodes = new ProjectTreeNode[children.size()];
                    int i = 0;
                    while (i < nodes.length) {
                        nodes[i] = (ProjectTreeNode)((TreePath)children.get(i)).getLastPathComponent();
                        ++i;
                    }
                    ProjectTreeNode parentNode = (ProjectTreeNode)parent.getLastPathComponent();
                    int[] removedIndexes = parentNode.getIndexes(nodes);
                    int i2 = 0;
                    while (i2 < nodes.length) {
                        parentNode.removeChild(nodes[i2].getClientProjectFile());
                        ++i2;
                    }
                    ProjectTreeModel.this.fireTreeNodesRemoved(parent, removedIndexes, nodes);
                }
            }
        };
        if (SwingThreadDispatcher.isEventDispatchThread()) {
            handler.run();
        } else {
            SwingThreadDispatcher.invokeLater((Runnable)handler);
        }
    }

    private void handleEvent(ProjectFileRenamedEvent event) {
        this.updateFile(event.getFile());
    }

    private void handleEvent(ProjectFileStateChangedEvent event) {
        this.updateFile(event.getFile());
    }

    private void handleEvent(DirRefreshedEvent event) {
        this.updateFile(event.getDir());
    }

    private void updateFile(final ClientProjectFile changedFile) {
        final TreePath parentTreePath = this.getTreePath(changedFile.getParent());
        if (parentTreePath == null) {
            return;
        }
        final TreePath treePath = this.getTreePath(changedFile);
        if (treePath == null) {
            return;
        }
        Runnable handler = new Runnable(){

            @Override
            public void run() {
                ProjectTreeModel.this.fireTreeWillChange(treePath);
                ProjectTreeNode treeNode = (ProjectTreeNode)treePath.getLastPathComponent();
                treeNode.setClientProjectFile(changedFile);
                ProjectTreeModel.this.fireTreeStructureChanged(parentTreePath);
            }
        };
        if (SwingThreadDispatcher.isEventDispatchThread()) {
            handler.run();
        } else {
            SwingThreadDispatcher.invokeLater((Runnable)handler);
        }
    }

    private void handleEvent(final TreeChangedEvent event) {
        if (this.rootNode == null) {
            return;
        }
        Runnable handler = new Runnable(){

            @Override
            public void run() {
                ProjectTreeModel.this.fireTreeWillChange(ProjectTreeModel.this.rootNode.getTreePath());
                ProjectTreeModel.this.rootNode.setClientProjectFile(event.getNewTree());
                ProjectTreeModel.this.fireTreeStructureChanged(ProjectTreeModel.this.rootNode.getTreePath());
            }
        };
        if (SwingThreadDispatcher.isEventDispatchThread()) {
            handler.run();
        } else {
            SwingThreadDispatcher.invokeLater((Runnable)handler);
        }
    }

    private void sort(int[] indexes, ProjectTreeNode[] nodes) {
        if (indexes.length != nodes.length) {
            throw new IllegalArgumentException("Os arrays n\u00e3o podem ter tamanhos diferentes.");
        }
        int i = 0;
        while (i < indexes.length - 1) {
            int j = i + 1;
            while (j < indexes.length) {
                if (indexes[i] > indexes[j]) {
                    int auxInt = indexes[i];
                    indexes[i] = indexes[j];
                    indexes[j] = auxInt;
                    ProjectTreeNode auxNode = nodes[i];
                    nodes[i] = nodes[j];
                    nodes[j] = auxNode;
                }
                ++j;
            }
            ++i;
        }
    }

    ProjectFileFilter getFilter() {
        return this.filter;
    }

    void setFilter(ProjectFileFilter filter) {
        if (this.rootNode != null) {
            this.fireTreeWillChange(this.rootNode.getTreePath());
        }
        this.filter = filter;
        if (this.rootNode != null) {
            this.rootNode.setFilter(filter);
            this.fireTreeStructureChanged(this.rootNode.getTreePath());
        }
    }

    private class ProjectObserver
    implements Observer {
        private ProjectObserver() {
        }

        @Override
        public void update(Observable o, Object arg) {
            final ProjectEvent event = (ProjectEvent)arg;
            Runnable code = new Runnable(){

                @Override
                public void run() {
                    try {
                        switch (event.event) {
                            case 1: {
                                ProjectTreeModel.this.handleEvent((ProjectInfoModifiedEvent)event);
                                break;
                            }
                            case 2: {
                                ProjectTreeModel.this.handleEvent((ProjectDeletedEvent)event);
                                break;
                            }
                            case 3: {
                                ProjectTreeModel.this.handleEvent((NewProjectFileEvent)event);
                                break;
                            }
                            case 11: {
                                ProjectTreeModel.this.handleEvent((NewProjectFilesEvent)event);
                                break;
                            }
                            case 4: {
                                ProjectTreeModel.this.handleEvent((ProjectFileDeletedEvent)event);
                                break;
                            }
                            case 10: {
                                ProjectTreeModel.this.handleEvent((ProjectFilesDeletedEvent)event);
                                break;
                            }
                            case 5: {
                                ProjectTreeModel.this.handleEvent((ProjectFileRenamedEvent)event);
                                break;
                            }
                            case 7: {
                                ProjectTreeModel.this.handleEvent((ProjectFileStateChangedEvent)event);
                                break;
                            }
                            case 12: {
                                ProjectTreeModel.this.handleEvent((DirRefreshedEvent)event);
                                break;
                            }
                            case 8: {
                                ProjectTreeModel.this.handleEvent((TreeChangedEvent)event);
                                break;
                            }
                            default: {
                                throw new IllegalStateException("Evento desconhecido. N\u00famero: " + event.event + " - Classe: " + event.getClass());
                            }
                        }
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            };
            if (SwingThreadDispatcher.isEventDispatchThread()) {
                code.run();
            } else {
                SwingThreadDispatcher.invokeLater((Runnable)code);
            }
        }
    }
}

