/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.project;

import csbase.client.desktop.DesktopFrame;
import csbase.client.project.tasks.GetChildrenTask;
import csbase.logic.ClientProjectFile;
import csbase.logic.CommonClientProject;
import csbase.logic.NoHiddenFileFilter;
import csbase.logic.ProjectFileFilter;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public final class ProjectTreeNode
implements TreeNode {
    private ProjectTreeNode parent;
    private ClientProjectFile file;
    private List<ProjectTreeNode> childList;
    private boolean hasAllTree;
    private ProjectFileFilter filter;
    private Comparator<ProjectTreeNode> comparator;

    ProjectTreeNode(CommonClientProject project, ProjectFileFilter filter, Comparator<ProjectTreeNode> comparator) {
        this(null, project.getRoot(), false, filter, comparator);
    }

    private ProjectTreeNode(ProjectTreeNode parent, ClientProjectFile file, boolean hasAllTree, ProjectFileFilter filter, Comparator<ProjectTreeNode> comparator) {
        this.parent = parent;
        this.file = file;
        this.childList = null;
        this.hasAllTree = hasAllTree;
        this.filter = filter;
        this.comparator = comparator;
    }

    void loadChildren(boolean force) {
        ClientProjectFile[] children;
        if (force) {
            this.childList = null;
            this.hasAllTree = false;
        }
        if (this.childList != null || !this.file.isDirectory()) {
            return;
        }
        if (!this.hasAllTree) {
            boolean bringAllTree = this.filter != null || force;
            children = GetChildrenTask.runTask(this.file, bringAllTree, bringAllTree);
            this.hasAllTree = bringAllTree;
        } else {
            children = this.file.getLocalChildren();
        }
        this.setChildren(children);
    }

    private void setChildren(ClientProjectFile[] children) {
        this.childList = new LinkedList<ProjectTreeNode>();
        if (children == null) {
            return;
        }
        NoHiddenFileFilter noDotFileFilter = NoHiddenFileFilter.getInstance();
        boolean showHiddenFiles = DesktopFrame.getInstance().shouldShowHiddenFiles();
        int i = 0;
        while (i < children.length) {
            if ((showHiddenFiles || noDotFileFilter.accept(children[i])) && (this.filter == null || this.filter.accept(children[i]))) {
                ProjectTreeNode treeNode = new ProjectTreeNode(this, children[i], this.hasAllTree, this.filter, this.comparator);
                this.childList.add(treeNode);
            }
            ++i;
        }
        Collections.sort(this.childList, this.comparator);
    }

    public ClientProjectFile getClientProjectFile() {
        return this.file;
    }

    public Enumeration<ProjectTreeNode> children() {
        this.loadChildren(false);
        return new ChildEnumeration();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        ProjectTreeNode node = (ProjectTreeNode)obj;
        return this.file.equals((Object)node.file);
    }

    @Override
    public boolean getAllowsChildren() {
        return this.file.isDirectory();
    }

    ProjectTreeNode getChild(ClientProjectFile child) {
        if (!this.getAllowsChildren()) {
            return null;
        }
        this.loadChildren(false);
        for (ProjectTreeNode node : this.childList) {
            if (!node.file.equals((Object)child)) continue;
            return node;
        }
        return null;
    }

    ProjectTreeNode getChild(String fileName) {
        if (!this.getAllowsChildren()) {
            return null;
        }
        this.loadChildren(false);
        for (ProjectTreeNode node : this.childList) {
            if (!node.file.getName().equals(fileName)) continue;
            return node;
        }
        return null;
    }

    String getName() {
        return this.file.getName();
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        if (!this.getAllowsChildren()) {
            return null;
        }
        this.loadChildren(false);
        return this.childList.get(childIndex);
    }

    @Override
    public int getChildCount() {
        if (!this.getAllowsChildren()) {
            return 0;
        }
        this.loadChildren(false);
        return this.childList.size();
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    @Override
    public int getIndex(TreeNode node) {
        if (!this.getAllowsChildren()) {
            return -1;
        }
        this.loadChildren(false);
        return this.childList.indexOf(node);
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    @Override
    public boolean isLeaf() {
        return !this.file.isDirectory() || !this.file.hasChildren();
    }

    public String toString() {
        return this.file.toString();
    }

    ProjectFileFilter getFilter() {
        return this.filter;
    }

    int[] getIndexes(ProjectTreeNode[] treeNodeArray) {
        int[] indexes = new int[treeNodeArray.length];
        int i = 0;
        while (i < indexes.length) {
            indexes[i] = this.getIndex(treeNodeArray[i]);
            ++i;
        }
        return indexes;
    }

    TreePath getTreePath() {
        ProjectTreeNode node = this;
        ArrayDeque<ProjectTreeNode> pathToRoot = new ArrayDeque<ProjectTreeNode>();
        do {
            pathToRoot.addFirst(node);
        } while ((node = (ProjectTreeNode)node.getParent()) != null);
        return new TreePath(pathToRoot.toArray(new ProjectTreeNode[pathToRoot.size()]));
    }

    public void setClientProjectFile(ClientProjectFile file) {
        this.file = file;
        this.childList = null;
        this.hasAllTree = false;
        if (this.parent != null) {
            Collections.sort(this.parent.childList, this.comparator);
        }
    }

    public boolean addChild(ClientProjectFile child) {
        boolean showHiddenFiles = DesktopFrame.getInstance().shouldShowHiddenFiles();
        NoHiddenFileFilter noDotFileFilter = NoHiddenFileFilter.getInstance();
        if (!showHiddenFiles && !noDotFileFilter.accept(child)) {
            return false;
        }
        if (this.filter == null || this.filter.accept(child)) {
            if (this.childList == null) {
                this.childList = new LinkedList<ProjectTreeNode>();
            }
            this.childList.add(new ProjectTreeNode(this, child, this.hasAllTree, this.filter, this.comparator));
            Collections.sort(this.childList, this.comparator);
            this.file.setHasChildren(true);
            return true;
        }
        return false;
    }

    public boolean removeChild(ClientProjectFile child) {
        ProjectTreeNode treeNode = this.getChild(child);
        if (treeNode != null && this.childList.remove(treeNode)) {
            Collections.sort(this.childList, this.comparator);
            this.file.setHasChildren(!this.childList.isEmpty());
            return true;
        }
        return false;
    }

    void setFilter(ProjectFileFilter filter) {
        this.filter = filter;
        if (!this.getAllowsChildren()) {
            return;
        }
        this.childList = null;
    }

    void setComparator(Comparator<ProjectTreeNode> comparator) {
        this.comparator = comparator;
        if (!this.getAllowsChildren()) {
            return;
        }
        this.loadChildren(false);
        Collections.sort(this.childList, this.comparator);
        for (ProjectTreeNode child : this.childList) {
            child.setComparator(comparator);
        }
    }

    private final class ChildEnumeration
    implements Enumeration<ProjectTreeNode> {
        private Iterator<ProjectTreeNode> iterator;

        ChildEnumeration() {
            this.iterator = ProjectTreeNode.this.childList.iterator();
        }

        @Override
        public boolean hasMoreElements() {
            return this.iterator.hasNext();
        }

        @Override
        public ProjectTreeNode nextElement() {
            return this.iterator.next();
        }
    }
}

