/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.project.action;

import csbase.client.externalresources.ExternalResources;
import csbase.client.externalresources.LocalFile;
import csbase.client.externalresources.StandaloneLocalFile;
import csbase.client.project.ImportTask;
import csbase.client.project.ProjectFileContainer;
import csbase.client.project.action.CommonProjectAction;
import csbase.client.remote.srvproxies.NotificationProxy;
import csbase.client.util.ClientUtilities;
import csbase.client.util.StandardErrorDialogs;
import csbase.exception.CSBaseException;
import csbase.logic.ClientProjectFile;
import csbase.logic.User;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.security.AccessControlException;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.JFileChooser;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.StandardDialogs;

public class CommonFileImportAction
extends CommonProjectAction {
    private static final String CRITICAL_ERROR = "PRJ_PROJECT_FILE_IMPORT_CRITICAL_ERROR";
    private static final String NAME_CHARACTER_ERROR = "UTIL_NAME_CHARACTER_ERROR";
    private static final String FILE_EXISTS = "PRJ_PROJECT_FILE_IMPORT_FILE_EXISTS";
    private static final String FILE_NOT_FOUND = "PRJ_PROJECT_FILE_IMPORT_FILE_NOT_FOUND";
    private static final String IO_ERROR = "PRJ_PROJECT_FILE_IMPORT_IO_ERROR";
    private static final String IMPORT_IN_PROGRESS_MSG = "PRJ_PROJECT_FILE_IMPORT_IN_PROGRESS";
    private static final String SUCCESS_ALL = "PRJ_PROJECT_FILE_IMPORT_SUCCESS_ALL";
    private static final String SUCCESS_PARTIAL = "PRJ_PROJECT_FILE_IMPORT_SUCCESS_PARTIAL";
    private static final String SUCCESS_NONE = "PRJ_PROJECT_FILE_IMPORT_SUCCESS_NONE";
    private static final String TITLE = "PRJ_PROJECT_FILE_IMPORT_TITLE";
    private static final String RESTRICTED_IMPORT_WARNING = "PRJ_PROJECT_FILE_IMPORT_RESTRICTED_WARNING";
    private ClientProjectFile targetDir;
    private boolean isDynamicTarget;
    private ClientProjectFile fixedTargetDir;
    public long fileCreationStart;
    private int chooserSelectionMode;

    public CommonFileImportAction(ProjectFileContainer container) {
        super(container);
        this.isDynamicTarget = true;
        this.chooserSelectionMode = 2;
    }

    public CommonFileImportAction(ProjectFileContainer container, ClientProjectFile targetDir) {
        super(container);
        this.isDynamicTarget = false;
        this.fixedTargetDir = targetDir;
        this.chooserSelectionMode = 2;
    }

    public final void setFileChooserSelectionMode(int chooserSelectionMode) {
        this.chooserSelectionMode = chooserSelectionMode;
    }

    public final int getFileChooserSelectionMode() {
        return this.chooserSelectionMode;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.targetDir = this.isDynamicTarget ? this.getSelectedFile() : this.fixedTargetDir;
        try {
            LocalFile[] sourceFiles = null;
            try {
                JFileChooser chooser = this.getFileChooser();
                chooser.setMultiSelectionEnabled(true);
                chooser.setFileSelectionMode(this.chooserSelectionMode);
                int returnVal = chooser.showOpenDialog(this.getWindow());
                if (returnVal == 1) {
                    return;
                }
                File[] selectedFiles = chooser.getSelectedFiles();
                if (selectedFiles == null || selectedFiles.length == 0) {
                    return;
                }
                sourceFiles = new LocalFile[selectedFiles.length];
                int i = 0;
                while (i < selectedFiles.length) {
                    sourceFiles[i] = new StandaloneLocalFile(selectedFiles[i]);
                    ++i;
                }
            }
            catch (AccessControlException ex1) {
                if (!ExternalResources.getInstance().isEnabled()) {
                    this.showError(LNG.get((String)CRITICAL_ERROR));
                }
                try {
                    this.showWarning(LNG.get((String)RESTRICTED_IMPORT_WARNING));
                    sourceFiles = ExternalResources.getInstance().openMultiFileDialog(".", null);
                    if (sourceFiles == null || sourceFiles.length == 0) {
                        return;
                    }
                }
                catch (CSBaseException ex2) {
                    this.showError(LNG.get((String)CRITICAL_ERROR), (Exception)((Object)ex2));
                    return;
                }
            }
            this.fileCreationStart = System.currentTimeMillis();
            LocalFile[] validFiles = this.validateFiles(sourceFiles);
            if (validFiles == null || validFiles.length == 0) {
                return;
            }
            ImportTask task = new ImportTask(this.getProject(), this.getWindow(), validFiles, this.targetDir);
            String msg = LNG.get((String)IMPORT_IN_PROGRESS_MSG);
            if (task.execute(this.getWindow(), LNG.get((String)TITLE), msg, false, true)) {
                double totalSize = this.getTotalSizeInKBytes(task.getTotalSize());
                double totalTime = this.getElapsedTime(this.fileCreationStart);
                double transferTime = this.getElapsedTime(task.getTransferStart());
                double transferRate = this.getTransferRate(totalSize, transferTime);
                int errors = (Integer)task.getResult();
                msg = errors == 0 ? LNG.get((String)SUCCESS_ALL) : (errors == -1 ? LNG.get((String)SUCCESS_NONE) : String.format(LNG.get((String)SUCCESS_PARTIAL), errors));
                String stats = String.format(LNG.get((String)"PRJ_PROJECT_FILE_IMPORT_STATS"), totalSize, totalTime, transferRate);
                Object[] ids = new Object[]{User.getLoggedUser().getId()};
                NotificationProxy.notifyTo(ids, String.valueOf(msg) + ' ' + stats, false, false);
                if (errors != 0) {
                    this.showWarning(msg);
                }
            }
        }
        catch (IOException ex) {
            this.showError(LNG.get((String)IO_ERROR), ex);
        }
    }

    private double getTotalSizeInKBytes(long sizeInBytes) {
        return sizeInBytes / 1024L;
    }

    private double getElapsedTime(long start) {
        return (double)(System.currentTimeMillis() - start) / 1000.0;
    }

    private double getTransferRate(double totalSize, double elapsedTime) {
        return totalSize / elapsedTime;
    }

    private LocalFile[] validateFiles(LocalFile[] sourceFiles) throws IOException {
        Object[] replaceOptions;
        int noToAllOption;
        int yesOption;
        int yesToAllOption;
        ArrayList<LocalFile> validFiles = new ArrayList<LocalFile>();
        int lastReplaceOption = -1;
        if (1 == sourceFiles.length) {
            yesToAllOption = 0;
            yesOption = 0;
            noToAllOption = 1;
            replaceOptions = new String[]{LNG.get((String)"UTIL_YES"), LNG.get((String)"UTIL_NO")};
        } else {
            yesOption = 0;
            yesToAllOption = 1;
            noToAllOption = 3;
            replaceOptions = new String[]{LNG.get((String)"UTIL_YES"), LNG.get((String)"UTIL_YES_TO_ALL"), LNG.get((String)"UTIL_NO"), LNG.get((String)"UTIL_NO_TO_ALL")};
        }
        LocalFile[] localFileArray = sourceFiles;
        int n = sourceFiles.length;
        int n2 = 0;
        while (n2 < n) {
            LocalFile file = localFileArray[n2];
            String fileName = file.getName();
            if (!ClientUtilities.isValidFileName(fileName)) {
                this.showError(LNG.get((String)NAME_CHARACTER_ERROR));
                return new LocalFile[0];
            }
            if (!file.exists()) {
                this.showError(MessageFormat.format(LNG.get((String)FILE_NOT_FOUND), file.getName()));
                return new LocalFile[0];
            }
            if (this.targetDir.getChild(fileName) != null) {
                if (lastReplaceOption != noToAllOption) {
                    if (lastReplaceOption == yesToAllOption) {
                        validFiles.add(file);
                    } else {
                        String question = MessageFormat.format(LNG.get((String)FILE_EXISTS), fileName, this.targetDir.getName());
                        lastReplaceOption = StandardDialogs.showOptionDialog((Component)this.getWindow(), (String)LNG.get((String)TITLE), (Object)question, (Object[])replaceOptions);
                        if (yesOption == lastReplaceOption || yesToAllOption == lastReplaceOption) {
                            validFiles.add(file);
                        }
                    }
                }
            } else {
                validFiles.add(file);
            }
            ++n2;
        }
        return validFiles.toArray(new LocalFile[validFiles.size()]);
    }

    @Override
    protected void showError(String msg) {
        this.showError(LNG.get((String)TITLE), msg);
    }

    private void showWarning(String msg) {
        StandardDialogs.showWarningDialog((Component)this.getWindow(), (String)LNG.get((String)TITLE), (String)msg);
    }

    private void showError(String msg, Exception ex) {
        StandardErrorDialogs.showErrorDialog(this.getWindow(), LNG.get((String)TITLE), msg, ex);
    }

    @Override
    public String getName() {
        return LNG.get((String)"PRJ_PROJECT_FILE_IMPORT");
    }
}

