/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.project.action;

import csbase.client.project.ProjectFileContainer;
import csbase.client.project.action.CommonFileExportAction;
import csbase.logic.ClientProjectFile;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.security.AccessControlException;
import java.util.Collection;
import javax.swing.JFileChooser;
import tecgraf.javautils.core.io.FileUtils;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.StandardDialogs;

public class ExportFilesToDirAction
extends CommonFileExportAction {
    private static final String JNLP_CANT_EXPORT_MULTIPLE = "JNLP_CANT_EXPORT_MULTIPLE";

    public ExportFilesToDirAction(ProjectFileContainer container) {
        super(container);
    }

    private File getUserTarget() {
        JFileChooser chooser = this.getFileChooser();
        chooser.setFileSelectionMode(1);
        chooser.setMultiSelectionEnabled(false);
        int result = chooser.showSaveDialog(this.getWindow());
        if (result == 0) {
            return chooser.getSelectedFile();
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ClientProjectFile[] selectedFiles = this.getSelectedFiles();
        if (selectedFiles == null || selectedFiles.length == 0) {
            return;
        }
        try {
            File userTarget = this.getUserTarget();
            if (userTarget == null) {
                return;
            }
            if (!userTarget.exists() && !userTarget.mkdir()) {
                this.showError(LNG.get((String)"PRJ_PROJECT_FILE_IMPORT_CRITICAL_ERROR"));
                return;
            }
            Collection<ClientProjectFile> sourceFiles = this.selectTopFiles(selectedFiles);
            String userTargetPath = userTarget.getAbsolutePath();
            for (ClientProjectFile sourceFile : sourceFiles) {
                long fileSize = this.getFileSize(sourceFile);
                if (fileSize == -1L) {
                    int option = StandardDialogs.showYesNoDialog((Component)this.getWindow(), (String)LNG.get((String)"PRJ_PROJECT_FILE_EXPORT_TITLE"), (Object)LNG.get((String)"ExportFilesToDirAction.continue.question"));
                    if (option != 1) continue;
                } else if (fileSize != 0L || this.confirmEmptyFileExport(sourceFile)) {
                    File targetFile = new File(String.valueOf(userTargetPath) + File.separator + sourceFile.getName());
                    if (targetFile.exists()) {
                        if (!this.confirmOverwrite(targetFile)) continue;
                        FileUtils.delete((File)targetFile);
                    }
                    this.transferFile(sourceFile, targetFile);
                    continue;
                }
                break;
            }
        }
        catch (AccessControlException ex1) {
            if (selectedFiles.length > 1) {
                this.showError(JNLP_CANT_EXPORT_MULTIPLE);
                return;
            }
            this.transferFileUsingJNLP(selectedFiles[0]);
        }
    }
}

