/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.project.action;

import csbase.client.desktop.DesktopComponentDialog;
import csbase.client.desktop.RemoteTask;
import csbase.client.util.ClientUtilities;
import csbase.logic.ClientProjectFile;
import csbase.logic.ProjectFileType;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import tecgraf.javautils.core.lng.LNG;

public class MultiSelectionFileTypeChangeDialog {
    private DesktopComponentDialog dialog = null;
    private Window owner = null;
    private JButton defaultButton;
    private ClientProjectFile[] files;
    private String[] fileNames;
    private JComboBox fileTypeList;

    public static void show(Window owner, ClientProjectFile[] files) {
        new MultiSelectionFileTypeChangeDialog(owner, files);
    }

    private DesktopComponentDialog makeDialog() {
        DesktopComponentDialog d = new DesktopComponentDialog(this.owner, this.getTitle());
        d.setModal(false);
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add(this.makePropertiesPanel(d.getBackground()));
        mainPanel.add((Component)this.makeButtonPanel(), "South");
        d.getContentPane().add(mainPanel);
        d.pack();
        d.center(this.owner);
        d.getRootPane().setDefaultButton(this.defaultButton);
        return d;
    }

    private JPanel makePropertiesPanel(Color background) {
        JList<String> selectedFilesList = new JList<String>(this.fileNames);
        JScrollPane selectedfiles = new JScrollPane(selectedFilesList);
        selectedFilesList.setEnabled(false);
        ProjectFileType[] fTypes = ProjectFileType.getAllFileTypes();
        this.fileTypeList = new JComboBox<ProjectFileType>(new DefaultComboBoxModel<ProjectFileType>(fTypes));
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = new Insets(10, 10, 10, 10);
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.gridx = 0;
        constraints.gridy = 0;
        panel.add((Component)new JLabel(LNG.get((String)"PRJ_FILE_NAME")), constraints);
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridx = 1;
        constraints.gridy = 0;
        panel.add((Component)selectedfiles, constraints);
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.gridx = 0;
        constraints.gridy = 1;
        panel.add((Component)new JLabel(LNG.get((String)"PRJ_FILE_NEW_TYPE")), constraints);
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.gridx = 1;
        constraints.gridy = 1;
        panel.add((Component)this.fileTypeList, constraints);
        return panel;
    }

    private JPanel makeButtonPanel() {
        JPanel panel = new JPanel();
        this.defaultButton = new JButton(LNG.get((String)"PRJ_FILE_TYPE_CHANGE_CONFIRMATION"));
        panel.add(this.defaultButton);
        this.defaultButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultiSelectionFileTypeChangeDialog.this.changeType();
            }
        });
        JButton cancelButton = new JButton(LNG.get((String)"PRJ_CANCEL"));
        panel.add(cancelButton);
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultiSelectionFileTypeChangeDialog.this.dialog.close();
            }
        });
        JComponent[] allButtons = new JButton[]{this.defaultButton, cancelButton};
        ClientUtilities.adjustEqualSizes(allButtons);
        return panel;
    }

    protected String getTitle() {
        return LNG.get((String)"PRJ_PROJECT_FILE_CHANGE_TYPE_TITLE");
    }

    private void retrieveFileProperties() {
        RemoteTask<Void> task = new RemoteTask<Void>(){

            public void performTask() throws Exception {
                int i = 0;
                while (i < MultiSelectionFileTypeChangeDialog.this.files.length) {
                    ((MultiSelectionFileTypeChangeDialog)MultiSelectionFileTypeChangeDialog.this).fileNames[i] = MultiSelectionFileTypeChangeDialog.this.files[i].getName();
                    ++i;
                }
            }
        };
        task.execute(this.owner, this.getTitle(), LNG.get((String)"PRJ_WAITING_OBTAIN_FILE_PROPERTIES"));
    }

    private String getNewType() {
        ProjectFileType selectedType = (ProjectFileType)this.fileTypeList.getSelectedItem();
        return selectedType.getCode();
    }

    private void changeType() {
        final String newType = this.getNewType();
        RemoteTask<Void> task = new RemoteTask<Void>(){

            public void performTask() throws Exception {
                int i = 0;
                while (i < MultiSelectionFileTypeChangeDialog.this.files.length) {
                    if (!newType.equals(MultiSelectionFileTypeChangeDialog.this.files[i].getType())) {
                        MultiSelectionFileTypeChangeDialog.this.files[i].changeType(newType);
                    }
                    ++i;
                }
            }
        };
        if (task.execute(this.owner, this.getTitle(), LNG.get((String)"PRJ_WAITING_CHANGE_FILES_TYPE"))) {
            this.dialog.close();
        }
    }

    private MultiSelectionFileTypeChangeDialog(Window owner, ClientProjectFile[] files) {
        this.owner = owner;
        this.files = files;
        this.fileNames = new String[files.length];
        this.retrieveFileProperties();
        this.dialog = this.makeDialog();
        this.dialog.setVisible(true);
    }
}

