/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.project.dialogs;

import csbase.client.applications.projectsmanager.usersearch.UserPanel;
import csbase.logic.CommonClientProject;
import csbase.logic.ProjectPermissions;
import csbase.logic.User;
import csbase.logic.UserOutline;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.GUIUtils;
import tecgraf.javautils.gui.StandardDialogs;

public class PublishProjectDialog
extends JDialog {
    protected JRadioButton choicePrivate;
    protected JRadioButton choicePublic;
    protected JRadioButton choicePublicRO;
    protected JRadioButton choicePublicRW;
    protected JRadioButton choiceSharedPartial;
    protected JButton confirmButton;
    protected JButton cancelButton;
    protected boolean userConfirmed;
    protected UserPanel sharingPanel;
    protected Set<Object> usersRO;
    protected Set<Object> usersRW;
    protected ProjectPermissions.SharingType sharingType;
    private boolean isClosed;

    public PublishProjectDialog(JFrame parent, CommonClientProject project, List<UserOutline> allUsers, Set<Object> usersRO, Set<Object> usersRW) {
        this(parent, project.getUserId(), project.getName(), project.getSharingType(), allUsers, usersRO, usersRW);
    }

    public PublishProjectDialog(JFrame parent, Object ownerID, String prjName, ProjectPermissions.SharingType sharingType, List<UserOutline> allUsers, Set<Object> usersRO, Set<Object> usersRW) {
        super(parent, String.format(LNG.get((String)"PublishProjectDialog.title"), prjName), true);
        this.sharingType = sharingType;
        this.filterUsers(allUsers, ownerID);
        this.sharingPanel = new UserPanel(allUsers, usersRO, usersRW, true);
    }

    private PublishProjectDialog() {
        this(null, null, "TESTE", ProjectPermissions.SharingType.PARTIAL, new ArrayList<UserOutline>(), new HashSet<Object>(), new HashSet<Object>());
    }

    private void filterUsers(List<UserOutline> allUsers, Object ownerID) {
        ArrayList<UserOutline> toRemove = new ArrayList<UserOutline>();
        for (UserOutline userOutline : allUsers) {
            Object id = userOutline.getId();
            if (id.equals(User.getAdminId()) || id.equals(ownerID)) {
                toRemove.add(userOutline);
            }
            if (toRemove.size() == 2) break;
        }
        allUsers.removeAll(toRemove);
    }

    protected void createGUI() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                PublishProjectDialog.this.cancel();
            }
        });
        this.setLayout(new GridBagLayout());
        int y = this.addInputPanels(0);
        this.configureRadioButtons();
        JPanel buttonsPanel = this.createButtonsPanel();
        GBC gbc = new GBC(0, y++).northwest().bottom(5).horizontal();
        this.add((Component)buttonsPanel, gbc);
    }

    protected int addInputPanels(int yArg) {
        int y = yArg;
        GBC gbc = new GBC(0, y++).both();
        this.add((Component)this.createMainPanel(), gbc);
        return y;
    }

    protected JPanel createMainPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        this.choicePrivate = new JRadioButton(LNG.get((String)"PublishProjectDialog.option.private"));
        this.choicePublic = new JRadioButton(LNG.get((String)"PublishProjectDialog.option.public"));
        this.choicePublicRO = new JRadioButton(LNG.get((String)"PublishProjectDialog.option.public.ro"));
        this.choicePublicRW = new JRadioButton(LNG.get((String)"PublishProjectDialog.option.public.rw"));
        this.choiceSharedPartial = new JRadioButton(LNG.get((String)"PublishProjectDialog.option.partial"));
        int y = 0;
        GBC gbc = new GBC(0, y++).northwest().top(10).left(10);
        panel.add((Component)this.choicePrivate, gbc);
        gbc = new GBC(0, y++).northwest().top(0).left(10);
        panel.add((Component)this.choicePublic, gbc);
        gbc = new GBC(0, y++).northwest().top(0).left(30);
        panel.add((Component)this.choicePublicRW, gbc);
        gbc = new GBC(0, y++).northwest().top(0).left(30);
        panel.add((Component)this.choicePublicRO, gbc);
        gbc = new GBC(0, y++).northwest().top(0).left(10);
        panel.add((Component)this.choiceSharedPartial, gbc);
        JPanel sharedUsersPanel = this.createSharedUsersPanel();
        gbc = new GBC(0, y++).northwest().insets(5, 35, 10, 15).both();
        panel.add((Component)sharedUsersPanel, gbc);
        return panel;
    }

    private void configureRadioButtons() {
        this.choicePublic.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean isSelected = e.getStateChange() == 1;
                PublishProjectDialog.this.choicePublicRO.setEnabled(isSelected);
                PublishProjectDialog.this.choicePublicRW.setEnabled(isSelected);
            }
        });
        this.choiceSharedPartial.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean isSelected = e.getStateChange() == 1;
                PublishProjectDialog.this.enableSharedUsersPanel(isSelected);
            }
        });
        ButtonGroup mainRadiosGroup = new ButtonGroup();
        mainRadiosGroup.add(this.choicePrivate);
        mainRadiosGroup.add(this.choicePublic);
        mainRadiosGroup.add(this.choiceSharedPartial);
        ButtonGroup publicRadiosGroup = new ButtonGroup();
        publicRadiosGroup.add(this.choicePublicRO);
        publicRadiosGroup.add(this.choicePublicRW);
        switch (this.sharingType) {
            case PRIVATE: {
                this.choicePrivate.setSelected(true);
                this.choicePublicRO.setEnabled(false);
                this.choicePublicRW.setEnabled(false);
                this.choicePublicRW.setSelected(true);
                this.enableSharedUsersPanel(false);
                break;
            }
            case ALL_RO: {
                this.choicePublic.setSelected(true);
                this.choicePublicRO.setSelected(true);
                this.enableSharedUsersPanel(false);
                break;
            }
            case ALL_RW: {
                this.choicePublic.setSelected(true);
                this.choicePublicRW.setSelected(true);
                this.enableSharedUsersPanel(false);
                break;
            }
            case PARTIAL: {
                this.choiceSharedPartial.setSelected(true);
                this.choicePublicRO.setEnabled(false);
                this.choicePublicRW.setEnabled(false);
                this.choicePublicRW.setSelected(true);
            }
        }
    }

    public void enableSharedUsersPanel(boolean enabled) {
        this.sharingPanel.enableSharedUsersPanel(enabled);
    }

    private JPanel createSharedUsersPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder(""));
        GBC gbc = new GBC(0, 1).both().insets(10, 10, 0, 10).width(3);
        panel.add((Component)this.sharingPanel, gbc);
        return panel;
    }

    private JPanel createButtonsPanel() {
        JPanel panel = new JPanel();
        this.confirmButton = new JButton(LNG.get((String)"PublishProjectDialog.button.confirm"));
        this.confirmButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PublishProjectDialog.this.canConfirm()) {
                    PublishProjectDialog.this.confirm();
                }
            }
        });
        this.cancelButton = new JButton(LNG.get((String)"PublishProjectDialog.button.cancel"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PublishProjectDialog.this.cancel();
            }
        });
        panel.add(this.confirmButton);
        panel.add(this.cancelButton);
        JComponent[] buttons = new JComponent[]{this.confirmButton, this.cancelButton};
        GUIUtils.matchPreferredSizes((JComponent[])buttons);
        return panel;
    }

    protected void confirm() {
        this.userConfirmed = true;
        this.close();
    }

    protected boolean canConfirm() {
        return true;
    }

    protected void cancel() {
        int option;
        if (this.publishChanged() && (option = StandardDialogs.showYesNoDialog((Component)this, (String)LNG.get((String)"PublishProjectDialog.confirmation.dialog.title"), (Object)LNG.get((String)"PublishProjectDialog.confirmation.dialog.message"))) == 1) {
            return;
        }
        this.userConfirmed = false;
        this.close();
    }

    private boolean publishChanged() {
        ProjectPermissions.SharingType selectedSharingType = this.getSelectedSharingType();
        if (this.sharingType != selectedSharingType) {
            return true;
        }
        if (selectedSharingType == ProjectPermissions.SharingType.PARTIAL) {
            return this.sharingPanel.hasUsersPermissionsChanged();
        }
        return false;
    }

    private ProjectPermissions.SharingType getSelectedSharingType() {
        if (this.choicePrivate.isSelected()) {
            return ProjectPermissions.SharingType.PRIVATE;
        }
        if (this.choicePublic.isSelected()) {
            if (this.choicePublicRO.isSelected()) {
                return ProjectPermissions.SharingType.ALL_RO;
            }
            return ProjectPermissions.SharingType.ALL_RW;
        }
        return ProjectPermissions.SharingType.PARTIAL;
    }

    protected void close() {
        this.sharingPanel.fillUserSets();
        this.usersRO = this.sharingPanel.getUsersRO();
        this.usersRW = this.sharingPanel.getUsersRW();
        this.sharingType = this.getSelectedSharingType();
        this.setVisible(false);
        this.dispose();
        this.isClosed = true;
    }

    public boolean execute() {
        this.createGUI();
        this.setSize(new Dimension(600, 700));
        this.setVisible(true);
        return this.userConfirmed;
    }

    public ProjectPermissions.SharingType getSharingType() {
        this.checkIsClosed();
        return this.sharingType;
    }

    public Set<Object> getUsersRO() {
        this.checkIsClosed();
        return this.usersRO;
    }

    protected void checkIsClosed() {
        if (!this.isClosed) {
            throw new IllegalStateException(LNG.get((String)"PublishProjectDialog.not.closed.msg"));
        }
    }

    public Set<Object> getUsersRW() {
        this.checkIsClosed();
        return this.usersRW;
    }

    public static void main(String[] args) {
        PublishProjectDialog dialog = new PublishProjectDialog();
        dialog.execute();
    }
}

