/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.project.dialogs;

import csbase.logic.UserOutline;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.table.DefaultTableModel;
import tecgraf.javautils.core.lng.LNG;

class UsersPermissionsTableModel
extends DefaultTableModel {
    public static final int COL_LOGIN = 0;
    public static final int COL_NAME = 1;
    public static final int COL_RW = 2;
    public static final int COL_RO = 3;
    private List<AccesType> permissions;
    private int numUsers;
    private final List<UserOutline> allUsers;
    private static final String[] COLUMN_NAMES = new String[]{LNG.get((String)"UsersPermissionsTableModel.header.login"), LNG.get((String)"UsersPermissionsTableModel.header.name"), LNG.get((String)"UsersPermissionsTableModel.header.rw"), LNG.get((String)"UsersPermissionsTableModel.header.ro")};
    private static final Class<?>[] COLUMN_CLASSES = new Class[]{String.class, String.class, Boolean.class, Boolean.class};
    private boolean enableRORWColumn;

    UsersPermissionsTableModel(List<UserOutline> allUsers, Set<Object> usersRO, Set<Object> usersRW) {
        if (allUsers == null) {
            this.allUsers = null;
            return;
        }
        this.allUsers = Collections.unmodifiableList(allUsers);
        this.permissions = new ArrayList<AccesType>();
        for (UserOutline user : allUsers) {
            Object userID = user.getId();
            if (usersRO != null && usersRO.contains(userID)) {
                this.permissions.add(AccesType.RO);
                continue;
            }
            if (usersRW != null && usersRW.contains(userID)) {
                this.permissions.add(AccesType.RW);
                continue;
            }
            this.permissions.add(AccesType.NONE);
        }
        this.numUsers = allUsers.size();
        this.enableRORWColumn = true;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return COLUMN_CLASSES[columnIndex];
    }

    @Override
    public String getColumnName(int column) {
        return COLUMN_NAMES[column];
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public int getRowCount() {
        return this.numUsers;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.allUsers.get(rowIndex).getLogin();
            }
            case 1: {
                return this.allUsers.get(rowIndex).getName();
            }
            case 2: {
                return this.permissions.get(rowIndex) == AccesType.RW;
            }
            case 3: {
                return this.permissions.get(rowIndex) == AccesType.RO;
            }
        }
        throw new RuntimeException("coluna inv\u00e1lida: " + columnIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex < 2) {
            return false;
        }
        return this.enableRORWColumn;
    }

    public void enableRORWColumn(boolean enable) {
        this.enableRORWColumn = enable;
        this.fireTableStructureChanged();
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        AccesType accessType;
        AccesType oldAccessType = this.permissions.get(rowIndex);
        switch (columnIndex) {
            case 2: {
                accessType = oldAccessType == AccesType.RW ? AccesType.NONE : AccesType.RW;
                break;
            }
            case 3: {
                accessType = oldAccessType == AccesType.RO ? AccesType.NONE : AccesType.RO;
                break;
            }
            default: {
                throw new RuntimeException("coluna inv\u00e1lida: " + columnIndex);
            }
        }
        this.permissions.set(rowIndex, accessType);
        this.fireTableRowsUpdated(rowIndex, rowIndex);
    }

    public void setReadOnlyFor(boolean isReadOnly, int rowIndex) {
        this.permissions.set(rowIndex, isReadOnly ? AccesType.RO : AccesType.NONE);
        this.fireTableRowsUpdated(rowIndex, rowIndex);
    }

    public void fillUserSets(Set<Object> usersRO, Set<Object> usersRW) {
        int i = 0;
        while (i < this.allUsers.size()) {
            switch (this.permissions.get(i)) {
                case RO: {
                    usersRO.add(this.allUsers.get(i).getId());
                    break;
                }
                case RW: {
                    usersRW.add(this.allUsers.get(i).getId());
                }
            }
            ++i;
        }
    }

    static enum AccesType {
        NONE,
        RO,
        RW;

    }
}

