/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.project.tasks;

import csbase.client.desktop.DesktopFrame;
import csbase.client.desktop.RemoteTask;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.ClientProjectFile;
import java.awt.Window;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import tecgraf.javautils.core.io.FileUtils;
import tecgraf.javautils.core.lng.LNG;

public class GetFileContentTask
extends RemoteTask<String> {
    private static final int MAX_BUFFER_SIZE = 102400;
    private final ClientProjectFile file;

    public GetFileContentTask(ClientProjectFile file) {
        this.file = file;
    }

    protected void performTask() throws Exception {
        int fileSize = (int)this.file.size();
        BufferedReader reader = null;
        try {
            try {
                StringBuilder stringBuffer = new StringBuilder(fileSize);
                char[] buffer = new char[102400];
                InputStream stream = this.file.getInputStream();
                reader = new BufferedReader(new InputStreamReader(stream));
                int nbytes = reader.read(buffer);
                while (nbytes > 0) {
                    stringBuffer.append(buffer, 0, nbytes);
                    nbytes = reader.read(buffer);
                }
                this.setResult(stringBuffer.toString());
            }
            catch (OutOfMemoryError e) {
                StandardErrorDialogs.showErrorDialog(this.parentWindow, LNG.get((String)"GetFileContentTask.title"), String.format(LNG.get((String)"GetFileContentTask.outOfMemoryMessage"), this.file.getName(), (double)fileSize / 1048576.0));
                if (reader != null) {
                    reader.close();
                }
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    protected String[] getAdditionalInfo() {
        return new String[]{String.format(LNG.get((String)"GetFileContentTask.fileInfo"), FileUtils.joinPath((char)'/', (String[])this.file.getPath()))};
    }

    public boolean execute(Window taskDialogParent) {
        return super.execute(taskDialogParent, LNG.get((String)"GetFileContentTask.title"), String.format(LNG.get((String)"GetFileContentTask.msg"), this.file.getName()));
    }

    public boolean execute() {
        return this.execute(DesktopFrame.getInstance().getDesktopFrame());
    }
}

