/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.remote;

import csbase.client.ClientServerManager;
import csbase.client.login.ReloginDialog;
import csbase.client.openbus.OpenBusAuthenticator;
import csbase.exception.CSBaseException;
import csbase.logic.LoginInfo;
import csbase.logic.ServerURI;
import csbase.logic.Session;
import csbase.logic.SingleServerManager;
import csbase.logic.User;
import csbase.logic.openbus.OpenBusLoginToken;
import csbase.remote.Authenticator;
import csbase.remote.PreLoginAuthenticator;
import csbase.remote.UserPasswordAuthenticator;
import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import java.util.Locale;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.SwingThreadDispatcher;

public class ClientRemoteMonitor
extends SingleServerManager {
    private static ClientRemoteMonitor instance;
    private boolean localLogin;
    private boolean passwordChangeAllowed;
    private LoginInfo loginInfo;
    private Authenticator authenticator;

    public final Authenticator getAuthenticator() {
        return this.authenticator;
    }

    public ClientRemoteMonitor(String appName, String serverURI, Class<?> locator) {
        super(ServerURI.parse((String)serverURI), locator, ClientServerManager.getWindowSize());
        instance = this;
    }

    public static final ClientRemoteMonitor getInstance() {
        return instance;
    }

    protected final void warning(String message) {
        System.err.println(message);
    }

    protected final void error(Throwable t) {
        t.printStackTrace();
    }

    private LoginInfo askLogin() {
        final class AskLoginTask
        implements Runnable {
            LoginInfo info;

            AskLoginTask() {
            }

            @Override
            public void run() {
                ReloginDialog dialog = new ReloginDialog(ClientRemoteMonitor.this.getReloginImagePath());
                dialog.setVisible(true);
                this.info = dialog.getLoginInfo();
            }

            public LoginInfo getLoginInfo() {
                return this.info;
            }
        }
        AskLoginTask task = new AskLoginTask();
        try {
            SwingThreadDispatcher.invokeAndWait((Runnable)task);
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
        catch (InvocationTargetException te) {
            throw (RuntimeException)te.getCause();
        }
        return task.getLoginInfo();
    }

    public String getLogin() {
        return this.loginInfo.getLoginName();
    }

    public String getPassword() {
        return this.loginInfo.getPassword();
    }

    public void setPassword(String newPassword) {
        this.loginInfo.setPassword(newPassword);
    }

    public final boolean isLocalLogin() {
        return this.localLogin;
    }

    public final boolean canChangePasswords() {
        return this.passwordChangeAllowed;
    }

    public final boolean start(String login, String password, Locale locale) throws CSBaseException {
        if (login == null || password == null || locale == null) {
            throw new IllegalArgumentException("login: " + login + ", password: " + password + ", locale: " + locale);
        }
        this.loginInfo = new LoginInfo(login, password, locale);
        this.authenticator = new UserPasswordAuthenticator(login, password, locale);
        return this.start();
    }

    public final boolean start(String token) throws CSBaseException {
        if (token == null) {
            throw new IllegalArgumentException("token: " + token);
        }
        this.authenticator = new PreLoginAuthenticator(token);
        this.loginInfo = null;
        return this.start();
    }

    public final boolean start(OpenBusLoginToken token, Locale locale) throws CSBaseException {
        this.authenticator = new OpenBusAuthenticator(token, locale);
        return this.start();
    }

    protected boolean start() throws CSBaseException {
        boolean r = false;
        try {
            r = this.lookup();
            if (r) {
                this.startMonitoring();
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return r;
    }

    protected Session login() throws CSBaseException, RemoteException {
        this.passwordChangeAllowed = this.getServer().canChangePasswords();
        this.localLogin = this.getServer().isLocalLogin();
        Session session = this.authenticator.authenticate(this.getServer());
        if (session == null) {
            return null;
        }
        User user = session.getUser();
        User.registerLogin((Object)session.getKey(), (User)user);
        return session;
    }

    public LoginInfo getLoginInfo() {
        if (this.loginInfo == null) {
            this.loginInfo = this.askLogin();
        }
        return this.loginInfo;
    }

    protected String getReloginImagePath() {
        return null;
    }

    protected String lang(String key) {
        return LNG.get((String)key);
    }
}

