/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.remote;

import csbase.client.algorithms.commands.CommandListener;
import csbase.client.remote.ClientRemoteMonitor;
import csbase.logic.CommandEvent;
import csbase.remote.RemoteEvent;
import csbase.remote.RemoteObserver;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.LinkedList;
import java.util.Observable;

@Deprecated
public class CommandObserver
extends Observable
implements RemoteObserver {
    private static CommandObserver instance;
    private LinkedList<CommandListener> listeners = new LinkedList();

    private CommandObserver() {
    }

    public static CommandObserver getInstance() {
        if (instance == null) {
            throw new IllegalStateException("A inst\u00e2ncia do observador n\u00e3o foi criada.\nChame o m\u00e9todo start primeiro.\n");
        }
        return instance;
    }

    public static void start() throws RemoteException {
        if (instance != null) {
            return;
        }
        instance = new CommandObserver();
        instance.install();
    }

    public static void stop() throws RemoteException {
        if (instance == null) {
            return;
        }
        instance.uninstall();
    }

    public void addCommandObserver(Object commandId) {
        ClientRemoteMonitor.getInstance().addObserver("SGAService", this, commandId);
    }

    public void addListener(CommandListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("O par\u00e2metro listener est\u00e1 nulo.");
        }
        this.listeners.add(listener);
    }

    public void deleteCommandObserver(Object commandId) {
    }

    public void install() throws RemoteException {
        UnicastRemoteObject.exportObject((Remote)((Object)this), 0);
    }

    public boolean removeListener(CommandListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("O par\u00e2metro listener est\u00e1 nulo.");
        }
        return this.listeners.remove(listener);
    }

    public void uninstall() throws RemoteException {
        UnicastRemoteObject.unexportObject((Remote)((Object)this), true);
    }

    public void update(RemoteEvent event) {
        CommandEvent action = (CommandEvent)event;
        String commandId = (String)action.getCommandId();
        switch (action.getType()) {
            case COMPLETED: {
                this.fireCommandWasCompleted(commandId);
                break;
            }
            case SUCCESS: {
                this.fireCommandExecutionSucceded(commandId);
                break;
            }
            case ERROR: {
                this.fireCommandExecutionFailure(commandId);
                break;
            }
            case INIT_FAILURE: {
                this.fireCommandInitFailure(commandId);
                break;
            }
            case KILLED: {
                this.fireCommandWasKilled(commandId);
                break;
            }
            case LOST: {
                this.fireCommandWasLost(commandId);
                break;
            }
            case NO_CODE: {
                this.fireCommandWithNoExitCode(commandId);
            }
        }
        this.setChanged();
        this.notifyObservers(action);
    }

    public void update(RemoteEvent[] events) throws RemoteException {
        int i = 0;
        while (i < events.length) {
            this.update(events[i]);
            ++i;
        }
    }

    private void fireCommandInitFailure(String commandId) {
        for (CommandListener listener : this.listeners) {
            listener.initFailure(commandId);
        }
    }

    private void fireCommandExecutionFailure(String commandId) {
        for (CommandListener listener : this.listeners) {
            listener.executionFailure(commandId);
        }
    }

    private void fireCommandExecutionSucceded(String commandId) {
        for (CommandListener listener : this.listeners) {
            listener.executionSucceded(commandId);
        }
    }

    private void fireCommandWasCompleted(String commandId) {
        for (CommandListener listener : this.listeners) {
            listener.wasCompleted(commandId);
        }
    }

    private void fireCommandWasKilled(String commandId) {
        for (CommandListener listener : this.listeners) {
            listener.wasKilled(commandId);
        }
    }

    private void fireCommandWasLost(String commandId) {
        for (CommandListener listener : this.listeners) {
            listener.wasLost(commandId);
        }
    }

    private void fireCommandWithNoExitCode(String commandId) {
        for (CommandListener listener : this.listeners) {
            listener.noExitCode(commandId);
        }
    }
}

