/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.remote.srvproxies;

import csbase.client.desktop.DesktopComponentFrame;
import csbase.client.desktop.DesktopFrame;
import csbase.client.desktop.RemoteTask;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.CommonClientProject;
import csbase.logic.diskusageservice.DiskOccupation;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.DiskUsageServiceInterface;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import tecgraf.javautils.core.lng.LNG;

public class DiskUsageProxy {
    private static String getString(String tag) {
        String className = DiskUsageProxy.class.getSimpleName();
        String newTag = String.valueOf(className) + "." + tag;
        return LNG.get((String)newTag);
    }

    public static String translateAreaId(String id) {
        String prefix = DiskUsageProxy.class.getSimpleName();
        String key = String.valueOf(prefix) + "." + id + ".name";
        String idText = "[Id: " + id + "]";
        String text = !LNG.hasKey((String)key) ? idText : LNG.get((String)key);
        return text;
    }

    public static Hashtable<Object, Double> getUsersList() {
        Hashtable info;
        String message;
        RemoteTask<Hashtable<Object, Double>> task = new RemoteTask<Hashtable<Object, Double>>(){

            public void performTask() throws Exception {
                DiskUsageServiceInterface dskService = ClientRemoteLocator.diskUsageService;
                if (dskService == null) {
                    return;
                }
                this.setResult(dskService.getUsersList());
            }
        };
        DesktopFrame mainFrame = DesktopFrame.getInstance();
        if (mainFrame == null) {
            return null;
        }
        DesktopComponentFrame desktop = mainFrame.getDesktopFrame();
        String PRE = "disk.request";
        String title = DiskUsageProxy.getString("disk.request.title");
        if (task.execute(desktop, title, message = DiskUsageProxy.getString("disk.request.message")) && (info = (Hashtable)task.getResult()) != null) {
            return info;
        }
        String errTitle = DiskUsageProxy.getString("disk.request.error.title");
        String errMessage = DiskUsageProxy.getString("disk.request.error.message");
        StandardErrorDialogs.showErrorDialog((Window)desktop, errTitle, errMessage);
        return null;
    }

    public static double getUsedSpaceForProjectMb(final Object ownerId, final String projName) {
        String message;
        String title;
        RemoteTask<Double> task = new RemoteTask<Double>(){

            public void performTask() throws Exception {
                DiskUsageServiceInterface dskService = ClientRemoteLocator.diskUsageService;
                if (dskService == null) {
                    return;
                }
                this.setResult(dskService.getUsedSpaceForProjectMb(ownerId, projName));
            }
        };
        String PRE = "project.usage";
        DesktopComponentFrame desktop = DesktopFrame.getInstance().getDesktopFrame();
        if (task.execute(desktop, title = DiskUsageProxy.getString("project.usage.title"), message = DiskUsageProxy.getString("project.usage.message"))) {
            double used = (Double)task.getResult();
            return used;
        }
        String errTitle = DiskUsageProxy.getString("project.usage.error.title");
        String errMessage = DiskUsageProxy.getString("project.usage.error.message");
        StandardErrorDialogs.showErrorDialog((Window)desktop, errTitle, errMessage);
        return 0.0;
    }

    private static DiskOccupation getInfo(RemoteTask<DiskOccupation> task) {
        DesktopComponentFrame desktop = DesktopFrame.getInstance().getDesktopFrame();
        String title = LNG.get((String)"DISK_REQUEST_TITLE");
        String msg = LNG.get((String)"DISK_REQUEST_MESSAGE");
        task.setProgressDialogDelay(20);
        boolean executed = task.execute(desktop, title, msg);
        DiskOccupation dummy = new DiskOccupation();
        if (executed) {
            DiskOccupation result = (DiskOccupation)task.getResult();
            if (result == null) {
                return dummy;
            }
            return result;
        }
        return dummy;
    }

    public static DiskOccupation getCurrentProjectOccupation() {
        DesktopFrame desktop = DesktopFrame.getInstance();
        final CommonClientProject project = desktop.getProject();
        if (project == null) {
            return new DiskOccupation();
        }
        RemoteTask<DiskOccupation> task = new RemoteTask<DiskOccupation>(){

            public void performTask() throws Exception {
                DiskUsageServiceInterface diskUsageService = ClientRemoteLocator.diskUsageService;
                Object owner = project.getUserId();
                String projectName = project.getName();
                DiskOccupation serverOccupation = diskUsageService.getSingleProjectOccupation(owner, projectName);
                this.setResult(serverOccupation);
            }

            @Override
            protected void handleError(Exception error) {
                this.setResult(null);
            }
        };
        return DiskUsageProxy.getInfo(task);
    }

    public static DiskOccupation getAreaOccupation(final String id) {
        RemoteTask<DiskOccupation> task = new RemoteTask<DiskOccupation>(){

            public void performTask() throws Exception {
                DiskUsageServiceInterface diskUsageService = ClientRemoteLocator.diskUsageService;
                DiskOccupation serverOccupation = diskUsageService.getAreaOccupation(id);
                this.setResult(serverOccupation);
            }
        };
        return DiskUsageProxy.getInfo(task);
    }

    public static List<String> getAllAreasIds() {
        String message;
        RemoteTask<List<String>> task = new RemoteTask<List<String>>(){

            public void performTask() throws Exception {
                DiskUsageServiceInterface diskUsageService = ClientRemoteLocator.diskUsageService;
                List list = diskUsageService.getAllAreasIds();
                this.setResult(list);
            }
        };
        String PRE = "project.usage";
        DesktopComponentFrame desktop = DesktopFrame.getInstance().getDesktopFrame();
        if (task.execute(desktop, null, message = DiskUsageProxy.getString("project.usage.message"))) {
            List result = (List)task.getResult();
            return result;
        }
        String errMessage = DiskUsageProxy.getString("project.usage.error.message");
        StandardErrorDialogs.showErrorDialog((Window)desktop, null, errMessage);
        ArrayList<String> emptyList = new ArrayList<String>();
        return emptyList;
    }

    public static DiskOccupation getServerOccupation() {
        String id = "server";
        DiskOccupation occ = DiskUsageProxy.getAreaOccupation("server");
        return occ;
    }

    public static DiskOccupation getAlgorithmOccupation() {
        String id = "algorithm";
        return DiskUsageProxy.getAreaOccupation("algorithm");
    }

    public static DiskOccupation getProjectOccupation() {
        String id = "project";
        return DiskUsageProxy.getAreaOccupation("project");
    }
}

