/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.remote.srvproxies;

import csbase.client.desktop.RemoteTask;
import csbase.client.util.StandardErrorDialogs;
import csbase.exception.administration.AdministrationDeleteException;
import csbase.logic.Role;
import csbase.logic.RoleInfo;
import csbase.logic.User;
import csbase.logic.UserInfo;
import csbase.logic.Utilities;
import java.awt.Component;
import java.awt.Window;
import java.util.List;
import java.util.Vector;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.StandardDialogs;

public class RoleProxy {
    public static Vector<Role> getAllRoles(Window owner, String title, String message) {
        RemoteTask<Vector<Role>> task = new RemoteTask<Vector<Role>>(){

            public void performTask() throws Exception {
                this.setResult(new Vector(Role.getAllRoles()));
            }
        };
        if (task.execute(owner, title, message)) {
            Vector rolesVector = (Vector)task.getResult();
            if (rolesVector == null || rolesVector.size() <= 0) {
                return new Vector<Role>();
            }
            return rolesVector;
        }
        return new Vector<Role>();
    }

    public static Role getRole(Window owner, String title, String message, final Object roleId) {
        RemoteTask<Role> task = new RemoteTask<Role>(){

            public void performTask() throws Exception {
                this.setResult(Role.getRole((Object)roleId));
            }
        };
        if (task.execute(owner, title, message)) {
            return (Role)task.getResult();
        }
        return null;
    }

    public static Role createRole(Window owner, String title, String message, final RoleInfo info) {
        RemoteTask<Role> task = new RemoteTask<Role>(){

            public void performTask() throws Exception {
                this.setResult(Role.createRole((RoleInfo)info));
            }
        };
        if (task.execute(owner, title, message)) {
            Role role = (Role)task.getResult();
            if (role == null) {
                StandardErrorDialogs.showErrorDialog(owner, title, LNG.get((String)"IAS_ROLE_ALREADY_EXISTS_ERROR"));
            }
            return role;
        }
        return null;
    }

    public static Role modifyRole(Window owner, String title, String message, final Object roleId, final RoleInfo info) {
        RemoteTask<Role> task = new RemoteTask<Role>(){

            public void performTask() throws Exception {
                this.setResult(Role.modifyRole((Object)roleId, (RoleInfo)info));
            }
        };
        if (task.execute(owner, title, message)) {
            Role role = (Role)task.getResult();
            if (role == null) {
                StandardErrorDialogs.showErrorDialog(owner, title, LNG.get((String)"IAS_ROLE_ALREADY_EXISTS_ERROR"));
            }
            return role;
        }
        return null;
    }

    public static void deleteRole(Window owner, String title, String message, final Object roleId) {
        class DeleteRoleRemoteTask
        extends RemoteTask<Void> {
            boolean removeRole = false;
            private final /* synthetic */ Object val$roleId;
            private final /* synthetic */ Window val$owner;
            private final /* synthetic */ String val$title;

            DeleteRoleRemoteTask(Object object, Window window, String string) {
                this.val$roleId = object;
                this.val$owner = window;
                this.val$title = string;
            }

            public void performTask() throws Exception {
                Role.deleteRole((Object)this.val$roleId);
            }

            @Override
            protected void handleError(Exception error) {
                if (error instanceof AdministrationDeleteException) {
                    String errorMsg = LNG.get((String)"IAS_CONFIRM_ROLE_REMOVAL");
                    int res = StandardDialogs.showYesNoDialog((Component)this.val$owner, (String)this.val$title, (Object)errorMsg);
                    if (res == 0) {
                        this.removeRole = true;
                    }
                } else {
                    super.handleError(error);
                }
            }
        }
        DeleteRoleRemoteTask deleteTask = new DeleteRoleRemoteTask(roleId, owner, title);
        if (!deleteTask.execute(owner, title, message) && deleteTask.removeRole) {
            RemoteTask<Void> task = new RemoteTask<Void>(){

                public void performTask() throws Exception {
                    List users = User.getAllUsers();
                    int i = 0;
                    while (i < users.size()) {
                        User user = (User)users.get(i);
                        Object[] roleIds = user.getRoleIds();
                        int j = 0;
                        while (j < roleIds.length) {
                            if (roleIds[j].equals(roleId)) {
                                Object[] remainingRoleIds = Utilities.removeItemFromArray((Object[])roleIds, (int)j);
                                UserInfo userInfo = user.getUserInfo();
                                userInfo.setAttribute("roleIds", (Object)remainingRoleIds);
                                User.modifyUser((Object)user.getId(), (UserInfo)userInfo);
                                break;
                            }
                            ++j;
                        }
                        ++i;
                    }
                    Role.deleteRole((Object)roleId);
                }
            };
            task.execute(owner, title, message);
        }
    }
}

