/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.remote.srvproxies;

import csbase.client.desktop.RemoteTask;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.CommandInfo;
import csbase.logic.CommandSubmission;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.SchedulerServiceInterface;
import java.awt.Window;
import java.util.Set;
import tecgraf.javautils.core.lng.LNG;

public class SchedulerProxy {
    public static boolean removeCommand(Window window, final Object commandId) {
        final SchedulerServiceInterface schedulerService = ClientRemoteLocator.schedulerService;
        if (schedulerService == null) {
            SchedulerProxy.showError(LNG.get((String)"SCHEDULER_NO_SERVER_ERROR"), null);
            return false;
        }
        RemoteTask<Boolean> task = new RemoteTask<Boolean>(){

            public void performTask() throws Exception {
                this.setResult(schedulerService.removeCommand(commandId));
            }
        };
        task.execute(window, LNG.get((String)"SGA_COMMAND_TITLE"), LNG.get((String)"SGA_COMMAND_MESSAGE"));
        return (Boolean)task.getResult();
    }

    private static void showError(String msg, Exception e) {
        String title = String.valueOf(LNG.get((String)"ERRO")) + " - " + LNG.get((String)"SCHEDULER_ACCESSING_TITLE");
        if (e != null) {
            StandardErrorDialogs.showErrorDialog(null, title, msg, e);
        } else {
            StandardErrorDialogs.showErrorDialog(null, title, msg);
        }
    }

    public static Set<CommandInfo> submitCommand(Window window, final CommandSubmission commandSubmission) {
        final SchedulerServiceInterface schedulerService = ClientRemoteLocator.schedulerService;
        if (schedulerService == null) {
            SchedulerProxy.showError(LNG.get((String)"SCHEDULER_NO_SERVER_ERROR"), null);
            return null;
        }
        RemoteTask<Set<CommandInfo>> task = new RemoteTask<Set<CommandInfo>>(){

            public void performTask() throws Exception {
                this.setResult(schedulerService.submitCommand(commandSubmission));
            }
        };
        boolean execute = task.execute(window, LNG.get((String)"SCHEDULER_COMMAND_TITLE"), LNG.get((String)"SCHEDULER_COMMAND_MESSAGE"));
        if (execute) {
            return (Set)task.getResult();
        }
        return null;
    }
}

