/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util;

import csbase.client.util.ExceptionDialog;
import csbase.exception.PermissionException;
import java.awt.Component;
import java.awt.Window;
import java.util.Arrays;
import javax.swing.JOptionPane;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.StandardDialogs;

public class StandardErrorDialogs {
    private static final String[] CLOSE = new String[]{LNG.get((String)"UTIL_CLOSE")};

    public static void showErrorDialog(Window window, Object msg) {
        StandardErrorDialogs.showErrorDialog(window, LNG.get((String)"UTIL_EXECUTION_ERROR"), msg, null);
    }

    public static void showExceptionDialog(Window wnd, String title, Throwable t) {
        StandardErrorDialogs.showExceptionDialog(wnd, title, t, null);
    }

    public static void showExceptionDialog(Window wnd, String title, Throwable t, String[] additionalInfo) {
        String msg;
        String string = msg = title == null ? "" : title;
        if (t instanceof PermissionException) {
            StandardErrorDialogs.showPermissionDeniedDialog(wnd, (PermissionException)t);
            return;
        }
        ExceptionDialog dlg = ExceptionDialog.createDialog(wnd, msg, t, additionalInfo);
        dlg.setVisible(true);
    }

    private static void showPermissionDeniedDialog(Window wnd, PermissionException exception) {
        String msg = exception.getMessage();
        if (msg == null || msg.isEmpty()) {
            msg = LNG.get((String)"UTIL_PERMISSION_DENIED_MSG");
        }
        StandardDialogs.showErrorDialog((Component)wnd, (String)LNG.get((String)"UTIL_PERMISSION_DENIED_TITLE"), (String)msg);
    }

    public static void showErrorDialog(Window window, String titleStr, Object msg, Throwable throwable) {
        StandardErrorDialogs.showErrorDialog(window, titleStr, msg, throwable, null);
    }

    public static void showErrorDialog(Window window, String titleStr, Object msg, Throwable throwable, String[] additionalInfo) {
        if (throwable instanceof PermissionException) {
            StandardErrorDialogs.showPermissionDeniedDialog(window, (PermissionException)throwable);
            return;
        }
        String title = String.valueOf(LNG.get((String)"UTIL_ERROR")) + " - " + titleStr;
        if (throwable == null) {
            if (additionalInfo != null) {
                Object[] allMessages;
                if (msg instanceof Object[]) {
                    allMessages = StandardErrorDialogs.joinArrays((Object[])msg, additionalInfo);
                } else {
                    allMessages = new Object[additionalInfo.length + 1];
                    allMessages[0] = msg;
                    int i = 1;
                    while (i < allMessages.length) {
                        allMessages[i] = additionalInfo[i - 1];
                        ++i;
                    }
                }
                StandardErrorDialogs.showSimpleErrorDialog(window, title, allMessages);
            } else {
                StandardErrorDialogs.showSimpleErrorDialog(window, title, msg);
            }
        } else {
            StandardErrorDialogs.showExceptionDialog(window, title, msg, throwable, additionalInfo);
        }
    }

    private static Object[] joinArrays(Object[] array1, Object[] array2) {
        int newSize = array1.length + array2.length;
        Object[] newMsg = Arrays.copyOf(array1, newSize);
        int i = 0;
        while (i < array2.length) {
            newMsg[array1.length + i] = array2[i];
            ++i;
        }
        return newMsg;
    }

    private static void showExceptionDialog(Window window, String title, Object msg, Throwable throwable, String[] additionalInfo) {
        String message = msg != null ? msg.toString() : null;
        ExceptionDialog dlg = ExceptionDialog.createDialog(window, title, throwable, message, additionalInfo);
        dlg.setVisible(true);
    }

    private static void showSimpleErrorDialog(Window window, String title, Object msg) {
        JOptionPane.showOptionDialog(window, msg, title, 0, 0, null, CLOSE, CLOSE[0]);
    }

    public static void showErrorDialog(Window window, String title, Object msg) {
        StandardErrorDialogs.showErrorDialog(window, title, msg, null);
    }

    public static void showErrorDialog(Window window, String title, Throwable throwable) {
        StandardErrorDialogs.showErrorDialog(window, title, null, throwable);
    }

    public static void showErrorDialog(Window window, Object msg, Throwable throwable) {
        StandardErrorDialogs.showErrorDialog(window, LNG.get((String)"UTIL_EXECUTION_ERROR"), msg, throwable);
    }

    public static void showErrorDialog(Window window, Throwable throwable) {
        StandardErrorDialogs.showErrorDialog(window, LNG.get((String)"UTIL_EXECUTION_ERROR"), throwable.getLocalizedMessage(), throwable);
    }
}

