/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util.charset;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import tecgraf.javautils.core.lng.LNG;

public class StandardCharsets {
    private static StandardCharsets instance;
    private final String[] charsetNames = new String[]{"US-ASCII", "ISO-8859-1", "UTF-8", "windows-1252", "MacRoman", "IBM500"};
    private final List<Charset> charsets = new ArrayList<Charset>();

    public final String getLegibleName(Charset charset) {
        Locale locale = LNG.getLocale();
        int index = this.findStandard(charset);
        if (index >= 0) {
            String stdName = this.charsetNames[index];
            String prefix = this.getClass().getSimpleName();
            String key = String.valueOf(prefix) + "." + stdName + ".name";
            if (LNG.hasKey((String)key)) {
                return LNG.get((String)key);
            }
        }
        String displayName = charset.displayName(locale);
        return displayName;
    }

    public final List<Charset> getAllStandardCharsets() {
        return this.charsets;
    }

    private final int findStandard(Charset charset) {
        if (charset == null) {
            return -1;
        }
        List<Charset> chs = this.getAllStandardCharsets();
        int index = chs.indexOf(charset);
        return index;
    }

    public final boolean isStandard(Charset charset) {
        int index = this.findStandard(charset);
        boolean flag = index >= 0;
        return flag;
    }

    private StandardCharsets() {
        String[] stringArray = this.charsetNames;
        int n = this.charsetNames.length;
        int n2 = 0;
        while (n2 < n) {
            Charset charset;
            String charsetName = stringArray[n2];
            if (Charset.isSupported(charsetName) && (charset = Charset.forName(charsetName)).isRegistered()) {
                this.charsets.add(charset);
            }
            ++n2;
        }
        Collections.unmodifiableList(this.charsets);
    }

    public static final StandardCharsets getInstance() {
        if (instance == null) {
            instance = new StandardCharsets();
        }
        return instance;
    }
}

