/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util.csvpanel;

import csbase.client.util.csvpanel.CSVExceptionNotification;
import csbase.client.util.csvpanel.CSVFileUtils;
import csbase.client.util.csvpanel.CSVTableModelNotification;
import csbase.client.util.csvpanel.menu.ColumnGeneratorPopupMenu;
import csbase.client.util.csvpanel.menu.ColumnHeaderPopupMenu;
import csbase.client.util.csvpanel.menu.RowHeaderPopupMenu;
import csbase.client.util.csvpanel.table.CSVTable;
import csbase.client.util.csvpanel.table.CSVTableModel;
import csbase.client.util.event.EventListener;
import csbase.client.util.event.EventManager;
import csbase.exception.OperationFailureException;
import csbase.logic.ClientFile;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.table.RowHeaderTablePane;

public class CSVPanel
extends JPanel {
    private ClientFile file;
    private EventManager eventManager = new EventManager();
    private CSVTable table;
    private RowHeaderTablePane rowHeaderScrollPane;
    private ColumnHeaderPopupMenu headerPopup;
    private ColumnGeneratorPopupMenu cellPopup;
    private RowHeaderPopupMenu rowPopup;

    public CSVPanel() {
        this.createUI();
        this.headerPopup = new ColumnHeaderPopupMenu(this.table);
        this.cellPopup = new ColumnGeneratorPopupMenu(this.table);
        this.rowPopup = new RowHeaderPopupMenu(this.table);
    }

    private void createUI() {
        this.setLayout(new GridLayout());
        this.table = new CSVTable();
        this.table.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (e.getFirstRow() != -1) {
                    CSVPanel.this.eventManager.fireEvent(new CSVTableModelNotification(e));
                }
                CSVPanel.this.updateRowHeader();
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    CSVPanel.this.cellPopup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        this.rowHeaderScrollPane = new RowHeaderTablePane((JTable)this.table, Collections.emptyList());
        this.rowHeaderScrollPane.setCorner("UPPER_LEFT_CORNER", (Component)new JButton());
        this.rowHeaderScrollPane.getRowHeader().getView().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    CSVPanel.this.rowPopup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        this.add((Component)this.rowHeaderScrollPane);
        JTableHeader header = this.table.getTableHeader();
        header.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    CSVPanel.this.headerPopup.show(e.getComponent(), e.getX(), e.getY());
                } else {
                    int clickCount = e.getClickCount();
                    if (clickCount == 1) {
                        CSVPanel.this.table.clearSelection();
                    }
                }
            }
        });
        this.validate();
    }

    private void updateRowHeader() {
        int rowCount = this.table.getRowCount();
        ArrayList<Integer> nums = new ArrayList<Integer>();
        int i = 1;
        while (i <= rowCount) {
            nums.add(i);
            ++i;
        }
        this.rowHeaderScrollPane.setRowNames(nums);
    }

    public void addExceptionListener(EventListener<CSVExceptionNotification> listener) {
        this.eventManager.addEventListener(listener, CSVExceptionNotification.class);
    }

    public void addCSVTableModelListener(EventListener<CSVTableModelNotification> listener) {
        this.eventManager.addEventListener(listener, CSVTableModelNotification.class);
    }

    public void openFile(ClientFile newFile, boolean editable) {
        this.closeFile();
        this.setFile(newFile, editable);
    }

    public void closeFile() {
        if (this.getFile() != null) {
            this.setFile(null, false);
        }
    }

    public ClientFile getFile() {
        return this.file;
    }

    private void setFile(ClientFile file, boolean editable) {
        this.file = file;
        String[][] data = this.loadData(file);
        this.reloadTable(data, editable);
    }

    private void reloadTable(String[][] data, boolean editable) {
        this.table.setData(data, editable);
    }

    public void setData(String[][] data, boolean editable) {
        this.closeFile();
        this.reloadTable(data, editable);
    }

    private String[][] loadData(ClientFile csvFile) {
        if (csvFile == null) {
            return null;
        }
        if (csvFile.size() <= 0L) {
            return null;
        }
        try {
            return CSVFileUtils.readCSVFile(this.getOwner(), csvFile);
        }
        catch (OperationFailureException e) {
            this.eventManager.fireEvent(new CSVExceptionNotification((Exception)((Object)e), this.getString("load.data.error")));
            return null;
        }
    }

    public Window getOwner() {
        return SwingUtilities.windowForComponent(this);
    }

    public String getTitle() {
        return this.getString("title");
    }

    private String getString(String key) {
        return LNG.get((String)(String.valueOf(CSVPanel.class.getName()) + "." + key));
    }

    public boolean isEditable() {
        return this.table.isEditable();
    }

    public void saveFile(ClientFile csvFile) {
        try {
            String[][] data = this.getData();
            CSVFileUtils.writeCSVFile(this.getOwner(), data, csvFile);
            this.file = csvFile;
        }
        catch (OperationFailureException e) {
            this.eventManager.fireEvent(new CSVExceptionNotification((Exception)((Object)e), this.getString("save.file.error")));
        }
    }

    private String[][] getData() {
        CSVTableModel tableModel = this.table.getModel();
        String[][] data = tableModel.getData();
        return data;
    }

    public void setNumRowsAsHeader(int numRowsAsHeader) {
        CSVTableModel tableModel = this.table.getModel();
        tableModel.setNumRowsAsHeader(numRowsAsHeader);
    }

    public int getNumRowsAsHeader() {
        CSVTableModel tableModel = this.table.getModel();
        return tableModel.getNumRowsAsHeader();
    }
}

