/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util.csvpanel.table;

import csbase.client.util.csvpanel.table.MultiHeaderTableModel;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class CSVTableModel
extends AbstractTableModel
implements TableModelListener {
    private DefaultTableModel realModel;
    private TableModel wrapperModel;
    private boolean editable;
    private int numRowsAsHeader;

    public CSVTableModel(String[][] data, boolean editable, int numRowsAsHeader) {
        this.numRowsAsHeader = numRowsAsHeader;
        this.editable = editable;
        this.realModel = new DefaultTableModel();
        this.realModel.addTableModelListener(this);
        this.updateWrapperModel();
        this.setData(data);
    }

    private void updateWrapperModel() {
        this.wrapperModel = this.realModel;
        if (this.numRowsAsHeader > 0) {
            this.wrapperModel = new MultiHeaderTableModel(this.wrapperModel, this.numRowsAsHeader);
        }
        this.fireTableStructureChanged();
    }

    public String[][] getData() {
        return CSVTableModel.convertToMatrix(this.realModel.getDataVector());
    }

    protected void setData(String[][] tableData) {
        Object[] columns = null;
        if (tableData != null && tableData.length > 0) {
            columns = new Object[tableData[0].length];
        }
        this.realModel.setDataVector(tableData, columns);
        this.fireTableStructureChanged();
    }

    protected static String[] convertToArray(Vector<?> vector) {
        if (vector == null) {
            return null;
        }
        return vector.toArray(new String[vector.size()]);
    }

    protected static String[][] convertToMatrix(Vector<?> vector) {
        if (vector == null) {
            return null;
        }
        String[][] array = new String[vector.size()][];
        int i = 0;
        while (i < array.length) {
            array[i] = CSVTableModel.convertToArray((Vector)vector.get(i));
            ++i;
        }
        return array;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setNumRowsAsHeader(int numRowsAsHeader) {
        if (this.numRowsAsHeader != numRowsAsHeader) {
            this.numRowsAsHeader = numRowsAsHeader >= 0 && numRowsAsHeader <= this.realModel.getRowCount() ? numRowsAsHeader : 0;
            this.updateWrapperModel();
        }
    }

    public int getNumRowsAsHeader() {
        return this.numRowsAsHeader;
    }

    @Override
    public int getRowCount() {
        return this.wrapperModel.getRowCount();
    }

    @Override
    public int getColumnCount() {
        return this.wrapperModel.getColumnCount();
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.wrapperModel.getColumnName(columnIndex);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.wrapperModel.getColumnClass(columnIndex);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.wrapperModel.getValueAt(rowIndex, columnIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.wrapperModel.setValueAt(aValue, rowIndex, columnIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (!this.editable) {
            return false;
        }
        return this.wrapperModel.isCellEditable(rowIndex, columnIndex);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        int firstRow = this.convertRealToWrapperModelIndex(e.getFirstRow());
        int lastRow = this.convertRealToWrapperModelIndex(e.getLastRow());
        TableModelEvent event = new TableModelEvent(this, firstRow, lastRow, e.getColumn(), e.getType());
        this.fireTableChanged(event);
    }

    public void addColumn(int col) {
        int index = col;
        Vector<Vector> dataVector = this.realModel.getDataVector();
        int i = 0;
        while (i < dataVector.size()) {
            Vector row = dataVector.get(i);
            row.add(index, null);
            ++i;
        }
        String[][] data = this.getData();
        this.setData(data);
    }

    public void removeColumn(int col) {
        int index = col;
        Vector<Vector> dataVector = this.realModel.getDataVector();
        int i = 0;
        while (i < dataVector.size()) {
            Vector row = dataVector.get(i);
            row.remove(index);
            ++i;
        }
        String[][] data = this.getData();
        this.setData(data);
    }

    public void removeRow(int row) {
        int index = this.convertWrapperToRealModelIndex(row);
        this.realModel.removeRow(index);
    }

    public void addRow(int row) {
        int index = this.convertWrapperToRealModelIndex(row);
        this.realModel.insertRow(index, (Object[])null);
    }

    public void duplicateRow(int row) {
        int index = this.convertWrapperToRealModelIndex(row);
        Vector dataRow = this.realModel.getDataVector().get(index);
        this.realModel.insertRow(index, dataRow.toArray(new Object[dataRow.size()]));
    }

    private int convertWrapperToRealModelIndex(int row) {
        if (row >= 0) {
            return row + this.numRowsAsHeader;
        }
        return row;
    }

    private int convertRealToWrapperModelIndex(int row) {
        if (row >= 0) {
            return Math.max(row - this.numRowsAsHeader, 0);
        }
        return row;
    }
}

