/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util.gui.log;

import csbase.client.Client;
import csbase.client.applications.ApplicationImages;
import csbase.client.desktop.RemoteTask;
import csbase.client.remote.ClientRemoteMonitor;
import csbase.client.util.event.EventListener;
import csbase.client.util.event.EventManager;
import csbase.client.util.event.IEvent;
import csbase.client.util.gui.log.AutoReloadable;
import csbase.client.util.gui.log.LogPanelReloader;
import csbase.client.util.gui.log.LogPanelTextArea;
import csbase.client.util.gui.log.LogPanelToolBar;
import csbase.exception.BugException;
import csbase.exception.CSBaseRuntimeException;
import csbase.exception.PermissionException;
import csbase.exception.ServiceFailureException;
import csbase.exception.UnavailableServiceException;
import csbase.logic.ClientProjectFile;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.rmi.RemoteException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.SwingThreadDispatcher;

public class LogPanel
extends JPanel
implements AutoReloadable {
    public static final int OPEN_CLOSE = 1;
    public static final int RELOAD = 2;
    public static final int EXPORT = 3;
    public static final int PAGING = 4;
    public static final long FIRST_PAGE = 1L;
    public static final int DEFAULT_PAGE_SIZE_KB = 100;
    private final int pageSize;
    private final LogPanelReloader reloader;
    private final LogPanelTextArea textArea;
    private final EventManager eventManager;
    private JToolBar toolBar;
    private final AtomicBoolean fileNotFound;
    private ClientProjectFile file;
    private long pagesCount;
    private long page;

    public static final LogPanel createLogPanelWithCompleteToolBar(int pageSizeKb) {
        return LogPanel.createLogPanelWithToolBar(7, pageSizeKb);
    }

    public static final LogPanel createLogPanelWithoutToolBar(int pageSizeKb) {
        return new LogPanel(pageSizeKb);
    }

    public static final LogPanel createLogPanelWithToolBar(int toolBarFlags, int pageSizeKb) {
        return new LogPanel(toolBarFlags, pageSizeKb);
    }

    public static final String getString(String tag, Object ... args) {
        String key = String.format("LogPanel.%s", tag);
        if (!LNG.hasKey((String)key)) {
            return null;
        }
        String format = LNG.get((String)key).trim();
        return String.format(format, args);
    }

    public void addFileEventListener(EventListener<FileEvent> listener) {
        this.eventManager.addEventListener(listener, FileEvent.class);
    }

    public void addPagingEventListener(EventListener<PagingEvent> listener) {
        this.eventManager.addEventListener(listener, PagingEvent.class);
    }

    public void addThrowableEventListener(EventListener<ThrowableEvent> listener) {
        this.eventManager.addEventListener(listener, ThrowableEvent.class);
    }

    public final void closeFile() {
        if (this.getFile() != null && this.setFile(null)) {
            this.eventManager.fireEvent(new FileEvent(this.file, FileEvent.Type.CLOSED));
            this.setPage(0L);
        }
    }

    public long countPages() {
        return this.pagesCount;
    }

    public final ClientProjectFile getFile() {
        return this.file;
    }

    public Window getOwner() {
        return SwingUtilities.windowForComponent(this);
    }

    public long getPageNumber() {
        return this.page;
    }

    @Override
    public final LogPanelReloader getReloader() {
        return this.reloader;
    }

    public final LogPanelTextArea getTextArea() {
        return this.textArea;
    }

    public String getTitle() {
        Window owner = this.getOwner();
        if (owner != null) {
            Class<?> clazz = owner.getClass();
            if (Frame.class.isAssignableFrom(clazz)) {
                return ((Frame)owner).getTitle();
            }
            if (Dialog.class.isAssignableFrom(clazz)) {
                return ((Dialog)owner).getTitle();
            }
        }
        return LogPanel.getString("title.default", new Object[0]);
    }

    public final JToolBar getToolBar() {
        return this.toolBar;
    }

    public void goToPage(long newPage) {
        if (this.reloadData()) {
            this.setPage(newPage);
        }
    }

    private String loadText() {
        block6: {
            block5: {
                try {
                    if (this.getFile() != null) break block5;
                    return null;
                }
                catch (Throwable t) {
                    this.eventManager.fireEvent(new ThrowableEvent(t));
                    return null;
                }
            }
            if (0L < this.getFile().size()) break block6;
            return "";
        }
        final StringBuilder stringBuffer = new StringBuilder(this.pageSize);
        final long jumpSize = (long)this.pageSize * (this.getPageNumber() - 1L);
        LogRemoteTask task = new LogRemoteTask(this){

            public void performTask() throws Exception {
                InputStream stream = this.getFile().getInputStream();
                InputStreamReader reader = new InputStreamReader(stream, Client.getInstance().getSystemDefaultCharset());
                reader.skip(jumpSize);
                char[] buffer = new char[pageSize];
                int nbytes = reader.read(buffer);
                if (nbytes > 0) {
                    stringBuffer.append(buffer, 0, nbytes);
                }
                reader.close();
            }
        };
        String msg = LogPanel.getString("loading.page.msg", new Object[0]);
        ImageIcon icon = ApplicationImages.ICON_OPEN_24;
        Window window = this.getOwner();
        String title = this.getTitle();
        boolean ok = task.execute(window, title, msg, icon);
        if (ok) {
            return stringBuffer.toString();
        }
        return null;
    }

    public final void openFile(ClientProjectFile newFile) {
        if (newFile == null) {
            String err = "Tentando abrir um arquivo inv\u00e1lido";
            throw new IllegalArgumentException("Tentando abrir um arquivo inv\u00e1lido");
        }
        this.closeFile();
        if (this.setFile(newFile)) {
            this.eventManager.fireEvent(new FileEvent(newFile, FileEvent.Type.OPENED));
            this.setPage(this.countPages());
            this.textArea.goToTail();
        }
    }

    private boolean reloadData() {
        if (!this.reloadFileFromServer()) {
            this.pagesCount = 0L;
            return false;
        }
        if (this.fileNotFound.get()) {
            this.pagesCount = 0L;
            this.eventManager.fireEvent(new FileEvent(this.getFile(), FileEvent.Type.NOT_FOUND));
            return false;
        }
        if (this.getFile() == null) {
            this.pagesCount = 0L;
        } else {
            long fileSize = this.getFile().size();
            this.pagesCount = (long)Math.ceil((double)fileSize / (double)this.pageSize);
            this.pagesCount = Math.max(1L, this.pagesCount);
        }
        return true;
    }

    @Override
    public void reload() {
        try {
            if (this.reloadData()) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        LogPanel.this.eventManager.fireEvent(new FileEvent(LogPanel.this.getFile(), FileEvent.Type.RELOADED));
                        LogPanel.this.setPage(LogPanel.this.countPages());
                        LogPanel.this.getTextArea().goToTail();
                    }
                };
                if (SwingThreadDispatcher.isEventDispatchThread()) {
                    runnable.run();
                } else {
                    SwingThreadDispatcher.invokeAndWait((Runnable)runnable);
                }
            }
        }
        catch (Exception e) {
            this.eventManager.fireEvent(new ThrowableEvent(e));
        }
    }

    private boolean reloadFileFromServer() {
        if (this.getFile() == null) {
            return true;
        }
        LogRemoteTask task = new LogRemoteTask(this){

            public void performTask() throws Exception {
                ClientProjectFile panelFile = this.getFile();
                if (panelFile != null && panelFile.exists()) {
                    panelFile.updateInfo();
                    fileNotFound.set(false);
                } else {
                    fileNotFound.set(true);
                }
            }
        };
        String msg = LogPanel.getString("loading.page.msg", new Object[0]);
        ImageIcon icon = ApplicationImages.ICON_OPEN_24;
        Window window = this.getOwner();
        String title = this.getTitle();
        return task.execute(window, title, msg, icon);
    }

    private boolean setFile(ClientProjectFile file) {
        this.file = file;
        return this.reloadData();
    }

    private void setPage(long newPage) {
        if (newPage > this.countPages()) {
            Window window = this.getOwner();
            String title = this.getTitle();
            String warningMsg = LogPanel.getString("dialog.warning.file.page.outOfBounds", newPage, this.countPages(), this.getFile().getName());
            Object[] buttons = new String[]{LogPanel.getString("button.ok", new Object[0])};
            JOptionPane.showOptionDialog(window, warningMsg, title, -1, 2, null, buttons, buttons[0]);
        }
        if (1L > newPage) {
            this.page = 0L;
            this.getTextArea().setText("");
        } else {
            this.page = Math.min(newPage, this.countPages());
            String text = this.loadText();
            if (text != null) {
                this.getTextArea().setText(text);
            }
        }
        this.eventManager.fireEvent(new PagingEvent(this.getPageNumber(), this.countPages()));
    }

    private LogPanel(int pageSizeKb) {
        int pageSizeBytes = pageSizeKb * 1024;
        int defaultSizeBytes = 102400;
        this.pageSize = pageSizeBytes < 0 ? 102400 : pageSizeBytes;
        this.eventManager = new EventManager();
        this.reloader = new LogPanelReloader(this);
        this.toolBar = null;
        this.textArea = this.createTextArea();
        this.fileNotFound = new AtomicBoolean(false);
        this.setLayout(new BorderLayout());
        this.add((Component)this.textArea, "Center");
    }

    private LogPanelTextArea createTextArea() {
        final LogPanelTextArea logTextArea = new LogPanelTextArea(this, true);
        logTextArea.setPrefix(this.getPageNumber());
        this.addPagingEventListener(new EventListener<PagingEvent>(){

            @Override
            public void eventFired(PagingEvent event) {
                long pg = event.getPageNumber();
                logTextArea.setPrefix(pg);
            }
        });
        return logTextArea;
    }

    private LogPanel(int toolBarFlags, int pageSize) {
        this(pageSize);
        this.toolBar = new LogPanelToolBar(this, toolBarFlags);
        this.add((Component)this.toolBar, "North");
    }

    public static class FileEvent
    implements IEvent {
        private final ClientProjectFile file;
        private final Type type;

        public ClientProjectFile getFile() {
            return this.file;
        }

        public Type getType() {
            return this.type;
        }

        FileEvent(ClientProjectFile file, Type type) {
            this.file = file;
            this.type = type;
        }

        public static enum Type {
            OPENED,
            CLOSED,
            RELOADED,
            NOT_FOUND;

        }
    }

    private abstract class LogRemoteTask
    extends RemoteTask<Void> {
        private LogRemoteTask() {
        }

        @Override
        protected final void handleError(Exception error) {
            if (error instanceof RemoteException) {
                ClientRemoteMonitor.getInstance().invalidate();
            }
            LogPanel.this.eventManager.fireEvent(new ThrowableEvent(error));
        }
    }

    public static class PagingEvent
    implements IEvent {
        private final long page;
        private final long countPages;

        public long countPages() {
            return this.countPages;
        }

        public long getPageNumber() {
            return this.page;
        }

        PagingEvent(long page, long countPages) {
            this.page = page;
            this.countPages = countPages;
        }
    }

    public static class ThrowableEvent
    implements IEvent {
        private final Throwable throwable;

        public String getMessage() {
            if (this.throwable instanceof CSBaseRuntimeException) {
                String msg = this.throwable.getMessage();
                if (msg != null) {
                    return msg;
                }
                if (this.throwable instanceof UnavailableServiceException) {
                    return LogPanel.getString("event.throwable.UnavailableServiceException", new Object[0]);
                }
                if (this.throwable instanceof ServiceFailureException) {
                    return LogPanel.getString("event.throwable.ServiceFailureException", new Object[0]);
                }
                if (this.throwable instanceof PermissionException) {
                    return LogPanel.getString("event.throwable.PermissionException", new Object[0]);
                }
                if (this.throwable instanceof BugException) {
                    return LogPanel.getString("event.throwable.BugException", new Object[0]);
                }
                return LogPanel.getString("event.throwable.unknown", new Object[0]);
            }
            if (this.throwable instanceof RemoteException) {
                return LogPanel.getString("event.throwable.RemoteException", new Object[0]);
            }
            if (this.throwable instanceof OutOfMemoryError) {
                return LogPanel.getString("event.throwable.OutOfMemoryError", new Object[0]);
            }
            return LogPanel.getString("event.throwable.clientbug", new Object[0]);
        }

        public Throwable getThrowable() {
            return this.throwable;
        }

        ThrowableEvent(Throwable throwable) {
            this.throwable = throwable;
        }
    }
}

