/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util.sga;

import csbase.client.Client;
import csbase.client.algorithms.tasks.ConfiguratorValidationTask;
import csbase.client.algorithms.validation.ValidationTranslator;
import csbase.client.applications.ApplicationImages;
import csbase.client.desktop.DesktopComponentDialog;
import csbase.client.desktop.RemoteTask;
import csbase.client.remote.srvproxies.SchedulerProxy;
import csbase.client.util.ClientUtilities;
import csbase.client.util.sga.CommandDescriptionHistory;
import csbase.client.util.sga.CommandRequestedListener;
import csbase.client.util.sga.SGAMultipleSelectionPanel;
import csbase.client.util.sga.SGASelectionListener;
import csbase.client.util.sga.SGASelectionPanel;
import csbase.client.util.sga.SGASingleSelectionPanel;
import csbase.logic.CommandInfo;
import csbase.logic.CommandSubmission;
import csbase.logic.CommonClientProject;
import csbase.logic.Priority;
import csbase.logic.SGASet;
import csbase.logic.algorithms.AlgorithmConfigurator;
import csbase.logic.algorithms.ExecutionType;
import csbase.logic.algorithms.flows.configurator.FlowAlgorithmConfigurator;
import csbase.logic.algorithms.validation.Validation;
import csbase.logic.algorithms.validation.ValidationMode;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import tecgraf.javautils.configurationmanager.Configuration;
import tecgraf.javautils.configurationmanager.ConfigurationManager;
import tecgraf.javautils.configurationmanager.ConfigurationManagerException;
import tecgraf.javautils.core.lng.LNG;

public class CommandExecutionDialog
extends DesktopComponentDialog {
    private static final String ENABLE_PRIORITY = "enable.priority";
    private SGASelectionPanel sgaPanel;
    private JButton executeButton;
    private JButton closeButton;
    private JLabel commandDescriptionLabel;
    private JTextField commandDescriptionTextField;
    private JComboBox previousCommandDescriptionComboBox;
    private JCheckBox emailCheckBox;
    private JPanel buttonPanel;
    private JLabel parameterStatusLabel;
    private JLabel sgaStatusLabel;
    private JLabel priorityLabel;
    private JComboBox priorityComboBox;
    private final CommonClientProject project;
    private final AlgorithmConfigurator configurator;
    private boolean enablePriority;
    private final List<CommandRequestedListener> listeners = new LinkedList<CommandRequestedListener>();
    private CommandDescriptionHistory commandDescriptionHistory;
    protected Validation validationResult;

    public CommandExecutionDialog(JFrame parentFrame, AlgorithmConfigurator configurator, CommonClientProject project) {
        super((Window)parentFrame);
        this.project = project;
        this.configurator = configurator;
        this.commandDescriptionHistory = new CommandDescriptionHistory();
        try {
            Configuration configuration = ConfigurationManager.getInstance().getConfiguration(this.getClass());
            this.enablePriority = configuration.getOptionalBooleanProperty(ENABLE_PRIORITY, false);
        }
        catch (ConfigurationManagerException e) {
            this.enablePriority = false;
        }
    }

    private void initUI() {
        this.validationResult = this.validateCommand();
        this.createGui();
        this.createSGASelectionPanel();
        this.updateParameterStatus();
        this.updateCanExecute();
        this.populatePanel();
        String commandDescription = this.configurator.getCommandDescription();
        if (commandDescription != null) {
            this.setCommandDescription(commandDescription);
        }
    }

    @Override
    public void setVisible(boolean visible) {
        if (!this.isVisible()) {
            this.initUI();
        }
        super.setVisible(visible);
    }

    protected Validation validateCommand() {
        Validation result = ConfiguratorValidationTask.runTask(this, this.configurator, ValidationMode.FULL);
        return result;
    }

    public void addCommandRequestedListener(CommandRequestedListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("O par\u00e2metro listener est\u00e1 nulo.");
        }
        this.listeners.add(listener);
    }

    public boolean removeCommandRequestedListener(CommandRequestedListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("O par\u00e2metro listener est\u00e1 nulo.");
        }
        return this.listeners.remove(listener);
    }

    private void createGui() {
        this.executeButton = new JButton(LNG.get((String)"CommandExecutionDialog.button.execute"));
        this.executeButton.setEnabled(false);
        this.executeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                CommandExecutionDialog.this.execute();
                CommandExecutionDialog.this.close();
            }
        });
        this.closeButton = new JButton(LNG.get((String)"CommandExecutionDialog.button.close"));
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                CommandExecutionDialog.this.close();
            }
        });
        this.buttonPanel = new JPanel(new FlowLayout());
        this.buttonPanel.add(this.executeButton);
        this.buttonPanel.add(this.closeButton);
        ClientUtilities.adjustEqualSizes(this.executeButton, this.closeButton);
        this.commandDescriptionLabel = new JLabel(LNG.get((String)"CommandExecutionDialog.label.command_description"));
        this.commandDescriptionTextField = new JTextField();
        this.addWindowFocusListener(new WindowAdapter(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                CommandExecutionDialog.this.commandDescriptionTextField.requestFocusInWindow();
                CommandExecutionDialog.this.commandDescriptionTextField.selectAll();
            }
        });
        String[] previousDescriptions = this.loadPreviousDescriptions();
        this.previousCommandDescriptionComboBox = new JComboBox<String>(previousDescriptions);
        this.previousCommandDescriptionComboBox.insertItemAt(LNG.get((String)"CommandExecutionDialog.combobox.previous_command_description"), 0);
        this.previousCommandDescriptionComboBox.setSelectedIndex(0);
        this.previousCommandDescriptionComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CommandExecutionDialog.this.previousCommandDescriptionComboBox.getSelectedIndex() != 0) {
                    CommandExecutionDialog.this.setCommandDescription(CommandExecutionDialog.this.previousCommandDescriptionComboBox.getSelectedItem().toString());
                }
            }
        });
        if (previousDescriptions.length > 0) {
            this.setCommandDescription(previousDescriptions[0]);
        } else {
            this.previousCommandDescriptionComboBox.setEnabled(false);
        }
        if (this.enablePriority) {
            this.priorityLabel = new JLabel(LNG.get((String)"CommandExecutionDialog.label.priority"));
            String[] priorityArray = new String[Priority.values().length];
            Priority[] priorityArray2 = Priority.values();
            int n = priorityArray2.length;
            int n2 = 0;
            while (n2 < n) {
                Priority p = priorityArray2[n2];
                priorityArray[p.ordinal()] = LNG.get((String)("CommandExecutionDialog.combobox." + p.name()));
                ++n2;
            }
            this.priorityComboBox = new JComboBox<String>(priorityArray);
            this.priorityComboBox.setSelectedIndex(Priority.getDefault().ordinal());
        }
        this.emailCheckBox = new JCheckBox(LNG.get((String)"CommandExecutionDialog.checkbox.email"));
        this.parameterStatusLabel = new JLabel();
        this.sgaStatusLabel = new JLabel();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                CommandExecutionDialog.this.close();
            }
        });
        this.setModal(false);
    }

    protected void updateParameterStatus() {
        if (!this.validationResult.isWellSucceded()) {
            String message = ValidationTranslator.translateMessage(this.validationResult);
            this.setParameterStatus(message, ApplicationImages.ICON_ERROR_16);
        } else if (this.configurator.getConfiguratorType() == AlgorithmConfigurator.ConfiguratorType.FLOW) {
            FlowAlgorithmConfigurator flowConfigurator = (FlowAlgorithmConfigurator)this.configurator;
            if (flowConfigurator.hasBypassedNodes()) {
                if (!flowConfigurator.canBeExecuted()) {
                    String text = LNG.get((String)"CommandExecutionDialog.label.bypass_not_possible_status");
                    this.setParameterStatus(text, ApplicationImages.ICON_ERROR_16);
                } else {
                    String text = LNG.get((String)"CommandExecutionDialog.label.bypassed_nodes_status");
                    this.setParameterStatus(text, ApplicationImages.ICON_INFORMATION_16);
                }
            } else {
                this.setParameterStatus(null, null);
            }
        } else if (this.configurator.isSetDefaultValues()) {
            String text = LNG.get((String)"CommandExecutionDialog.label.default_parameter_status");
            this.setParameterStatus(text, ApplicationImages.ICON_INFORMATION_16);
        }
    }

    private String[] loadPreviousDescriptions() {
        RemoteTask<String[]> task = new RemoteTask<String[]>(){

            protected void performTask() throws Exception {
                this.setResult(CommandExecutionDialog.this.commandDescriptionHistory.loadPreviousDescriptions());
            }
        };
        String message = LNG.get((String)"CommandExecutionDialog.task.message.loading_previous_descriptions");
        boolean success = task.execute(this.getOwner(), this.getTitle(), message);
        if (success) {
            return (String[])task.getResult();
        }
        return new String[0];
    }

    private void saveDescription(final String description) {
        if (description == null) {
            return;
        }
        RemoteTask<Void> task = new RemoteTask<Void>(){

            protected void performTask() throws Exception {
                CommandExecutionDialog.this.commandDescriptionHistory.saveDescription(description);
            }
        };
        String message = LNG.get((String)"CommandExecutionDialog.task.message.saving_description");
        task.execute(this.getOwner(), this.getTitle(), message);
    }

    protected void execute() {
        String clientName = Client.getInstance().getClientName();
        CommandSubmission commandSubmission = new CommandSubmission(this.configurator, this.project.getId(), clientName);
        this.submitCommand(commandSubmission);
    }

    protected void submitCommand(CommandSubmission commandSubmission) {
        boolean mailAtEnd = this.emailCheckBox.isSelected();
        commandSubmission.setMailAtEnd(mailAtEnd);
        String commandDescription = this.commandDescriptionTextField.getText();
        commandSubmission.setDescription(commandDescription);
        String platformFilter = this.sgaPanel.getPlatformFilter();
        commandSubmission.setPlatform(platformFilter);
        Priority priority = this.getSelectedPriority();
        commandSubmission.setPriority(priority);
        ExecutionType type = this.configurator.getExecutionType();
        switch (type) {
            case SIMPLE: {
                this.configureSimpleCommand(commandSubmission);
                break;
            }
            case MULTIPLE: {
                this.configureMultipleCommand(commandSubmission);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Tipo de execu\u00e7\u00e3o %s desconhecido.", type));
            }
        }
        this.submit(commandSubmission);
        this.saveDescription(commandDescription);
    }

    private Priority getSelectedPriority() {
        Priority priority = Priority.getDefault();
        if (this.enablePriority) {
            Priority[] priorityArray = Priority.values();
            int n = priorityArray.length;
            int n2 = 0;
            while (n2 < n) {
                Priority p = priorityArray[n2];
                if (p.ordinal() == this.priorityComboBox.getSelectedIndex()) {
                    priority = p;
                    break;
                }
                ++n2;
            }
        }
        return priority;
    }

    protected void updateCanExecute() {
        if (this.canExecute()) {
            this.executeButton.setEnabled(true);
        } else {
            this.executeButton.setEnabled(false);
        }
        if (this.sgaPanel.hasAvailableServers()) {
            this.setSGAStatus(" ", null);
        } else {
            String text = LNG.get((String)"CommandExecutionDialog.label.no_sga_available");
            this.setSGAStatus(text, ApplicationImages.ICON_ERROR_16);
        }
    }

    protected void setSGAStatus(String text, ImageIcon icon) {
        this.sgaStatusLabel.setText(text);
        this.sgaStatusLabel.setIcon(icon);
    }

    protected void setParameterStatus(String text, ImageIcon icon) {
        this.parameterStatusLabel.setText(text);
        this.parameterStatusLabel.setIcon(icon);
    }

    protected boolean canExecute() {
        return this.validationResult.isWellSucceded() && this.sgaPanel.isSelectionReady();
    }

    private void populatePanel() {
        Container contentPane = this.getContentPane();
        contentPane.removeAll();
        JPanel selectionPanel = new JPanel();
        selectionPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.gridx = 1;
        c.gridy = 1;
        c.gridwidth = 2;
        c.insets = new Insets(2, 2, 2, 2);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        selectionPanel.add((Component)this.sgaPanel, c);
        ++c.gridy;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.fill = 0;
        selectionPanel.add((Component)this.commandDescriptionLabel, c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        selectionPanel.add((Component)this.commandDescriptionTextField, c);
        c.fill = 0;
        c.gridx = 2;
        ++c.gridy;
        c.gridwidth = 2;
        c.weightx = 1.0;
        selectionPanel.add((Component)this.previousCommandDescriptionComboBox, c);
        if (this.enablePriority) {
            c.gridx = 1;
            ++c.gridy;
            c.gridwidth = 1;
            c.weightx = 0.0;
            c.fill = 0;
            selectionPanel.add((Component)this.priorityLabel, c);
            ++c.gridx;
            c.weightx = 1.0;
            selectionPanel.add((Component)this.priorityComboBox, c);
        }
        ++c.gridy;
        c.gridx = 1;
        c.gridwidth = 2;
        selectionPanel.add((Component)this.emailCheckBox, c);
        ++c.gridy;
        selectionPanel.add((Component)this.parameterStatusLabel, c);
        ++c.gridy;
        selectionPanel.add((Component)this.sgaStatusLabel, c);
        contentPane.add((Component)selectionPanel, "Center");
        contentPane.add((Component)this.buttonPanel, "South");
        contentPane.validate();
        this.getRootPane().setDefaultButton(this.executeButton);
        this.validate();
        this.pack();
        Dimension currentSize = this.getSize();
        int currentWidth = (int)currentSize.getWidth();
        int currentHeight = (int)currentSize.getHeight();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int screenWidth = (int)screenSize.getWidth();
        int screenHeight = (int)screenSize.getHeight();
        int newWidth = Math.min(currentWidth, screenWidth);
        int newHeight = Math.min(currentHeight, screenHeight);
        this.setSize(newWidth, newHeight);
        this.validate();
        this.center(this.getOwner());
    }

    private void createSGASelectionPanel() {
        ExecutionType type = this.configurator.getExecutionType();
        switch (type) {
            case SIMPLE: {
                this.sgaPanel = new SGASingleSelectionPanel(this.configurator);
                this.setTitle(LNG.get((String)"CommandExecutionDialog.title.simple"));
                break;
            }
            case MULTIPLE: {
                this.sgaPanel = new SGAMultipleSelectionPanel(this.configurator);
                this.setTitle(LNG.get((String)"CommandExecutionDialog.title.multiple"));
                break;
            }
            default: {
                throw new IllegalStateException("Tipo de execu\u00e7\u00e3o desconhecido: " + this.configurator.getExecutionType());
            }
        }
        this.sgaPanel.populateGUIComponents();
        this.sgaPanel.addSGASelectionListener(new SGASelectionListener(){

            @Override
            public void wasChangedPlatform() {
            }

            @Override
            public void wasChangedServer() {
                CommandExecutionDialog.this.updateCanExecute();
            }
        });
    }

    private void configureSimpleCommand(CommandSubmission commandSubmission) {
        Collection<SGASet> serverCollection = this.sgaPanel.getSelectedServerCollection();
        if (serverCollection != null) {
            SGASet sgaServer = serverCollection.iterator().next();
            commandSubmission.configureSimpleExecution(sgaServer.getName());
        } else {
            commandSubmission.configureSimpleExecution();
        }
    }

    private void configureMultipleCommand(CommandSubmission commandSubmission) {
        Collection<SGASet> serverCollection = this.sgaPanel.getSelectedServerCollection();
        if (serverCollection == null) {
            Integer executionCount = ((SGAMultipleSelectionPanel)this.sgaPanel).getExecutionCountForMultipleExecution();
            commandSubmission.configureMultipleExecution(executionCount.intValue());
        } else {
            LinkedList<String> serverList = new LinkedList<String>();
            for (SGASet sgaSet : serverCollection) {
                serverList.add(sgaSet.getName());
            }
            Integer executionCountPerSGA = ((SGAMultipleSelectionPanel)this.sgaPanel).getExecutionCountPerSGAForMultipleExecution();
            commandSubmission.configureMultipleExecution(serverList, executionCountPerSGA.intValue());
        }
    }

    private void submit(CommandSubmission commandSubmission) {
        Set<CommandInfo> submittedCommands = SchedulerProxy.submitCommand(this, commandSubmission);
        if (submittedCommands != null) {
            for (CommandRequestedListener listener : this.listeners) {
                listener.commandsWereRequested(submittedCommands);
            }
        }
    }

    private void setCommandDescription(String description) {
        this.commandDescriptionTextField.setText(description);
    }

    protected AlgorithmConfigurator getConfigurator() {
        return this.configurator;
    }

    protected CommonClientProject getProject() {
        return this.project;
    }
}

