/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util.sga;

import csbase.client.kernel.ClientException;
import csbase.client.util.sga.SGASelectionPanel;
import csbase.logic.SGASet;
import csbase.logic.algorithms.AlgorithmConfigurator;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.selector.ContainerSelection;
import tecgraf.javautils.gui.selector.ContainerSelectionListener;
import tecgraf.javautils.gui.table.DefaultObjectTableProvider;
import tecgraf.javautils.gui.table.ObjectTableProvider;

public class SGAMultipleSelectionPanel
extends SGASelectionPanel {
    private JLabel numServerLabel = new JLabel(LNG.get((String)"SGAMultipleSelectionPanel.label.num_exec"));
    private JTextField numServerTextField = new MyJTextField();
    private JLabel numExecLabel;
    private JTextField numExecTextField;
    private ContainerSelection<SGASet> sgaServerContainerSelection = this.makeSGASelectionContainer();
    private JPanel numCPUPanel = this.createLabeledTextPanel(this.numServerLabel, this.numServerTextField);
    private JPanel numExecPanel;

    public SGAMultipleSelectionPanel(AlgorithmConfigurator configurator) {
        super(configurator);
        this.numExecLabel = new JLabel(LNG.get((String)"SGAMultipleSelectionPanel.label.num_execution"));
        this.numExecTextField = new MyJTextField();
        this.numExecPanel = this.createLabeledTextPanel(this.numExecLabel, this.numExecTextField);
    }

    @Override
    public Collection<SGASet> getManualServerCollection() {
        return this.sgaServerContainerSelection.getSelectedItems();
    }

    @Override
    public SGASet getManualSelectedServer() {
        Collection<SGASet> serverCollection = this.getSelectedServerCollection();
        if (serverCollection.isEmpty()) {
            return null;
        }
        return serverCollection.iterator().next();
    }

    public Integer getExecutionCountForMultipleExecution() {
        if (this.numServerTextField.getText().equals("")) {
            return null;
        }
        return Integer.parseInt(this.numServerTextField.getText());
    }

    public Integer getExecutionCountPerSGAForMultipleExecution() {
        if (this.numExecTextField.getText().equals("")) {
            return null;
        }
        return Integer.parseInt(this.numExecTextField.getText());
    }

    @Override
    public boolean hasAvailableServers() {
        return this.sgaServerContainerSelection.hasItems();
    }

    @Override
    public boolean isSelectionReady() {
        if (!this.hasAvailableServers()) {
            return false;
        }
        if (!this.isManualServerSelection()) {
            return !this.numServerTextField.getText().equals("");
        }
        if (this.numExecTextField.getText().equals("")) {
            return false;
        }
        Collection<SGASet> serverCollection = this.getSelectedServerCollection();
        return !serverCollection.isEmpty();
    }

    @Override
    public void populateGUIComponents() {
        this.removeAll();
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.gridx = 1;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(2, 2, 2, 2);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        this.add((Component)this.platformFilterPanel, c);
        c.insets = new Insets(2, 2, 2, 2);
        c.gridx = 1;
        ++c.gridy;
        this.add((Component)this.automaticServerRadioButton, c);
        c.insets = new Insets(2, 20, 2, 2);
        ++c.gridy;
        this.add((Component)this.numCPUPanel, c);
        c.insets = new Insets(2, 2, 2, 2);
        c.gridx = 1;
        ++c.gridy;
        this.add((Component)this.manualServerRadioButton, c);
        c.insets = new Insets(2, 20, 2, 2);
        ++c.gridy;
        this.add((Component)this.numExecPanel, c);
        c.insets = new Insets(2, 20, 2, 2);
        c.fill = 2;
        ++c.gridy;
        this.add((Component)this.sgaServerContainerSelection.getPanel(), c);
        this.revalidate();
        this.updateEnabledServers();
    }

    private JPanel createLabeledTextPanel(JLabel label, JTextField textField) {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.insets = new Insets(2, 2, 2, 2);
        c.gridx = 1;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        panel.add((Component)label, c);
        c.weightx = 1.0;
        ++c.gridx;
        panel.add((Component)textField, c);
        return panel;
    }

    @Override
    public void updateEnabledServers() {
        if (this.hasAvailableServers()) {
            if (this.manualServerRadioButton.isSelected()) {
                this.sgaServerContainerSelection.setEnabled(true);
                this.numServerTextField.setText("");
                this.numServerLabel.setEnabled(false);
                this.numServerTextField.setEnabled(false);
                this.numExecLabel.setEnabled(true);
                this.numExecTextField.setText("1");
                this.numExecTextField.setEnabled(true);
            } else {
                this.sgaServerContainerSelection.setEnabled(false);
                this.numServerTextField.setEnabled(true);
                ((MyJTextField)this.numServerTextField).setText("1");
                this.numServerLabel.setEnabled(true);
                this.numExecTextField.setText("");
                this.numExecLabel.setEnabled(false);
                this.numExecTextField.setEnabled(false);
            }
            this.manualServerRadioButton.setEnabled(true);
            this.automaticServerRadioButton.setEnabled(true);
        } else {
            this.manualServerRadioButton.setEnabled(false);
            this.automaticServerRadioButton.setEnabled(false);
            this.numServerLabel.setEnabled(false);
            this.sgaServerContainerSelection.setEnabled(false);
            this.numServerTextField.setEnabled(false);
            this.numExecLabel.setEnabled(false);
            this.numExecTextField.setEnabled(false);
        }
    }

    @Override
    public void reloadSGAs() {
        try {
            this.sgaServerContainerSelection.loadItems(this.loadServers());
            this.updateEnabledServers();
        }
        catch (ClientException e) {
            e.printStackTrace();
        }
    }

    public ContainerSelection<SGASet> makeSGASelectionContainer() {
        ContainerSelection container = null;
        try {
            Vector<SGASet> sgas = this.loadServers();
            boolean showPlats = false;
            Iterator<SGASet> sgasIterator = sgas.iterator();
            if (sgasIterator.hasNext()) {
                SGASet sga = sgasIterator.next();
                String platform = sga.getPlatformId();
                while (sgasIterator.hasNext()) {
                    sga = sgasIterator.next();
                    if (platform.equals(sga.getPlatformId())) continue;
                    showPlats = true;
                    break;
                }
            }
            container = new ContainerSelection((ObjectTableProvider)new SGASetTableProvider(LNG.get((String)"MON_GROUP_SERVERS_TITLE"), showPlats), (ObjectTableProvider)new SGASetTableProvider(LNG.get((String)"MON_GROUP_SERVERS_TITLE"), showPlats), true, false, LNG.get((String)"MON_GROUP_SELECTABLE_SERVERS"), LNG.get((String)"MON_GROUP_SELECTED_SERVERS"));
            container.loadItems(sgas);
            container.adjustTableColumns();
            container.addContainerSelectionListener(new ContainerSelectionListener(){

                public void containerChanged() {
                    SGAMultipleSelectionPanel.this.fireChangedServer();
                }
            });
        }
        catch (ClientException e) {
            e.printStackTrace();
        }
        return container;
    }

    private class MyJTextField
    extends JTextField {
        public MyJTextField() {
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent ev) {
                    if (!Character.isDigit(ev.getKeyChar()) && ev.getKeyChar() != '\b') {
                        ev.consume();
                    }
                }

                @Override
                public void keyReleased(KeyEvent ev) {
                    if (Character.isDigit(ev.getKeyChar()) || ev.getKeyChar() == '\b' || ev.getKeyChar() == '\u007f') {
                        SGAMultipleSelectionPanel.this.fireChangedServer();
                    }
                }
            });
            this.setColumns(5);
        }
    }

    private class SGASetTableProvider
    extends DefaultObjectTableProvider {
        private String columnTitle;
        private boolean showPlats;

        private SGASetTableProvider(String columnTitle, boolean showPlats) {
            this.columnTitle = columnTitle;
            this.showPlats = showPlats;
        }

        private SGASetTableProvider(String columnTitle) {
            this(columnTitle, false);
        }

        public String[] getColumnNames() {
            if (this.showPlats) {
                return new String[]{this.columnTitle, LNG.get((String)"MON_GROUP_SERVERS_PLATFORM")};
            }
            return new String[]{this.columnTitle};
        }

        public Class<?>[] getColumnClasses() {
            if (this.showPlats) {
                return new Class[]{String.class, String.class};
            }
            return new Class[]{String.class};
        }

        public Object[] getCellValues(Object arg0) {
            SGASet sgaSet = (SGASet)arg0;
            if (this.showPlats) {
                return new String[]{sgaSet.getName(), sgaSet.getPlatformId()};
            }
            return new String[]{sgaSet.getName()};
        }
    }
}

