package csbase.client.algorithms.commands.view;

import javax.swing.JPanel;

/**
 * Representa uma aba da viso.
 */
public abstract class Tab extends JPanel {

  /**
   * Indica se a aba  a que est selecionada no momento.
   */
  boolean isSelected;

  /**
   * Retorna o ttulo da aba.
   * 
   * @return O ttulo da aba.
   */
  protected abstract String getTitle();

  /**
   * Determina se esta aba est selecionada.
   * 
   * @param selected Verdadeiro se a aba est selecionada ou falso, caso
   *        contrrio.
   */
  protected void setSelected(boolean selected) {
    this.isSelected = selected;
  }

  /**
   * Indica se a aba est selecionada.
   * 
   * @return Verdadeiro se a aba est selecionada ou falso, caso contrrio.
   */
  protected boolean isSelected() {
    return this.isSelected;
  }
}