/*
 * $Author:$ $Date:$ $Release:$
 */
package csbase.client.algorithms.parameters;

import java.awt.Window;

import csbase.logic.algorithms.parameters.IntegerListParameter;
import csbase.logic.algorithms.parameters.IntegerParameter;

/**
 * Viso para o {@link IntegerListParameter Parmetro do Tipo Lista de Inteiros}
 *
 * @author lmoreira
 */
public final class IntegerListParameterView extends ListParameterView<Integer> {

  /**
   * Cria uma viso em modo {@link ParameterView.Mode#CONFIGURATION}.
   *
   * @param window NO EST SENDO UTILIZADO. Existe somente para manter
   *        compatibilidade com o WebSintesi.
   * @param parameter O parmetro (No aceita {@code null}).
   *
   * @deprecated para manter compatibilidade com o WebSintesi
   */
  @Deprecated
  public IntegerListParameterView(Window window, IntegerListParameter parameter) {
    this(parameter, Mode.CONFIGURATION);
  }

  /**
   * Cria a viso.
   *
   * @param parameter O parmetro que  manipulado por esta viso (No aceita
   *        {@code null}).
   * @param mode Modo de visualizao. No aceita {@code null}, os possveis
   *        valores so: {@link ParameterView.Mode#CONFIGURATION} ou
   *        {@link ParameterView.Mode#REPORT}.
   */
  public IntegerListParameterView(IntegerListParameter parameter, Mode mode) {
    super(parameter, mode, new Parser<Integer>() {
      @Override
      public Integer parse(String text) {
        try {
          return Integer.parseInt(text);
        }
        catch (NumberFormatException e) {
          return null;
        }
      }
    }, new Formatter<Integer>() {
      @Override
      public String format(Integer element) {
        return element.toString();
      }
    }, new IntegerTextField(IntegerParameter.ERROR_VALUE));
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public IntegerListParameter getParameter() {
    return (IntegerListParameter) super.getParameter();
  }

}
