package csbase.client.algorithms.validation;

import csbase.logic.algorithms.validation.ElementValidationResult;
import csbase.logic.algorithms.validation.LocalizedMessage;
import csbase.logic.algorithms.validation.Validation;
import csbase.logic.algorithms.validation.ValidationSuccess;

/**
 * Resultado da validao de um elemento do tipo {@link ViewValidator}
 */
public class ViewValidationResult extends
  ElementValidationResult<ViewValidator> {

  /**
   * Construtor de uma validao bem sucedida de um elemento de viso.
   * 
   * @param element o elemento.
   */
  public ViewValidationResult(ViewValidator element) {
    super(new ValidationSuccess(), element);
  }

  /**
   * Construtor de uma validao mal sucedida de um elemento de viso.
   * 
   * @param errorMessage mensagem de erro da validao.
   * @param element o elemento.
   */
  public ViewValidationResult(LocalizedMessage errorMessage,
    ViewValidator element) {
    super(errorMessage, element);
  }

  /**
   * Contrutor para facilitar o encapsulamento de um outro resultado de
   * validao.
   * 
   * @param result outro resultado de validao.
   * @param element o elemento validado.
   */
  public ViewValidationResult(Validation result, ViewValidator element) {
    super(result, element);
  }

}
