package csbase.client.applicationmanager;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;

import csbase.client.preferences.PreferenceEditor;
import csbase.client.preferences.PreferenceValue;

/**
 * Editor da preferncia da localizao da cache do CSDK.
 */
public class CSDKCacheLocationPreferenceEditor extends PreferenceEditor<String> {

  /**
   * Construtor.
   * 
   * @param pv Valor da preferncia.
   */
  public CSDKCacheLocationPreferenceEditor(final PreferenceValue<String> pv) {
    super(pv);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected JComponent createComponent() {
    final JComboBox comboBox = new JComboBox(CSDKCacheLocation.values());
    CSDKCacheLocation location;
    try {
      location = CSDKCacheLocation.valueOf(getValue());
    }
    catch (Exception e) {
      location = null;
    }
    if (location != null) {
      comboBox.setSelectedItem(location);
    }
    else {
      comboBox.setSelectedIndex(-1);
    }

    comboBox.setRenderer(new CSDKCacheLocationRenderer());
    comboBox.addItemListener(new ItemListener() {
      @Override
      public void itemStateChanged(ItemEvent e) {
        final CSDKCacheLocation cacheLocation =
          (CSDKCacheLocation) comboBox.getSelectedItem();
        if (cacheLocation == null) {
          setValue(null);
        }
        else {
          setValue(cacheLocation.name());
        }
        notifyListeners();
      }
    });

    comboBox.setEnabled(isEditable());
    return comboBox;
  }

  /**
   * Renderer da combo box de localizaes da cache.
   */
  class CSDKCacheLocationRenderer extends DefaultListCellRenderer {

    /**
     * {@inheritDoc}
     */
    @Override
    public Component getListCellRendererComponent(final JList list,
      final Object value, final int index, final boolean isSelected,
      final boolean cellHasFocus) {
      JLabel label =
        (JLabel) super.getListCellRendererComponent(list, value, index,
          isSelected, cellHasFocus);
      if (value != null) {
        final CSDKCacheLocation location = (CSDKCacheLocation) value;
        label.setText(location.getDescription());
      }
      return label;
    }

  }

}
